/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.moonlight.api.trades;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.BiFunction;
import net.mehvahdjukaar.moonlight.api.trades.ModItemListing;
import net.mehvahdjukaar.moonlight.core.Moonlight;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.trading.ItemCost;
import net.minecraft.world.item.trading.MerchantOffer;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;

public record SimpleItemListing(ItemCost price, Optional<ItemCost> price2, ItemStack offer, int maxTrades, int xp, float priceMult, int level, LootItemFunction func) implements ModItemListing
{
    public static final MapCodec<SimpleItemListing> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)ItemCost.CODEC.fieldOf("price").forGetter(SimpleItemListing::price), (App)ItemCost.CODEC.optionalFieldOf("price_secondary").forGetter(SimpleItemListing::price2), (App)ItemStack.CODEC.fieldOf("offer").forGetter(SimpleItemListing::offer), (App)ExtraCodecs.POSITIVE_INT.optionalFieldOf("max_trades", (Object)16).forGetter(SimpleItemListing::maxTrades), (App)ExtraCodecs.POSITIVE_INT.optionalFieldOf("xp").forGetter(s -> Optional.of(s.xp)), (App)ExtraCodecs.POSITIVE_FLOAT.optionalFieldOf("price_multiplier", (Object)Float.valueOf(0.05f)).forGetter(SimpleItemListing::priceMult), (App)Codec.intRange((int)1, (int)5).optionalFieldOf("level", (Object)1).forGetter(SimpleItemListing::level)).apply((Applicative)instance, SimpleItemListing::createDefault));

    public SimpleItemListing(ItemCost price, ItemStack forSale, int maxTrades, int xp, float priceMult) {
        this(price, Optional.empty(), forSale, maxTrades, xp, priceMult, 1, null);
    }

    public SimpleItemListing(int emeralds, ItemStack forSale, int maxTrades, int xp, float mult) {
        this(new ItemCost((ItemLike)Items.EMERALD, emeralds), forSale, maxTrades, xp, mult);
    }

    public SimpleItemListing(int emeralds, ItemStack forSale, int maxTrades, int xp) {
        this(new ItemCost((ItemLike)Items.EMERALD, emeralds), forSale, maxTrades, xp, 0.05f);
    }

    public static SimpleItemListing createDefault(ItemCost price, Optional<ItemCost> price2, ItemStack offer, int maxTrades, Optional<Integer> xp, float priceMult, int level) {
        boolean buying = offer.is(Items.EMERALD);
        return new SimpleItemListing(price, price2, offer, maxTrades, xp.orElse(ModItemListing.defaultXp(buying, level)), priceMult, level, null);
    }

    public MerchantOffer getOffer(Entity entity, RandomSource randomSource) {
        Level level;
        AtomicReference<ItemStack> stack = new AtomicReference<ItemStack>();
        stack.set(this.offer);
        if (this.func != null && (level = entity.level()) instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            LootParams lootParams = new LootParams.Builder(serverLevel).withParameter(LootContextParams.ORIGIN, (Object)entity.position()).withParameter(LootContextParams.THIS_ENTITY, (Object)entity).create(LootContextParamSets.GIFT);
            LootContext context = new LootContext.Builder(lootParams).create(Optional.of(Moonlight.res("trading_sequence")));
            LootItemFunction.decorate((BiFunction)this.func, stack::set, (LootContext)context).accept(this.offer.copy());
        }
        return new MerchantOffer(this.price, this.price2, (ItemStack)stack.get(), this.maxTrades, this.xp, this.priceMult);
    }

    @Override
    public int getLevel() {
        return this.level;
    }

    public MapCodec<SimpleItemListing> getCodec() {
        return CODEC;
    }
}

