/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.moonlight.api.util;

import net.mehvahdjukaar.moonlight.core.mixins.accessor.DispenserBlockAccessor;
import net.mehvahdjukaar.moonlight.core.mixins.accessor.DispenserBlockEntityAccessor;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.core.dispenser.BlockSource;
import net.minecraft.core.dispenser.DefaultDispenseItemBehavior;
import net.minecraft.core.dispenser.DispenseItemBehavior;
import net.minecraft.core.dispenser.OptionalDispenseItemBehavior;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.WorldlyContainer;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.context.DirectionalPlaceContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.DispenserBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.DispenserBlockEntity;
import net.minecraft.world.level.block.state.properties.Property;

public class DispenserHelper {
    public static final DefaultDispenseItemBehavior PLACE_BLOCK_BEHAVIOR = new PlaceBlockDispenseBehavior();
    private static final DefaultDispenseItemBehavior SHOOT_BEHAVIOR = new DefaultDispenseItemBehavior();

    public static void registerCustomBehavior(AdditionalDispenserBehavior behavior) {
        DispenserBlock.registerBehavior((ItemLike)behavior.item, (DispenseItemBehavior)behavior);
    }

    public static void registerPlaceBlockBehavior(ItemLike block) {
        DispenserBlock.registerBehavior((ItemLike)block, (DispenseItemBehavior)PLACE_BLOCK_BEHAVIOR);
    }

    public static abstract class AdditionalDispenserBehavior
    implements DispenseItemBehavior {
        private final DispenseItemBehavior fallback;
        private final Item item;

        protected AdditionalDispenserBehavior(Item item) {
            this.item = item;
            this.fallback = DispenserBlockAccessor.getDispenserRegistry().get(item);
        }

        public final ItemStack dispense(BlockSource source, ItemStack stack) {
            try {
                InteractionResultHolder<ItemStack> result = this.customBehavior(source, stack);
                InteractionResult type = result.getResult();
                if (type != InteractionResult.PASS) {
                    boolean success = type.consumesAction();
                    this.playSound(source, success);
                    this.playAnimation(source, (Direction)source.state().getValue((Property)DispenserBlock.FACING));
                    if (success) {
                        ItemStack resultStack = (ItemStack)result.getObject();
                        if (resultStack.getItem() == stack.getItem()) {
                            return resultStack;
                        }
                        return this.fillItemInDispenser(source, stack, (ItemStack)result.getObject());
                    }
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            return this.fallback.dispense(source, stack);
        }

        protected abstract InteractionResultHolder<ItemStack> customBehavior(BlockSource var1, ItemStack var2);

        protected void playSound(BlockSource source, boolean success) {
            source.level().levelEvent(success ? 1000 : 1001, source.pos(), 0);
        }

        protected void playAnimation(BlockSource source, Direction direction) {
            source.level().levelEvent(2000, source.pos(), direction.get3DDataValue());
        }

        private ItemStack fillItemInDispenser(BlockSource source, ItemStack empty, ItemStack filled) {
            empty.shrink(1);
            if (empty.isEmpty()) {
                return filled.copy();
            }
            if (!this.mergeDispenserItem(source.blockEntity(), filled)) {
                SHOOT_BEHAVIOR.dispense(source, filled.copy());
            }
            return empty;
        }

        private boolean mergeDispenserItem(DispenserBlockEntity te, ItemStack filled) {
            NonNullList<ItemStack> stacks = ((DispenserBlockEntityAccessor)te).getItems();
            for (int i = 0; i < te.getContainerSize(); ++i) {
                ItemStack s = (ItemStack)stacks.get(i);
                if (!s.isEmpty() && (s.getItem() != filled.getItem() || s.getMaxStackSize() <= s.getCount())) continue;
                filled.grow(s.getCount());
                te.setItem(i, filled);
                return true;
            }
            return false;
        }
    }

    public static class PlaceBlockDispenseBehavior
    extends OptionalDispenseItemBehavior {
        public ItemStack execute(BlockSource source, ItemStack stack) {
            this.setSuccess(false);
            Item item = stack.getItem();
            if (item instanceof BlockItem) {
                BlockItem bi = (BlockItem)item;
                Direction direction = (Direction)source.state().getValue((Property)DispenserBlock.FACING);
                BlockPos blockpos = source.pos().relative(direction);
                Direction direction1 = direction;
                InteractionResult result = bi.place((BlockPlaceContext)new DirectionalPlaceContext((Level)source.level(), blockpos, direction, stack, direction1));
                this.setSuccess(result.consumesAction());
            }
            return stack;
        }
    }

    public static class AddItemToInventoryBehavior
    extends AdditionalDispenserBehavior {
        public AddItemToInventoryBehavior(Item item) {
            super(item);
        }

        @Override
        protected InteractionResultHolder<ItemStack> customBehavior(BlockSource source, ItemStack stack) {
            BlockPos blockpos;
            ServerLevel world = source.level();
            BlockEntity te = world.getBlockEntity(blockpos = source.pos().relative((Direction)source.state().getValue((Property)DispenserBlock.FACING)));
            if (te instanceof WorldlyContainer) {
                WorldlyContainer tile = (WorldlyContainer)te;
                if (tile.canPlaceItem(0, stack)) {
                    if (tile.isEmpty()) {
                        tile.setItem(0, stack.split(1));
                    } else {
                        tile.getItem(0).grow(1);
                        stack.shrink(1);
                    }
                    return InteractionResultHolder.success((Object)stack);
                }
                return InteractionResultHolder.fail((Object)stack);
            }
            return InteractionResultHolder.pass((Object)stack);
        }
    }
}

