/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.moonlight.api.util;

import com.mojang.serialization.Codec;
import java.util.Locale;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.LingeringPotionItem;
import net.minecraft.world.item.PotionItem;
import net.minecraft.world.item.SplashPotionItem;
import org.jetbrains.annotations.Nullable;

public enum PotionBottleType implements StringRepresentable
{
    REGULAR,
    SPLASH,
    LINGERING;

    public static final Codec<PotionBottleType> CODEC;

    public ItemStack getDefaultItem() {
        return (switch (this.ordinal()) {
            default -> throw new MatchException(null, null);
            case 0 -> Items.POTION;
            case 2 -> Items.LINGERING_POTION;
            case 1 -> Items.SPLASH_POTION;
        }).getDefaultInstance();
    }

    public String getSerializedName() {
        return this.name().toLowerCase(Locale.ROOT);
    }

    @Nullable
    public static PotionBottleType get(Item potionItem) {
        if (potionItem instanceof SplashPotionItem) {
            return SPLASH;
        }
        if (potionItem instanceof LingeringPotionItem) {
            return LINGERING;
        }
        if (potionItem instanceof PotionItem) {
            return REGULAR;
        }
        return null;
    }

    public static PotionBottleType getOrDefault(Item filledContainer) {
        PotionBottleType type = PotionBottleType.get(filledContainer);
        return type != null ? type : REGULAR;
    }

    static {
        CODEC = StringRepresentable.fromValues(PotionBottleType::values);
    }
}

