/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.moonlight.core.fluid.neoforge;

import java.util.Map;
import net.mehvahdjukaar.moonlight.api.fluids.SoftFluid;
import net.mehvahdjukaar.moonlight.api.fluids.SoftFluidRegistry;
import net.mehvahdjukaar.moonlight.api.util.Utils;
import net.mehvahdjukaar.moonlight.neoforge.MoonlightForge;
import net.minecraft.core.Holder;
import net.minecraft.core.MappedRegistry;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.material.FlowingFluid;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.neoforge.fluids.BaseFlowingFluid;
import net.neoforged.neoforge.registries.DataPackRegistryEvent;

public class SoftFluidInternalImpl {
    public static void init() {
        IEventBus bus = MoonlightForge.getCurrentBus();
        bus.register(SoftFluidInternalImpl.class);
    }

    public static void registerExistingVanillaFluids(Map<Fluid, Holder<SoftFluid>> fluidMap, Map<Item, Holder<SoftFluid>> itemMap) {
        MappedRegistry reg = (MappedRegistry)SoftFluidRegistry.hackyGetRegistry();
        reg.unfreeze();
        for (Fluid f : BuiltInRegistries.FLUID) {
            try {
                FlowingFluid flowingFluid;
                if (f == null || f instanceof FlowingFluid && (flowingFluid = (FlowingFluid)f).getSource() != f || f instanceof BaseFlowingFluid.Flowing || f == Fluids.EMPTY || fluidMap.containsKey(f)) continue;
                SoftFluid sf = new SoftFluid((Holder<Fluid>)BuiltInRegistries.FLUID.wrapAsHolder((Object)f));
                Registry.register((Registry)reg, (ResourceLocation)Utils.getID(f), (Object)sf);
                Holder holder = reg.wrapAsHolder((Object)sf);
                fluidMap.put(f, (Holder<SoftFluid>)holder);
                Item bucket = f.getBucket();
                if (bucket == Items.AIR) continue;
                itemMap.put(bucket, (Holder<SoftFluid>)holder);
            }
            catch (Exception exception) {}
        }
        reg.freeze();
        for (SoftFluid v : SoftFluidRegistry.getValues()) {
            v.afterInit();
        }
    }

    @SubscribeEvent
    public static void registerDataPackRegistry(DataPackRegistryEvent.NewRegistry event) {
        event.dataPackRegistry(SoftFluidRegistry.KEY, SoftFluid.CODEC, SoftFluid.CODEC);
    }
}

