/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.moonlight.core.mixins;

import net.minecraft.core.Direction;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.phys.BlockHitResult;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={BlockPlaceContext.class})
public abstract class FixBlockPlaceContextMixin
extends UseOnContext {
    @Shadow
    protected boolean replaceClicked;

    protected FixBlockPlaceContextMixin(Player player, InteractionHand interactionHand, BlockHitResult blockHitResult) {
        super(player, interactionHand, blockHitResult);
    }

    @Inject(method={"getNearestLookingDirection()Lnet/minecraft/core/Direction;"}, at={@At(value="HEAD")}, cancellable=true)
    public void fixNotAccountingForNullPlayer1(CallbackInfoReturnable<Direction> cir) {
        if (this.getPlayer() == null) {
            cir.setReturnValue((Object)Direction.NORTH);
        }
    }

    @Inject(method={"getNearestLookingVerticalDirection()Lnet/minecraft/core/Direction;"}, at={@At(value="HEAD")}, cancellable=true)
    public void fixNotAccountingForNullPlayer2(CallbackInfoReturnable<Direction> cir) {
        if (this.getPlayer() == null) {
            cir.setReturnValue((Object)Direction.UP);
        }
    }

    @Inject(method={"getNearestLookingDirections()[Lnet/minecraft/core/Direction;"}, at={@At(value="HEAD")}, cancellable=true)
    public void fixNotAccountingForNullPlayer3(CallbackInfoReturnable<Direction[]> cir) {
        if (this.getPlayer() == null) {
            Direction[] directions = Direction.values();
            if (this.replaceClicked) {
                cir.setReturnValue((Object)directions);
            } else {
                int i;
                Direction direction = this.getClickedFace();
                for (i = 0; i < directions.length && directions[i] != direction.getOpposite(); ++i) {
                }
                if (i > 0) {
                    System.arraycopy(directions, 0, directions, 1, i);
                    directions[0] = direction.getOpposite();
                }
                cir.setReturnValue((Object)directions);
            }
        }
    }
}

