/*
 * Decompiled with CFR 0.152.
 */
package dev.latvian.mods.rhino;

import dev.latvian.mods.rhino.Context;
import dev.latvian.mods.rhino.FieldAndMethods;
import dev.latvian.mods.rhino.Function;
import dev.latvian.mods.rhino.JavaMembers;
import dev.latvian.mods.rhino.Kit;
import dev.latvian.mods.rhino.MemberBox;
import dev.latvian.mods.rhino.NativeArray;
import dev.latvian.mods.rhino.NativeJavaArray;
import dev.latvian.mods.rhino.NativeJavaMethod;
import dev.latvian.mods.rhino.NativeJavaObject;
import dev.latvian.mods.rhino.ScriptRuntime;
import dev.latvian.mods.rhino.Scriptable;
import dev.latvian.mods.rhino.ScriptableObject;
import dev.latvian.mods.rhino.Wrapper;
import dev.latvian.mods.rhino.type.TypeInfo;
import dev.latvian.mods.rhino.util.DefaultValueTypeHint;
import java.lang.reflect.Array;
import java.lang.reflect.Modifier;
import java.util.Map;

public class NativeJavaClass
extends NativeJavaObject
implements Function {
    static final String javaClassPropertyName = "__javaObject__";
    private Map<String, FieldAndMethods> staticFieldAndMethods;

    static Scriptable constructSpecific(Context cx, Scriptable scope, Object[] args, MemberBox ctor) {
        Object instance = NativeJavaClass.constructInternal(cx, scope, args, ctor);
        Scriptable topLevel = ScriptableObject.getTopLevelScope(scope);
        return cx.wrapNewObject(topLevel, instance, ctor.returnType);
    }

    static Object constructInternal(Context cx, Scriptable scope, Object[] args, MemberBox ctor) {
        TypeInfo[] argTypes = ctor.argTypeInfos;
        if (ctor.vararg) {
            Object varArgs;
            Object[] newArgs = new Object[argTypes.length];
            for (int i = 0; i < argTypes.length - 1; ++i) {
                newArgs[i] = cx.jsToJava(args[i], argTypes[i]);
            }
            if (args.length == argTypes.length && (args[args.length - 1] == null || args[args.length - 1] instanceof NativeArray || args[args.length - 1] instanceof NativeJavaArray)) {
                varArgs = cx.jsToJava(args[args.length - 1], argTypes[argTypes.length - 1]);
            } else {
                TypeInfo componentType = argTypes[argTypes.length - 1].componentType();
                varArgs = componentType.newArray(args.length - argTypes.length + 1);
                int len = Array.getLength(varArgs);
                for (int i = 0; i < len; ++i) {
                    Object value = cx.jsToJava(args[argTypes.length - 1 + i], componentType);
                    Array.set(varArgs, i, value);
                }
            }
            newArgs[argTypes.length - 1] = varArgs;
            args = newArgs;
        } else {
            Object[] origArgs = args;
            for (int i = 0; i < args.length; ++i) {
                Object arg = args[i];
                Object x = cx.jsToJava(arg, argTypes[i]);
                if (x == arg) continue;
                if (args == origArgs) {
                    args = (Object[])origArgs.clone();
                }
                args[i] = x;
            }
        }
        return ctor.newInstance(args, cx, scope);
    }

    private static Class<?> findNestedClass(Class<?> parentClass, String name) {
        String nestedClassName = parentClass.getName() + "$" + name;
        ClassLoader loader = parentClass.getClassLoader();
        if (loader == null) {
            return Kit.classOrNull(nestedClassName);
        }
        return Kit.classOrNull(loader, nestedClassName);
    }

    public NativeJavaClass(Context cx, Scriptable scope, Class<?> cl) {
        this(cx, scope, cl, false);
    }

    public NativeJavaClass(Context cx, Scriptable scope, Class<?> cl, boolean isAdapter) {
        super(scope, cl, null, isAdapter, cx);
    }

    @Override
    protected void initMembers(Context cx, Scriptable scope) {
        Class cl = (Class)this.javaObject;
        this.members = JavaMembers.lookupClass(cx, scope, cl, cl, this.isAdapter);
        this.staticFieldAndMethods = this.members.getFieldAndMethodsObjects(this, cl, true, cx);
    }

    @Override
    public String getClassName() {
        return "JavaClass";
    }

    @Override
    public boolean has(Context cx, String name, Scriptable start) {
        return this.members.has(name, true) || javaClassPropertyName.equals(name);
    }

    @Override
    public Object get(Context cx, String name, Scriptable start) {
        FieldAndMethods result;
        if (name.equals("prototype")) {
            return null;
        }
        if (this.staticFieldAndMethods != null && (result = this.staticFieldAndMethods.get(name)) != null) {
            return result;
        }
        if (this.members.has(name, true)) {
            return this.members.get(this, name, this.javaObject, true, cx);
        }
        Scriptable scope = ScriptableObject.getTopLevelScope(start);
        if (javaClassPropertyName.equals(name)) {
            return cx.wrap(scope, this.javaObject, TypeInfo.CLASS);
        }
        Class<?> nestedClass = NativeJavaClass.findNestedClass(this.getClassObject(), name);
        if (nestedClass != null) {
            Scriptable nestedValue = cx.wrapJavaClass(scope, nestedClass);
            nestedValue.setParentScope(this);
            return nestedValue;
        }
        throw this.members.reportMemberNotFound(name, cx);
    }

    @Override
    public void put(Context cx, String name, Scriptable start, Object value) {
        this.members.put(this, name, this.javaObject, value, true, cx);
    }

    @Override
    public Object[] getIds(Context cx) {
        return this.members.getIds(true);
    }

    public Class<?> getClassObject() {
        return (Class)super.unwrap();
    }

    @Override
    public Object getDefaultValue(Context cx, DefaultValueTypeHint hint) {
        if (hint == null || hint == DefaultValueTypeHint.STRING) {
            return this.toString();
        }
        if (hint == DefaultValueTypeHint.BOOLEAN) {
            return Boolean.TRUE;
        }
        if (hint == DefaultValueTypeHint.NUMBER) {
            return ScriptRuntime.NaNobj;
        }
        return this;
    }

    @Override
    public Object call(Context cx, Scriptable scope, Scriptable thisObj, Object[] args) {
        Object object;
        if (args.length == 1 && (object = args[0]) instanceof Scriptable) {
            Scriptable p = (Scriptable)object;
            Class<?> c = this.getClassObject();
            do {
                Object o;
                if (!(p instanceof Wrapper) || !c.isInstance(o = ((Wrapper)((Object)p)).unwrap())) continue;
                return p;
            } while ((p = p.getPrototype(cx)) != null);
        }
        return this.construct(cx, scope, args);
    }

    @Override
    public Scriptable construct(Context cx, Scriptable scope, Object[] args) {
        String msg;
        Class<?> classObject;
        block6: {
            classObject = this.getClassObject();
            int modifiers = classObject.getModifiers();
            if (!Modifier.isInterface(modifiers) && !Modifier.isAbstract(modifiers)) {
                NativeJavaMethod ctors = this.members.ctors;
                int index = ctors.findCachedFunction(cx, args);
                if (index < 0) {
                    String sig = NativeJavaMethod.scriptSignature(args);
                    throw Context.reportRuntimeError2("msg.no.java.ctor", classObject.getName(), sig, cx);
                }
                return NativeJavaClass.constructSpecific(cx, scope, args, ctors.methods[index]);
            }
            if (args.length == 0) {
                throw Context.reportRuntimeError0("msg.adapter.zero.args", cx);
            }
            Scriptable topLevel = ScriptableObject.getTopLevelScope(this);
            msg = "";
            try {
                Object v = topLevel.get(cx, "JavaAdapter", topLevel);
                if (v != NOT_FOUND) {
                    Function f = (Function)v;
                    Object[] adapterArgs = new Object[]{this, args[0]};
                    return f.construct(cx, topLevel, adapterArgs);
                }
            }
            catch (Exception ex) {
                String m = ex.getMessage();
                if (m == null) break block6;
                msg = m;
            }
        }
        throw Context.reportRuntimeError2("msg.cant.instantiate", msg, classObject.getName(), cx);
    }

    public String toString() {
        return "[JavaClass " + this.getClassObject().getName() + "]";
    }

    @Override
    public boolean hasInstance(Context cx, Scriptable value) {
        if (value instanceof Wrapper && !(value instanceof NativeJavaClass)) {
            Object instance = ((Wrapper)((Object)value)).unwrap();
            return this.getClassObject().isInstance(instance);
        }
        return false;
    }
}

