/*
 * Decompiled with CFR 0.152.
 */
package dev.latvian.mods.rhino.type;

import dev.latvian.mods.rhino.Callable;
import dev.latvian.mods.rhino.Context;
import dev.latvian.mods.rhino.NativeArray;
import dev.latvian.mods.rhino.NativeJavaList;
import dev.latvian.mods.rhino.NativeJavaObject;
import dev.latvian.mods.rhino.NativeMap;
import dev.latvian.mods.rhino.RhinoException;
import dev.latvian.mods.rhino.type.ClassTypeInfo;
import dev.latvian.mods.rhino.type.JSFixedArrayTypeInfo;
import dev.latvian.mods.rhino.type.JSObjectTypeInfo;
import dev.latvian.mods.rhino.type.JSOptionalParam;
import dev.latvian.mods.rhino.type.JSOrTypeInfo;
import dev.latvian.mods.rhino.type.TypeInfo;
import dev.latvian.mods.rhino.util.RemapForJS;
import dev.latvian.mods.rhino.util.wrap.TypeWrapperFactory;
import java.lang.reflect.Constructor;
import java.lang.reflect.RecordComponent;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;

public class RecordTypeInfo
extends ClassTypeInfo
implements TypeWrapperFactory<Object> {
    private static final Map<Class<?>, Object> GLOBAL_DEFAULT_VALUES = new IdentityHashMap();
    static final Map<Class<?>, RecordTypeInfo> CACHE;
    private Data data;
    private Constructor<?> constructor;
    private JSObjectTypeInfo objectTypeInfo;
    private JSFixedArrayTypeInfo arrayTypeInfo;

    public static <T> void setGlobalDefaultValue(Class<T> type, T value) {
        GLOBAL_DEFAULT_VALUES.put(type, value);
    }

    RecordTypeInfo(Class<?> type) {
        super(type);
    }

    public Data getData() {
        if (this.data == null) {
            RecordComponent[] rc = this.asClass().getRecordComponents();
            Component[] components = new Component[rc.length];
            HashMap<String, Component> componentMap = new HashMap<String, Component>();
            Object[] defaultArguments = new Object[rc.length];
            for (int i = 0; i < rc.length; ++i) {
                Component c;
                Type gt = rc[i].getGenericType();
                RemapForJS rename = rc[i].getAccessor().getDeclaredAnnotation(RemapForJS.class);
                components[i] = c = new Component(i, rename != null ? rename.value() : rc[i].getName(), TypeInfo.of(gt));
                componentMap.put(c.name, c);
                defaultArguments[i] = c.type.createDefaultValue();
                if (defaultArguments[i] != null) continue;
                defaultArguments[i] = GLOBAL_DEFAULT_VALUES.getOrDefault(rc[i].getType(), null);
            }
            this.data = new Data(components, Map.copyOf(componentMap), defaultArguments);
        }
        return this.data;
    }

    public JSObjectTypeInfo getObjectTypeInfo() {
        if (this.objectTypeInfo == null) {
            Data data = this.getData();
            ArrayList<JSOptionalParam> list = new ArrayList<JSOptionalParam>(data.components.length);
            for (Component c : data.components) {
                list.add(new JSOptionalParam(c.name, c.type, true));
            }
            this.objectTypeInfo = new JSObjectTypeInfo(List.copyOf(list));
        }
        return this.objectTypeInfo;
    }

    public JSFixedArrayTypeInfo getArrayTypeInfo() {
        if (this.arrayTypeInfo == null) {
            Data data = this.getData();
            ArrayList<JSOptionalParam> list = new ArrayList<JSOptionalParam>(data.components.length);
            for (Component c : data.components) {
                list.add(new JSOptionalParam(c.name, c.type, true));
            }
            this.arrayTypeInfo = new JSFixedArrayTypeInfo(List.copyOf(list));
        }
        return this.arrayTypeInfo;
    }

    public TypeInfo createCombinedType(TypeInfo ... preference) {
        ArrayList<TypeInfo> types = new ArrayList<TypeInfo>(2 + preference.length);
        types.addAll(Arrays.asList(preference));
        types.add(this.getObjectTypeInfo());
        types.add(this.getArrayTypeInfo());
        return new JSOrTypeInfo(types);
    }

    @Override
    public Map<String, Component> recordComponents() {
        return this.getData().componentMap;
    }

    public Constructor<?> getConstructor(Context cx) {
        if (this.constructor == null) {
            try {
                Data data = this.getData();
                Class[] types = new Class[data.components.length];
                for (int i = 0; i < data.components.length; ++i) {
                    types[i] = data.components[i].type.asClass();
                }
                this.constructor = this.asClass().getConstructor(types);
            }
            catch (Exception ex) {
                throw Context.reportRuntimeError("Unable to find record '" + this.asClass().getName() + "' constructor", cx);
            }
        }
        return this.constructor;
    }

    public Object createInstance(Context cx, Map<?, ?> map) {
        Data data = this.getData();
        Object[] args = (Object[])data.defaultArguments.clone();
        for (Map.Entry<?, ?> entry : map.entrySet()) {
            Component c = data.componentMap.get(String.valueOf(entry.getKey()));
            if (c == null) continue;
            if (args[c.index] == Optional.empty()) {
                args[c.index] = Optional.ofNullable(cx.jsToJava(entry.getValue(), c.type.param(0)));
                continue;
            }
            args[c.index] = cx.jsToJava(entry.getValue(), c.type);
        }
        try {
            return this.getConstructor(cx).newInstance(args);
        }
        catch (RhinoException rhinoException) {
        }
        catch (Exception ex) {
            throw Context.reportRuntimeError("Unable to create record '" + this.asClass().getName() + "' instance from map " + String.valueOf(map), cx);
        }
        return cx.reportConversionError(map, this);
    }

    public Object createInstance(Context cx, Object ... objects) {
        Data data = this.getData();
        Object[] args = (Object[])data.defaultArguments.clone();
        int alen = Math.min(args.length, objects.length);
        for (int i = 0; i < alen; ++i) {
            args[i] = args[i] == Optional.empty() ? Optional.ofNullable(cx.jsToJava(objects[i], data.components[i].type.param(0))) : cx.jsToJava(objects[i], data.components[i].type);
        }
        try {
            return this.getConstructor(cx).newInstance(args);
        }
        catch (RhinoException i) {
        }
        catch (Exception ex) {
            throw Context.reportRuntimeError("Unable to create record '" + this.asClass().getName() + "' instance from array " + Arrays.toString(objects), cx);
        }
        return cx.reportConversionError(objects, this);
    }

    @Override
    public Object wrap(Context cx, Object from, TypeInfo target) {
        if (this.asClass().isInstance(from)) {
            return from;
        }
        if (from instanceof NativeArray || from instanceof NativeJavaList) {
            Object[] arr = (Object[])cx.arrayOf(from, TypeInfo.NONE);
            return this.createInstance(cx, arr);
        }
        if (from instanceof Map || from instanceof NativeJavaObject || from instanceof NativeMap) {
            Map map = (Map)cx.mapOf(from, TypeInfo.STRING, TypeInfo.NONE);
            return this.createInstance(cx, map);
        }
        if (from instanceof Callable) {
            HashMap map = new HashMap();
            Consumer consumer = (Consumer)cx.jsToJava(from, TypeInfo.RAW_CONSUMER);
            consumer.accept(map);
            return this.createInstance(cx, map);
        }
        return cx.reportConversionError(from, target);
    }

    static {
        RecordTypeInfo.setGlobalDefaultValue(Optional.class, Optional.empty());
        RecordTypeInfo.setGlobalDefaultValue(List.class, List.of());
        RecordTypeInfo.setGlobalDefaultValue(Set.class, Set.of());
        RecordTypeInfo.setGlobalDefaultValue(Map.class, Map.of());
        CACHE = new IdentityHashMap();
    }

    public record Data(Component[] components, Map<String, Component> componentMap, Object[] defaultArguments) {
    }

    public record Component(int index, String name, TypeInfo type) {
    }
}

