/*
 * Decompiled with CFR 0.152.
 */
package quek.undergarden;

import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.world.level.block.Blocks;
import net.neoforged.neoforge.common.ModConfigSpec;
import org.apache.commons.lang3.tuple.Pair;

public class UndergardenConfig {
    static final ModConfigSpec COMMON_SPEC;
    public static final Common COMMON;
    static final ModConfigSpec CLIENT_SPEC;
    public static final Client CLIENT;

    static {
        Pair common = new ModConfigSpec.Builder().configure(Common::new);
        COMMON_SPEC = (ModConfigSpec)common.getRight();
        COMMON = (Common)common.getLeft();
        Pair client = new ModConfigSpec.Builder().configure(Client::new);
        CLIENT_SPEC = (ModConfigSpec)client.getRight();
        CLIENT = (Client)client.getLeft();
    }

    public static class Common {
        public static ModConfigSpec.ConfigValue<String> return_portal_frame_block_id;

        public Common(ModConfigSpec.Builder builder) {
            return_portal_frame_block_id = builder.comment("Determines what block the game will generate Undergarden return portals out of\nUse the block tag undergarden:portal_frame_blocks to determine what blocks portals can be built with\nIf value entered here is not a valid block it will default to generating minecraft:stone_bricks").translation("config.undergarden.return_portal_frame_block_id").define("Return Portal Frame Block ID", (Object)BuiltInRegistries.BLOCK.getKey((Object)Blocks.STONE_BRICKS).toString());
            builder.build();
        }
    }

    public static class Client {
        public static ModConfigSpec.ConfigValue<Boolean> toggle_undergarden_fog;

        public Client(ModConfigSpec.Builder builder) {
            toggle_undergarden_fog = builder.comment("Toggles the Undergarden's special fog parameters. Set  false to disable it, and return to the vanilla fog.").translation("config.undergarden.toggle_undergarden_fog").define("Toggle Undergarden Fog", true);
            builder.build();
        }
    }
}

