/*
 * Decompiled with CFR 0.152.
 */
package quek.undergarden.block;

import java.util.Optional;
import net.minecraft.BlockUtil;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.NetherPortalBlock;
import net.minecraft.world.level.block.Portal;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.border.WorldBorder;
import net.minecraft.world.level.dimension.DimensionType;
import net.minecraft.world.level.material.PushReaction;
import net.minecraft.world.level.portal.DimensionTransition;
import net.minecraft.world.level.portal.PortalShape;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.bus.api.Event;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.level.BlockEvent;
import org.jetbrains.annotations.Nullable;
import quek.undergarden.Undergarden;
import quek.undergarden.attachment.UndergardenPortalAttachment;
import quek.undergarden.registry.UGAttachments;
import quek.undergarden.registry.UGBlocks;
import quek.undergarden.registry.UGDimensions;
import quek.undergarden.registry.UGParticleTypes;
import quek.undergarden.registry.UGSoundEvents;
import quek.undergarden.registry.UGTags;
import quek.undergarden.world.UGPortalForcer;

public class UndergardenPortalBlock
extends Block
implements Portal {
    public static final EnumProperty<Direction.Axis> AXIS = BlockStateProperties.HORIZONTAL_AXIS;
    protected static final VoxelShape X_AABB = Block.box((double)0.0, (double)0.0, (double)6.0, (double)16.0, (double)16.0, (double)10.0);
    protected static final VoxelShape Z_AABB = Block.box((double)6.0, (double)0.0, (double)0.0, (double)10.0, (double)16.0, (double)16.0);

    public UndergardenPortalBlock() {
        super(BlockBehaviour.Properties.of().pushReaction(PushReaction.BLOCK).strength(-1.0f).noCollission().lightLevel(state -> 10).noLootTable());
        this.registerDefaultState((BlockState)((BlockState)this.stateDefinition.any()).setValue(AXIS, (Comparable)Direction.Axis.X));
    }

    public VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        switch ((Direction.Axis)state.getValue(AXIS)) {
            case Z: {
                return Z_AABB;
            }
        }
        return X_AABB;
    }

    public boolean trySpawnPortal(LevelAccessor level, BlockPos pos) {
        UGPortalShape size = this.isPortal(level, pos);
        if (size != null && !this.isPortalSpawnCanceled(level, pos, size)) {
            size.createPortalBlocks();
            return true;
        }
        return false;
    }

    public boolean isPortalSpawnCanceled(LevelAccessor world, BlockPos pos, UGPortalShape size) {
        return ((BlockEvent.PortalSpawnEvent)NeoForge.EVENT_BUS.post((Event)new BlockEvent.PortalSpawnEvent(world, pos, world.getBlockState(pos), (PortalShape)size))).isCanceled();
    }

    @javax.annotation.Nullable
    public UGPortalShape isPortal(LevelAccessor level, BlockPos pos) {
        UGPortalShape UndergardenPortalBlock$size = new UGPortalShape(level, pos, Direction.Axis.X);
        if (UndergardenPortalBlock$size.isValid() && UndergardenPortalBlock$size.numPortalBlocks == 0) {
            return UndergardenPortalBlock$size;
        }
        UGPortalShape UndergardenPortalBlock$size1 = new UGPortalShape(level, pos, Direction.Axis.Z);
        return UndergardenPortalBlock$size1.isValid() && UndergardenPortalBlock$size1.numPortalBlocks == 0 ? UndergardenPortalBlock$size1 : null;
    }

    public BlockState updateShape(BlockState state, Direction facing, BlockState facingState, LevelAccessor level, BlockPos currentPos, BlockPos facingPos) {
        Direction.Axis direction$axis = facing.getAxis();
        Direction.Axis direction$axis1 = (Direction.Axis)state.getValue(AXIS);
        boolean flag = direction$axis1 != direction$axis && direction$axis.isHorizontal();
        return !flag && facingState.getBlock() != this && !new UGPortalShape(level, currentPos, direction$axis1).isComplete() ? Blocks.AIR.defaultBlockState() : super.updateShape(state, facing, facingState, level, currentPos, facingPos);
    }

    public void entityInside(BlockState state, Level level, BlockPos pos, Entity entity) {
        if (entity.canUsePortal(false)) {
            entity.setAsInsidePortal((Portal)this, pos);
            if (entity instanceof Player) {
                Player player = (Player)entity;
                UndergardenPortalAttachment portal = (UndergardenPortalAttachment)player.getData(UGAttachments.UNDERGARDEN_PORTAL);
                portal.setInPortal(true);
                int waitTime = portal.getPortalTimer();
                if (waitTime >= this.getLevelPortalTransitionTime(level, (Entity)player)) {
                    portal.handleUndergardenPortal(player);
                    portal.setPortalTimer(0);
                }
            }
        }
    }

    public int getPortalTransitionTime(ServerLevel level, Entity entity) {
        return this.getLevelPortalTransitionTime((Level)level, entity);
    }

    private int getLevelPortalTransitionTime(Level level, Entity entity) {
        int n;
        if (entity instanceof Player) {
            Player player = (Player)entity;
            n = Math.max(1, level.getGameRules().getInt(player.getAbilities().invulnerable ? GameRules.RULE_PLAYERS_NETHER_PORTAL_CREATIVE_DELAY : GameRules.RULE_PLAYERS_NETHER_PORTAL_DEFAULT_DELAY));
        } else {
            n = 0;
        }
        return n;
    }

    @Nullable
    public DimensionTransition getPortalDestination(ServerLevel level, Entity entity, BlockPos pos) {
        ResourceKey<Level> resourcekey = level.dimension() == UGDimensions.UNDERGARDEN_LEVEL ? Level.OVERWORLD : UGDimensions.UNDERGARDEN_LEVEL;
        ServerLevel serverlevel = level.getServer().getLevel(resourcekey);
        if (serverlevel == null) {
            return null;
        }
        boolean flag = serverlevel.dimension() == UGDimensions.UNDERGARDEN_LEVEL;
        WorldBorder worldborder = serverlevel.getWorldBorder();
        double d0 = DimensionType.getTeleportationScale((DimensionType)level.dimensionType(), (DimensionType)serverlevel.dimensionType());
        BlockPos blockpos = worldborder.clampToBounds(entity.getX() * d0, entity.getY(), entity.getZ() * d0);
        return this.getExitPortal(serverlevel, entity, pos, blockpos, flag, worldborder);
    }

    @javax.annotation.Nullable
    private DimensionTransition getExitPortal(ServerLevel level, Entity entity, BlockPos pos, BlockPos exitPos, boolean isNether, WorldBorder worldBorder) {
        DimensionTransition.PostDimensionTransition dimensiontransition$postdimensiontransition;
        BlockUtil.FoundRectangle blockutil$foundrectangle;
        UGPortalForcer portalForcer = new UGPortalForcer(level);
        Optional<BlockPos> optional = portalForcer.findClosestPortalPosition(exitPos, isNether, worldBorder);
        if (optional.isPresent()) {
            BlockPos blockpos = optional.get();
            BlockState blockstate = level.getBlockState(blockpos);
            blockutil$foundrectangle = BlockUtil.getLargestRectangleAround((BlockPos)blockpos, (Direction.Axis)((Direction.Axis)blockstate.getValue((Property)BlockStateProperties.HORIZONTAL_AXIS)), (int)21, (Direction.Axis)Direction.Axis.Y, (int)21, p_351970_ -> level.getBlockState(p_351970_) == blockstate);
            dimensiontransition$postdimensiontransition = UGPortalForcer.PLAY_PORTAL_SOUND.then(p_351967_ -> p_351967_.placePortalTicket(blockpos));
        } else {
            Direction.Axis direction$axis = entity.level().getBlockState(pos).getOptionalValue(AXIS).orElse(Direction.Axis.X);
            Optional<BlockUtil.FoundRectangle> optional1 = portalForcer.createPortal(exitPos, direction$axis);
            if (optional1.isEmpty()) {
                Undergarden.LOGGER.error("Unable to create a portal, likely target out of worldborder");
                return null;
            }
            blockutil$foundrectangle = optional1.get();
            dimensiontransition$postdimensiontransition = UGPortalForcer.PLAY_PORTAL_SOUND.then(DimensionTransition.PLACE_PORTAL_TICKET);
        }
        return UndergardenPortalBlock.getDimensionTransitionFromExit(entity, pos, blockutil$foundrectangle, level, dimensiontransition$postdimensiontransition);
    }

    private static DimensionTransition getDimensionTransitionFromExit(Entity entity, BlockPos pos, BlockUtil.FoundRectangle rectangle, ServerLevel level, DimensionTransition.PostDimensionTransition postDimensionTransition) {
        Vec3 vec3;
        Direction.Axis direction$axis;
        BlockState blockstate = entity.level().getBlockState(pos);
        if (blockstate.hasProperty((Property)BlockStateProperties.HORIZONTAL_AXIS)) {
            direction$axis = (Direction.Axis)blockstate.getValue((Property)BlockStateProperties.HORIZONTAL_AXIS);
            BlockUtil.FoundRectangle blockutil$foundrectangle = BlockUtil.getLargestRectangleAround((BlockPos)pos, (Direction.Axis)direction$axis, (int)21, (Direction.Axis)Direction.Axis.Y, (int)21, p_351016_ -> entity.level().getBlockState(p_351016_) == blockstate);
            vec3 = entity.getRelativePortalPosition(direction$axis, blockutil$foundrectangle);
        } else {
            direction$axis = Direction.Axis.X;
            vec3 = new Vec3(0.5, 0.0, 0.0);
        }
        return UndergardenPortalBlock.createDimensionTransition(level, rectangle, direction$axis, vec3, entity, entity.getDeltaMovement(), entity.getYRot(), entity.getXRot(), postDimensionTransition);
    }

    private static DimensionTransition createDimensionTransition(ServerLevel level, BlockUtil.FoundRectangle rectangle, Direction.Axis axis, Vec3 offset, Entity entity, Vec3 speed, float yRot, float xRot, DimensionTransition.PostDimensionTransition postDimensionTransition) {
        BlockPos blockpos = rectangle.minCorner;
        BlockState blockstate = level.getBlockState(blockpos);
        Direction.Axis direction$axis = blockstate.getOptionalValue((Property)BlockStateProperties.HORIZONTAL_AXIS).orElse(Direction.Axis.X);
        double d0 = rectangle.axis1Size;
        double d1 = rectangle.axis2Size;
        EntityDimensions entitydimensions = entity.getDimensions(entity.getPose());
        int i = axis == direction$axis ? 0 : 90;
        Vec3 vec3 = axis == direction$axis ? speed : new Vec3(speed.z, speed.y, -speed.x);
        double d2 = (double)entitydimensions.width() / 2.0 + (d0 - (double)entitydimensions.width()) * offset.x();
        double d3 = (d1 - (double)entitydimensions.height()) * offset.y();
        double d4 = 0.5 + offset.z();
        boolean flag = direction$axis == Direction.Axis.X;
        Vec3 vec31 = new Vec3((double)blockpos.getX() + (flag ? d2 : d4), (double)blockpos.getY() + d3, (double)blockpos.getZ() + (flag ? d4 : d2));
        Vec3 vec32 = UGPortalShape.findCollisionFreePosition((Vec3)vec31, (ServerLevel)level, (Entity)entity, (EntityDimensions)entitydimensions);
        return new DimensionTransition(level, vec32, vec3, yRot + (float)i, xRot, postDimensionTransition);
    }

    public void animateTick(BlockState state, Level level, BlockPos pos, RandomSource random) {
        if (random.nextInt(100) == 0) {
            level.playLocalSound((double)pos.getX() + 0.5, (double)pos.getY() + 0.5, (double)pos.getZ() + 0.5, (SoundEvent)UGSoundEvents.UNDERGARDEN_PORTAL_AMBIENT.get(), SoundSource.BLOCKS, 0.5f, random.nextFloat() * 0.4f + 0.8f, false);
        }
        for (int i = 0; i < 4; ++i) {
            double x = (double)pos.getX() + random.nextDouble();
            double y = (double)pos.getY() + random.nextDouble();
            double z = (double)pos.getZ() + random.nextDouble();
            double xSpeed = ((double)random.nextFloat() - 0.5) * 0.5;
            double ySpeed = ((double)random.nextFloat() - 0.5) * 0.5;
            double zSpeed = ((double)random.nextFloat() - 0.5) * 0.5;
            int j = random.nextInt(2) * 2 - 1;
            if (!level.getBlockState(pos.west()).is((Block)this) && !level.getBlockState(pos.east()).is((Block)this)) {
                x = (double)pos.getX() + 0.5 + 0.25 * (double)j;
                xSpeed = random.nextFloat() * 2.0f * (float)j;
            } else {
                z = (double)pos.getZ() + 0.5 + 0.25 * (double)j;
                zSpeed = random.nextFloat() * 2.0f * (float)j;
            }
            level.addParticle((ParticleOptions)UGParticleTypes.UNDERGARDEN_PORTAL.get(), x, y, z, xSpeed, ySpeed, zSpeed);
        }
    }

    public ItemStack getCloneItemStack(BlockState state, HitResult target, LevelReader level, BlockPos pos, Player player) {
        return ItemStack.EMPTY;
    }

    public BlockState rotate(BlockState state, Rotation rot) {
        switch (rot) {
            case COUNTERCLOCKWISE_90: 
            case CLOCKWISE_90: {
                return switch ((Direction.Axis)state.getValue(AXIS)) {
                    case Direction.Axis.Z -> (BlockState)state.setValue(AXIS, (Comparable)Direction.Axis.X);
                    case Direction.Axis.X -> (BlockState)state.setValue(AXIS, (Comparable)Direction.Axis.Z);
                    default -> state;
                };
            }
        }
        return state;
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{AXIS});
    }

    public static class UGPortalShape
    extends PortalShape {
        private static final int MIN_WIDTH = 1;
        public static final int MAX_WIDTH = 21;
        private static final int MIN_HEIGHT = 2;
        public static final int MAX_HEIGHT = 21;
        private static final BlockBehaviour.StatePredicate FRAME = (state, getter, pos) -> state.is(UGTags.Blocks.PORTAL_FRAME_BLOCKS);
        private final LevelAccessor level;
        private final Direction.Axis axis;
        private final Direction rightDir;
        private int numPortalBlocks;
        private BlockPos bottomLeft;
        private int height;
        private final int width;

        public UGPortalShape(LevelAccessor level, BlockPos bottomLeftPos, Direction.Axis axis) {
            super(level, bottomLeftPos, axis);
            this.level = level;
            this.axis = axis;
            this.rightDir = axis == Direction.Axis.X ? Direction.WEST : Direction.SOUTH;
            this.bottomLeft = this.calculateBottomLeft(bottomLeftPos);
            if (this.bottomLeft == null) {
                this.bottomLeft = bottomLeftPos;
                this.width = 1;
                this.height = 1;
            } else {
                this.width = this.calculateWidth();
                if (this.width > 0) {
                    this.height = this.calculateHeight();
                }
            }
        }

        @javax.annotation.Nullable
        private BlockPos calculateBottomLeft(BlockPos pos) {
            int i = Math.max(this.level.getMinBuildHeight(), pos.getY() - 21);
            while (pos.getY() > i && UGPortalShape.isEmpty(this.level.getBlockState(pos.below()))) {
                pos = pos.below();
            }
            Direction direction = this.rightDir.getOpposite();
            int j = this.getDistanceUntilEdgeAboveFrame(pos, direction) - 1;
            return j < 0 ? null : pos.relative(direction, j);
        }

        private int calculateWidth() {
            int i = this.getDistanceUntilEdgeAboveFrame(this.bottomLeft, this.rightDir);
            return i >= 1 && i <= 21 ? i : 0;
        }

        private int getDistanceUntilEdgeAboveFrame(BlockPos pos, Direction direction) {
            BlockPos.MutableBlockPos mutablePos = new BlockPos.MutableBlockPos();
            for (int i = 0; i <= 21; ++i) {
                mutablePos.set((Vec3i)pos).move(direction, i);
                BlockState blockstate = this.level.getBlockState((BlockPos)mutablePos);
                if (!UGPortalShape.isEmpty(blockstate)) {
                    if (!FRAME.test(blockstate, (BlockGetter)this.level, (BlockPos)mutablePos)) break;
                    return i;
                }
                BlockState blockstate1 = this.level.getBlockState((BlockPos)mutablePos.move(Direction.DOWN));
                if (!FRAME.test(blockstate1, (BlockGetter)this.level, (BlockPos)mutablePos)) break;
            }
            return 0;
        }

        private int calculateHeight() {
            BlockPos.MutableBlockPos mutablePos = new BlockPos.MutableBlockPos();
            int i = this.getDistanceUntilTop(mutablePos);
            return i >= 2 && i <= 21 && this.hasTopFrame(mutablePos, i) ? i : 0;
        }

        private boolean hasTopFrame(BlockPos.MutableBlockPos pos, int height) {
            for (int i = 0; i < this.width; ++i) {
                BlockPos.MutableBlockPos mutablePos = pos.set((Vec3i)this.bottomLeft).move(Direction.UP, height).move(this.rightDir, i);
                if (FRAME.test(this.level.getBlockState((BlockPos)mutablePos), (BlockGetter)this.level, (BlockPos)mutablePos)) continue;
                return false;
            }
            return true;
        }

        private int getDistanceUntilTop(BlockPos.MutableBlockPos pos) {
            for (int i = 0; i < 21; ++i) {
                pos.set((Vec3i)this.bottomLeft).move(Direction.UP, i).move(this.rightDir, -1);
                if (!FRAME.test(this.level.getBlockState((BlockPos)pos), (BlockGetter)this.level, (BlockPos)pos)) {
                    return i;
                }
                pos.set((Vec3i)this.bottomLeft).move(Direction.UP, i).move(this.rightDir, this.width);
                if (!FRAME.test(this.level.getBlockState((BlockPos)pos), (BlockGetter)this.level, (BlockPos)pos)) {
                    return i;
                }
                for (int j = 0; j < this.width; ++j) {
                    pos.set((Vec3i)this.bottomLeft).move(Direction.UP, i).move(this.rightDir, j);
                    BlockState blockstate = this.level.getBlockState((BlockPos)pos);
                    if (!UGPortalShape.isEmpty(blockstate)) {
                        return i;
                    }
                    if (!blockstate.is((Block)UGBlocks.UNDERGARDEN_PORTAL.get())) continue;
                    ++this.numPortalBlocks;
                }
            }
            return 21;
        }

        private static boolean isEmpty(BlockState state) {
            return state.isAir() || state.is((Block)UGBlocks.UNDERGARDEN_PORTAL.get());
        }

        public boolean isValid() {
            return this.bottomLeft != null && this.width >= 1 && this.width <= 21 && this.height >= 2 && this.height <= 21;
        }

        public void createPortalBlocks() {
            BlockState blockstate = (BlockState)((Block)UGBlocks.UNDERGARDEN_PORTAL.get()).defaultBlockState().setValue((Property)NetherPortalBlock.AXIS, (Comparable)this.axis);
            BlockPos.betweenClosed((BlockPos)this.bottomLeft, (BlockPos)this.bottomLeft.relative(Direction.UP, this.height - 1).relative(this.rightDir, this.width - 1)).forEach(pos -> this.level.setBlock(pos, blockstate, 18));
        }

        public boolean isComplete() {
            return this.isValid() && this.numPortalBlocks == this.width * this.height;
        }
    }
}

