/*
 * Decompiled with CFR 0.152.
 */
package quek.undergarden.client.model;

import com.google.common.collect.ImmutableSet;
import net.minecraft.client.model.AnimationUtils;
import net.minecraft.client.model.ListModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.util.Mth;
import quek.undergarden.entity.rotspawn.Rotbeast;

public class RotbeastModel<T extends Rotbeast>
extends ListModel<T> {
    private final ModelPart head;
    private final ModelPart jaw;
    private final ModelPart torso;
    private final ModelPart rightLeg;
    private final ModelPart leftLeg;
    private final ModelPart rightArm;
    private final ModelPart leftArm;

    public RotbeastModel(ModelPart root) {
        this.head = root.getChild("head");
        this.jaw = this.head.getChild("jaw");
        this.torso = root.getChild("torso");
        this.rightLeg = root.getChild("rightLeg");
        this.leftLeg = root.getChild("leftLeg");
        this.rightArm = root.getChild("rightArm");
        this.leftArm = root.getChild("leftArm");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.getRoot();
        PartDefinition torso = partdefinition.addOrReplaceChild("torso", CubeListBuilder.create(), PartPose.offset((float)15.0f, (float)24.0f, (float)0.0f));
        PartDefinition lowerTorso = torso.addOrReplaceChild("lowerTorso", CubeListBuilder.create().texOffs(50, 46).addBox(-13.0f, -14.25f, -6.0f, 26.0f, 14.0f, 13.0f, new CubeDeformation(0.0f)), PartPose.offset((float)-15.0f, (float)-16.75f, (float)5.5f));
        PartDefinition upperTorso = lowerTorso.addOrReplaceChild("upperTorso", CubeListBuilder.create().texOffs(32, 91).addBox(-15.0f, -19.0f, -8.5f, 30.0f, 19.0f, 18.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)-9.75f, (float)-0.5f, (float)0.48f, (float)0.0f, (float)0.0f));
        PartDefinition rightLeg = partdefinition.addOrReplaceChild("rightLeg", CubeListBuilder.create().texOffs(56, 10).mirror().addBox(-3.5f, 0.0f, -4.0f, 9.0f, 19.0f, 9.0f, new CubeDeformation(0.0f)).mirror(false), PartPose.offset((float)-7.5f, (float)5.0f, (float)5.5f));
        PartDefinition leftLeg = partdefinition.addOrReplaceChild("leftLeg", CubeListBuilder.create().texOffs(56, 10).addBox(-5.5f, 0.0f, -4.0f, 9.0f, 19.0f, 9.0f, new CubeDeformation(0.0f)), PartPose.offset((float)7.5f, (float)5.0f, (float)5.5f));
        PartDefinition head = partdefinition.addOrReplaceChild("head", CubeListBuilder.create().texOffs(80, 26).addBox(-6.0f, -6.5f, -13.0f, 12.0f, 8.0f, 12.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)-14.5f, (float)-7.0f));
        PartDefinition jaw = head.addOrReplaceChild("jaw", CubeListBuilder.create().texOffs(0, 15).addBox(-6.0f, -0.5f, -12.0f, 12.0f, 5.0f, 12.0f, new CubeDeformation(0.25f)).texOffs(0, 1).addBox(-6.0f, -3.0f, -12.0f, 12.0f, 2.0f, 12.0f, new CubeDeformation(0.25f)), PartPose.offset((float)0.0f, (float)2.0f, (float)-1.0f));
        PartDefinition rightArm = partdefinition.addOrReplaceChild("rightArm", CubeListBuilder.create().texOffs(2, 86).addBox(-7.0f, -1.0f, -4.0f, 7.0f, 34.0f, 8.0f, new CubeDeformation(0.0f)), PartPose.offset((float)-15.0f, (float)-17.0f, (float)2.0f));
        PartDefinition leftArm = partdefinition.addOrReplaceChild("leftArm", CubeListBuilder.create().texOffs(2, 86).mirror().addBox(0.0f, -1.0f, -4.0f, 7.0f, 34.0f, 8.0f, new CubeDeformation(0.0f)).mirror(false), PartPose.offset((float)15.0f, (float)-17.0f, (float)2.0f));
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)128, (int)128);
    }

    public void setupAnim(T entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.head.yRot = netHeadYaw * ((float)Math.PI / 180);
        this.head.xRot = headPitch * ((float)Math.PI / 180);
        this.rightArm.zRot = 0.0f;
        this.leftArm.zRot = 0.0f;
        AnimationUtils.bobArms((ModelPart)this.rightArm, (ModelPart)this.leftArm, (float)ageInTicks);
        this.jaw.xRot = entity.isAggressive() ? 0.3491f : 0.0f;
        this.leftLeg.xRot = Mth.cos((float)(limbSwing * 0.6662f)) * 1.4f * limbSwingAmount;
        this.rightLeg.xRot = Mth.cos((float)(limbSwing * 0.6662f + (float)Math.PI)) * 1.4f * limbSwingAmount;
    }

    public void prepareMobModel(T entity, float limbSwing, float limbSwingAmount, float partialTicks) {
        int attackTimer = ((Rotbeast)((Object)entity)).getAttackTimer();
        if (attackTimer > 0) {
            this.rightArm.xRot = -2.0f + 1.5f * Mth.triangleWave((float)((float)attackTimer - partialTicks), (float)10.0f);
            this.leftArm.xRot = -2.0f + 1.5f * Mth.triangleWave((float)((float)attackTimer - partialTicks), (float)10.0f);
        } else {
            this.rightArm.xRot = (-0.2f + 1.5f * Mth.triangleWave((float)limbSwing, (float)13.0f)) * limbSwingAmount;
            this.leftArm.xRot = (-0.2f - 1.5f * Mth.triangleWave((float)limbSwing, (float)13.0f)) * limbSwingAmount;
        }
    }

    public Iterable<ModelPart> parts() {
        return ImmutableSet.of((Object)this.head, (Object)this.torso, (Object)this.rightLeg, (Object)this.leftLeg, (Object)this.rightArm, (Object)this.leftArm, (Object[])new ModelPart[0]);
    }
}

