/*
 * Decompiled with CFR 0.152.
 */
package quek.undergarden.client.model;

import com.google.common.collect.ImmutableSet;
import net.minecraft.client.model.AnimationUtils;
import net.minecraft.client.model.ListModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.util.Mth;
import quek.undergarden.entity.rotspawn.Rotwalker;

public class RotwalkerModel<T extends Rotwalker>
extends ListModel<T> {
    private final ModelPart head;
    private final ModelPart body;
    private final ModelPart leftArm;
    private final ModelPart rightArm;
    private final ModelPart leftLeg;
    private final ModelPart rightLeg;

    public RotwalkerModel(ModelPart root) {
        this.head = root.getChild("head");
        this.body = root.getChild("body");
        this.leftArm = root.getChild("leftArm");
        this.rightArm = root.getChild("rightArm");
        this.leftLeg = root.getChild("leftLeg");
        this.rightLeg = root.getChild("rightLeg");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.getRoot();
        PartDefinition head = partdefinition.addOrReplaceChild("head", CubeListBuilder.create(), PartPose.offsetAndRotation((float)0.0f, (float)-11.0f, (float)-4.0f, (float)0.0873f, (float)0.0f, (float)0.0f));
        PartDefinition upperJaw = head.addOrReplaceChild("upperJaw", CubeListBuilder.create().texOffs(0, 0).addBox(-4.0f, -6.5f, -8.0f, 8.0f, 6.0f, 8.0f, new CubeDeformation(0.0f)).texOffs(25, 6).addBox(-4.0f, -0.5f, -8.0f, 8.0f, 1.0f, 8.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)2.0f, (float)4.0f));
        PartDefinition lowerJaw = head.addOrReplaceChild("lowerJaw", CubeListBuilder.create().texOffs(22, 19).addBox(-4.0f, 0.0f, -8.0f, 8.0f, 2.0f, 8.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)1.5f, (float)4.0f));
        PartDefinition body = partdefinition.addOrReplaceChild("body", CubeListBuilder.create().texOffs(0, 27).addBox(-4.0f, -8.0f, -1.0f, 8.0f, 9.0f, 3.0f, new CubeDeformation(0.0f)).texOffs(0, 14).addBox(-5.0f, -16.0f, -2.0f, 10.0f, 8.0f, 5.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)8.0f, (float)-1.0f, (float)0.1309f, (float)0.0f, (float)0.0f));
        PartDefinition rightArm = partdefinition.addOrReplaceChild("rightArm", CubeListBuilder.create().texOffs(22, 29).mirror().addBox(0.0f, -1.0f, -1.5f, 2.0f, 16.0f, 3.0f, new CubeDeformation(0.0f)).mirror(false), PartPose.offset((float)5.0f, (float)-6.0f, (float)-2.5f));
        PartDefinition leftArm = partdefinition.addOrReplaceChild("leftArm", CubeListBuilder.create().texOffs(22, 29).addBox(-2.0f, -1.0f, -1.5f, 2.0f, 16.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.offset((float)-5.0f, (float)-6.0f, (float)-2.5f));
        PartDefinition rightLeg = partdefinition.addOrReplaceChild("rightLeg", CubeListBuilder.create().texOffs(0, 39).mirror().addBox(-0.9f, 0.0f, -2.0f, 2.0f, 16.0f, 3.0f, new CubeDeformation(0.0f)).mirror(false), PartPose.offset((float)3.0f, (float)8.0f, (float)0.0f));
        PartDefinition leftLeg = partdefinition.addOrReplaceChild("leftLeg", CubeListBuilder.create().texOffs(0, 39).addBox(-1.1f, 0.0f, -2.0f, 2.0f, 16.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.offset((float)-3.0f, (float)8.0f, (float)0.0f));
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)64, (int)64);
    }

    public void setupAnim(T entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.head.yRot = netHeadYaw * ((float)Math.PI / 180);
        this.head.xRot = 0.0873f + headPitch * ((float)Math.PI / 180);
        this.rightArm.xRot = Mth.cos((float)(limbSwing * 0.6662f + (float)Math.PI)) * 2.0f * limbSwingAmount * 0.5f;
        this.leftArm.xRot = Mth.cos((float)(limbSwing * 0.6662f)) * 2.0f * limbSwingAmount * 0.5f;
        this.rightArm.zRot = 0.0f;
        this.leftArm.zRot = 0.0f;
        AnimationUtils.bobArms((ModelPart)this.rightArm, (ModelPart)this.leftArm, (float)ageInTicks);
        this.leftLeg.xRot = Mth.cos((float)(limbSwing * 0.6662f)) * 1.4f * limbSwingAmount;
        this.rightLeg.xRot = Mth.cos((float)(limbSwing * 0.6662f + (float)Math.PI)) * 1.4f * limbSwingAmount;
    }

    public Iterable<ModelPart> parts() {
        return ImmutableSet.of((Object)this.head, (Object)this.body, (Object)this.leftArm, (Object)this.rightArm, (Object)this.leftLeg, (Object)this.rightLeg, (Object[])new ModelPart[0]);
    }
}

