/*
 * Decompiled with CFR 0.152.
 */
package quek.undergarden.data.provider;

import java.util.HashMap;
import java.util.Set;
import java.util.function.Supplier;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.loot.BlockLootSubProvider;
import net.minecraft.world.flag.FeatureFlags;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SlabBlock;
import net.minecraft.world.level.storage.loot.entries.LootItem;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryContainer;
import net.minecraft.world.level.storage.loot.functions.ApplyBonusCount;
import net.minecraft.world.level.storage.loot.functions.FunctionUserBuilder;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.functions.SetItemCountFunction;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;
import net.minecraft.world.level.storage.loot.providers.number.UniformGenerator;

public abstract class UGBlockLootTableProvider
extends BlockLootSubProvider {
    protected UGBlockLootTableProvider(HolderLookup.Provider provider) {
        super(Set.of(), FeatureFlags.REGISTRY.allFlags(), new HashMap(), provider);
    }

    public void dropSelf(Supplier<? extends Block> block) {
        this.dropSelf(block.get());
    }

    public void slab(Supplier<? extends SlabBlock> slab) {
        this.add((Block)slab.get(), x$0 -> this.createSlabItemTable((Block)x$0));
    }

    public void dropOther(Supplier<? extends Block> brokenBlock, ItemLike droppedBlock) {
        this.dropOther(brokenBlock.get(), droppedBlock);
    }

    public void dropAsSilk(Supplier<? extends Block> block) {
        this.dropWhenSilkTouch(block.get());
    }

    public void dropWithSilk(Supplier<? extends Block> block, Supplier<? extends ItemLike> drop) {
        this.add(block.get(), result -> this.createSingleItemTableWithSilkTouch((Block)result, (ItemLike)drop.get()));
    }

    public void ore(Supplier<? extends Block> block, Supplier<? extends Item> drop) {
        this.add(block.get(), result -> this.createOreDrop((Block)result, (Item)drop.get()));
    }

    public void ore(Supplier<? extends Block> block, Item drop) {
        this.add(block.get(), result -> this.createOreDrop((Block)result, drop));
    }

    public void nuggetOre(Supplier<? extends Block> block, Item drop) {
        HolderLookup.RegistryLookup registryLookup = this.registries.lookupOrThrow(Registries.ENCHANTMENT);
        this.add(block.get(), ore -> this.createSilkTouchDispatchTable((Block)ore, (LootPoolEntryContainer.Builder)this.applyExplosionDecay((ItemLike)ore, (FunctionUserBuilder)LootItem.lootTableItem((ItemLike)drop).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)UniformGenerator.between((float)2.0f, (float)6.0f))).apply((LootItemFunction.Builder)ApplyBonusCount.addOreBonusCount((Holder)registryLookup.getOrThrow(Enchantments.FORTUNE))))));
    }
}

