/*
 * Decompiled with CFR 0.152.
 */
package quek.undergarden.entity.animal;

import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.core.Holder;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.AreaEffectCloud;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.JumpControl;
import net.minecraft.world.entity.ai.control.MoveControl;
import net.minecraft.world.entity.ai.goal.AvoidEntityGoal;
import net.minecraft.world.entity.ai.goal.BreedGoal;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.FollowParentGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.PanicGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.TemptGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.pathfinder.Path;
import net.minecraft.world.phys.Vec3;
import quek.undergarden.entity.rotspawn.RotspawnMonster;
import quek.undergarden.registry.UGBlocks;
import quek.undergarden.registry.UGEffects;
import quek.undergarden.registry.UGEntityTypes;
import quek.undergarden.registry.UGItems;
import quek.undergarden.registry.UGParticleTypes;
import quek.undergarden.registry.UGSoundEvents;

public class Gloomper
extends Animal {
    private int jumpTicks;
    private int jumpDuration;
    private boolean wasOnGround;
    private int currentMoveTypeDuration;

    public Gloomper(EntityType<? extends Animal> type, Level level) {
        super(type, level);
        this.jumpControl = new JumpHelperController(this);
        this.moveControl = new MoveHelperController(this);
        this.setMovementSpeed(0.0);
    }

    protected void registerGoals() {
        this.goalSelector.addGoal(1, (Goal)new FloatGoal((Mob)this));
        this.goalSelector.addGoal(1, (Goal)new PanicGoal((PathfinderMob)this, 2.5));
        this.goalSelector.addGoal(2, (Goal)new BreedGoal((Animal)this, 1.0));
        this.goalSelector.addGoal(2, (Goal)new AvoidEntityGoal((PathfinderMob)this, RotspawnMonster.class, 12.0f, 2.0, 2.5));
        this.goalSelector.addGoal(3, (Goal)new TemptGoal((PathfinderMob)this, 1.25, (Predicate)Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)UGBlocks.GLOOMGOURD.get()}), false));
        this.goalSelector.addGoal(4, (Goal)new FollowParentGoal((Animal)this, 1.25));
        this.goalSelector.addGoal(4, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0));
        this.goalSelector.addGoal(5, (Goal)new RandomLookAroundGoal((Mob)this));
    }

    public static AttributeSupplier.Builder registerAttributes() {
        return Animal.createMobAttributes().add(Attributes.MAX_HEALTH, 20.0).add(Attributes.MOVEMENT_SPEED, 0.3).add(Attributes.STEP_HEIGHT, 1.0);
    }

    protected SoundEvent getAmbientSound() {
        return (SoundEvent)UGSoundEvents.GLOOMPER_AMBIENT.get();
    }

    protected SoundEvent getHurtSound(DamageSource source) {
        return (SoundEvent)UGSoundEvents.GLOOMPER_HURT.get();
    }

    protected SoundEvent getDeathSound() {
        return (SoundEvent)UGSoundEvents.GLOOMPER_DEATH.get();
    }

    @Nullable
    public AgeableMob getBreedOffspring(ServerLevel level, AgeableMob mob) {
        return (AgeableMob)((EntityType)UGEntityTypes.GLOOMPER.get()).create(this.level());
    }

    public boolean isFood(ItemStack stack) {
        return Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)UGBlocks.GLOOMGOURD.get()}).test(stack);
    }

    protected float getJumpPower() {
        if (!(this.horizontalCollision || this.getMoveControl().hasWanted() && this.getMoveControl().getWantedY() > this.getY() + 0.5)) {
            Vec3 vector3d;
            Path path = this.getNavigation().getPath();
            if (path != null && !path.isDone() && (vector3d = path.getNextEntityPos((Entity)this)).y() > this.getY() + 0.5) {
                return 0.5f;
            }
            return this.getMoveControl().getSpeedModifier() <= 0.6 ? 0.2f : 0.3f;
        }
        return 0.5f;
    }

    public void jumpFromGround() {
        double d1;
        super.jumpFromGround();
        double d0 = this.getMoveControl().getSpeedModifier();
        if (d0 > 0.0 && (d1 = this.getDeltaMovement().horizontalDistanceSqr()) < 0.01) {
            this.moveRelative(0.1f, new Vec3(0.0, 0.0, 1.0));
        }
        if (!this.level().isClientSide()) {
            this.level().broadcastEntityEvent((Entity)this, (byte)1);
        }
    }

    public float getJumpCompletion(float delta) {
        return this.jumpDuration == 0 ? 0.0f : ((float)this.jumpTicks + delta) / (float)this.jumpDuration;
    }

    public void setMovementSpeed(double newSpeed) {
        this.getNavigation().setSpeedModifier(newSpeed);
        this.getMoveControl().setWantedPosition(this.getMoveControl().getWantedX(), this.getMoveControl().getWantedY(), this.getMoveControl().getWantedZ(), newSpeed);
    }

    public void setJumping(boolean jumping) {
        super.setJumping(jumping);
        if (jumping && !this.isInWater() && !this.wasTouchingWater) {
            this.playSound((SoundEvent)UGSoundEvents.GLOOMPER_HOP.get(), this.getSoundVolume(), ((this.getRandom().nextFloat() - this.getRandom().nextFloat()) * 0.2f + 1.0f) * 0.8f);
        }
    }

    public void startJumping() {
        this.setJumping(true);
        this.jumpDuration = 10;
        this.jumpTicks = 0;
    }

    public void customServerAiStep() {
        if (this.currentMoveTypeDuration > 0) {
            --this.currentMoveTypeDuration;
        }
        if (this.onGround()) {
            JumpHelperController jumpController;
            if (!this.wasOnGround) {
                this.setJumping(false);
                this.checkLandingDelay();
            }
            if (!(jumpController = (JumpHelperController)this.jumpControl).isJumping()) {
                if (this.moveControl.hasWanted() && this.currentMoveTypeDuration == 0) {
                    Path path = this.navigation.getPath();
                    Vec3 vector3d = new Vec3(this.getMoveControl().getWantedX(), this.getMoveControl().getWantedY(), this.getMoveControl().getWantedZ());
                    if (path != null && !path.isDone()) {
                        vector3d = path.getNextEntityPos((Entity)this);
                    }
                    this.calculateRotationYaw(vector3d.x(), vector3d.z());
                    this.startJumping();
                }
            } else if (!jumpController.canJump()) {
                this.enableJumpControl();
            }
        }
        this.wasOnGround = this.onGround();
    }

    public boolean canSpawnSprintParticle() {
        return false;
    }

    private void calculateRotationYaw(double x, double z) {
        this.setYRot((float)(Mth.atan2((double)(z - this.getZ()), (double)(x - this.getX())) * 57.2957763671875) - 90.0f);
    }

    private void enableJumpControl() {
        ((JumpHelperController)this.getJumpControl()).setCanJump(true);
    }

    private void disableJumpControl() {
        ((JumpHelperController)this.getJumpControl()).setCanJump(false);
    }

    private void updateMoveTypeDuration() {
        this.currentMoveTypeDuration = this.getMoveControl().getSpeedModifier() < 2.2 ? 10 : 1;
    }

    private void checkLandingDelay() {
        this.updateMoveTypeDuration();
        this.disableJumpControl();
    }

    public void aiStep() {
        super.aiStep();
        if (this.jumpTicks != this.jumpDuration) {
            ++this.jumpTicks;
        } else if (this.jumpDuration != 0) {
            this.jumpTicks = 0;
            this.jumpDuration = 0;
            this.setJumping(false);
        }
    }

    public void handleEntityEvent(byte id) {
        if (id == 1) {
            this.spawnSprintParticle();
            this.jumpDuration = 10;
            this.jumpTicks = 0;
        } else {
            super.handleEntityEvent(id);
        }
    }

    public InteractionResult mobInteract(Player player, InteractionHand hand) {
        ItemStack stack = player.getItemInHand(hand);
        if (stack.is((Item)UGItems.GLOOMPER_ANTHEM_DISC.get()) && this.isAlive()) {
            if (!this.level().isClientSide()) {
                this.spawnAtLocation((ItemLike)UGItems.GLOOMPER_SECRET_DISC.get());
                this.kill();
            }
            if (!player.getAbilities().instabuild) {
                stack.shrink(1);
            }
            return InteractionResult.sidedSuccess((boolean)this.level().isClientSide());
        }
        return super.mobInteract(player, hand);
    }

    public boolean hurt(DamageSource source, float amount) {
        AreaEffectCloud cloud = new AreaEffectCloud(this.level(), this.getX(), this.getY(), this.getZ());
        cloud.setParticle((ParticleOptions)UGParticleTypes.GLOOMPER_FART.get());
        cloud.setRadius(3.0f);
        cloud.setRadiusOnUse(-0.5f);
        cloud.setWaitTime(10);
        cloud.setRadiusPerTick(-cloud.getRadius() / (float)cloud.getDuration());
        cloud.addEffect(new MobEffectInstance(UGEffects.VIRULENCE, 100, 0));
        if (this.getRandom().nextInt(2) == 0) {
            this.playSound((SoundEvent)UGSoundEvents.GLOOMPER_FART.get(), 1.0f, 1.0f);
            this.level().addFreshEntity((Entity)cloud);
        }
        return super.hurt(source, amount);
    }

    public boolean canBeAffected(MobEffectInstance effectInstance) {
        Holder effect = effectInstance.getEffect();
        if (effect == UGEffects.VIRULENCE) {
            return false;
        }
        return super.canBeAffected(effectInstance);
    }

    public static class JumpHelperController
    extends JumpControl {
        private final Gloomper gloomper;
        private boolean canJump;

        public JumpHelperController(Gloomper gloomper) {
            super((Mob)gloomper);
            this.gloomper = gloomper;
        }

        public boolean isJumping() {
            return this.jump;
        }

        public boolean canJump() {
            return this.canJump;
        }

        public void setCanJump(boolean canJumpIn) {
            this.canJump = canJumpIn;
        }

        public void tick() {
            if (this.isJumping()) {
                this.gloomper.startJumping();
                this.jump = false;
            }
        }
    }

    static class MoveHelperController
    extends MoveControl {
        private final Gloomper gloomper;
        private double nextJumpSpeed;

        public MoveHelperController(Gloomper gloomper) {
            super((Mob)gloomper);
            this.gloomper = gloomper;
        }

        public void tick() {
            if (this.gloomper.onGround() && !this.gloomper.jumping && !((JumpHelperController)this.gloomper.getJumpControl()).isJumping()) {
                this.gloomper.setMovementSpeed(0.0);
            } else if (this.hasWanted()) {
                this.gloomper.setMovementSpeed(this.nextJumpSpeed);
            }
            super.tick();
        }

        public void setWantedPosition(double x, double y, double z, double speed) {
            if (this.gloomper.isInWater()) {
                speed = 1.5;
            }
            super.setWantedPosition(x, y, z, speed);
            if (speed > 0.0) {
                this.nextJumpSpeed = speed;
            }
        }
    }
}

