/*
 * Decompiled with CFR 0.152.
 */
package quek.undergarden.entity.animal.dweller;

import java.util.List;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.ItemSteerable;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.PlayerRideableJumping;
import net.minecraft.world.entity.Saddleable;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.AvoidEntityGoal;
import net.minecraft.world.entity.ai.goal.BreedGoal;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.FollowParentGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.PanicGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.TemptGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec2;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.common.CommonHooks;
import org.jetbrains.annotations.Nullable;
import quek.undergarden.entity.animal.dweller.DwellerItemBasedSteering;
import quek.undergarden.entity.animal.dweller.DwellerJumpGoal;
import quek.undergarden.entity.rotspawn.RotspawnMonster;
import quek.undergarden.registry.UGEntityTypes;
import quek.undergarden.registry.UGItems;
import quek.undergarden.registry.UGSoundEvents;

public class Dweller
extends Animal
implements ItemSteerable,
Saddleable,
PlayerRideableJumping {
    private static final EntityDataAccessor<Boolean> SADDLE = SynchedEntityData.defineId(Dweller.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private static final EntityDataAccessor<Integer> BOOST_TIME = SynchedEntityData.defineId(Dweller.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private final DwellerItemBasedSteering steering = new DwellerItemBasedSteering(this.getEntityData(), BOOST_TIME, SADDLE);
    private float playerJumpPendingScale;
    private boolean isJumping;
    private int wildJumpCooldown = 300 + this.getRandom().nextInt(500);
    @javax.annotation.Nullable
    private PanicGoal panicGoal;
    @javax.annotation.Nullable
    private DwellerAvoidEntityGoal<?> avoidGoal;

    public Dweller(EntityType<? extends Dweller> type, Level level) {
        super(type, level);
    }

    protected void registerGoals() {
        this.goalSelector.addGoal(0, (Goal)new FloatGoal((Mob)this));
        this.panicGoal = new PanicGoal((PathfinderMob)this, 2.5);
        this.goalSelector.addGoal(1, (Goal)this.panicGoal);
        this.goalSelector.addGoal(1, (Goal)new TemptGoal((PathfinderMob)this, 1.5, (Predicate)Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)UGItems.UNDERBEANS.get(), (ItemLike)UGItems.UNDERBEAN_STICK.get()}), false));
        this.goalSelector.addGoal(1, (Goal)new BreedGoal((Animal)this, 1.0));
        this.goalSelector.addGoal(1, (Goal)new FollowParentGoal((Animal)this, 1.25));
        this.avoidGoal = new DwellerAvoidEntityGoal<RotspawnMonster>((PathfinderMob)this, RotspawnMonster.class, 12.0f, 2.0, 2.5);
        this.goalSelector.addGoal(2, this.avoidGoal);
        this.goalSelector.addGoal(2, (Goal)new DwellerJumpGoal(this));
        this.goalSelector.addGoal(3, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0));
        this.goalSelector.addGoal(4, (Goal)new RandomLookAroundGoal((Mob)this));
    }

    public static AttributeSupplier.Builder registerAttributes() {
        return Animal.createMobAttributes().add(Attributes.MAX_HEALTH, 15.0).add(Attributes.MOVEMENT_SPEED, 0.2).add(Attributes.STEP_HEIGHT, 1.0);
    }

    protected SoundEvent getAmbientSound() {
        return (SoundEvent)UGSoundEvents.DWELLER_AMBIENT.get();
    }

    protected SoundEvent getHurtSound(DamageSource source) {
        return (SoundEvent)UGSoundEvents.DWELLER_HURT.get();
    }

    protected SoundEvent getDeathSound() {
        return (SoundEvent)UGSoundEvents.DWELLER_DEATH.get();
    }

    protected void playStepSound(BlockPos pos, BlockState state) {
        this.playSound((SoundEvent)UGSoundEvents.DWELLER_STEP.get(), 0.15f, 1.0f);
    }

    @javax.annotation.Nullable
    public AgeableMob getBreedOffspring(ServerLevel level, AgeableMob mob) {
        return (AgeableMob)((EntityType)UGEntityTypes.DWELLER.get()).create(this.level());
    }

    public boolean isFood(ItemStack stack) {
        return Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)UGItems.UNDERBEANS.get()}).test(stack);
    }

    public void addAdditionalSaveData(CompoundTag tag) {
        super.addAdditionalSaveData(tag);
        this.steering.addAdditionalSaveData(tag);
        tag.putInt("JumpCooldown", this.getWildJumpCooldown());
    }

    public void readAdditionalSaveData(CompoundTag tag) {
        super.readAdditionalSaveData(tag);
        this.steering.readAdditionalSaveData(tag);
        this.setWildJumpCooldown(tag.getInt("JumpCooldown"));
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(SADDLE, (Object)false);
        builder.define(BOOST_TIME, (Object)0);
    }

    public void onSyncedDataUpdated(EntityDataAccessor<?> data) {
        if (BOOST_TIME.equals(data) && this.level().isClientSide()) {
            this.steering.onSynced();
        }
        super.onSyncedDataUpdated(data);
    }

    public void aiStep() {
        super.aiStep();
        if (this.wildJumpCooldown > 0 && !this.canJump() && !this.isVehicle()) {
            --this.wildJumpCooldown;
        }
    }

    public InteractionResult mobInteract(Player player, InteractionHand hand) {
        boolean isFood = this.isFood(player.getItemInHand(hand));
        if (!isFood && this.isSaddled() && !this.isVehicle() && !player.isSecondaryUseActive()) {
            if (!this.level().isClientSide()) {
                player.startRiding((Entity)this);
            }
            return InteractionResult.sidedSuccess((boolean)this.level().isClientSide());
        }
        if (this.isSaddled() && player.isSecondaryUseActive() && player.getItemInHand(hand).isEmpty()) {
            this.spawnAtLocation((ItemLike)Items.SADDLE);
            this.playSound((SoundEvent)UGSoundEvents.DWELLER_SADDLE_REMOVE.get());
            this.steering.setSaddle(false);
            return InteractionResult.sidedSuccess((boolean)this.level().isClientSide());
        }
        InteractionResult result = super.mobInteract(player, hand);
        if (!result.consumesAction()) {
            ItemStack itemstack = player.getItemInHand(hand);
            return itemstack.is(Items.SADDLE) ? itemstack.interactLivingEntity(player, (LivingEntity)this, hand) : InteractionResult.PASS;
        }
        return result;
    }

    public boolean isSaddleable() {
        return this.isAlive() && !this.isBaby();
    }

    public void equipSaddle(ItemStack stack, @Nullable SoundSource source) {
        this.steering.setSaddle(true);
        if (source != null) {
            this.level().playSound(null, (Entity)this, SoundEvents.PIG_SADDLE, source, 0.5f, 1.0f);
        }
    }

    public boolean isSaddled() {
        return this.steering.hasSaddle();
    }

    public boolean boost() {
        return this.steering.boost(this.getRandom());
    }

    protected float getRiddenSpeed(Player player) {
        return (float)this.getAttributeValue(Attributes.MOVEMENT_SPEED) * this.steering.boostFactor();
    }

    @javax.annotation.Nullable
    public LivingEntity getControllingPassenger() {
        LivingEntity living;
        Entity entity = this.getFirstPassenger();
        return entity != null && this.canBeControlledBy(entity) && entity instanceof LivingEntity ? (living = (LivingEntity)entity) : null;
    }

    protected int calculateFallDamage(float distance, float multiplier) {
        return super.calculateFallDamage(distance, multiplier) - 10;
    }

    private boolean canBeControlledBy(Entity entity) {
        if (this.isSaddled() && entity instanceof Player) {
            Player player = (Player)entity;
            return player.getMainHandItem().is((Item)UGItems.UNDERBEAN_STICK.get()) || player.getOffhandItem().is((Item)UGItems.UNDERBEAN_STICK.get());
        }
        return false;
    }

    public Vec3 collide(Vec3 vec) {
        AABB aabb = this.getPassengers().isEmpty() ? this.getBoundingBox() : EntityDimensions.scalable((float)1.2f, (float)2.65f).makeBoundingBox(this.position());
        List list = this.level().getEntityCollisions((Entity)this, aabb.expandTowards(vec));
        Vec3 vec3 = vec.lengthSqr() == 0.0 ? vec : Dweller.collideBoundingBox((Entity)this, (Vec3)vec, (AABB)aabb, (Level)this.level(), (List)list);
        boolean flag = vec.x() != vec3.x();
        boolean flag1 = vec.y() != vec3.y();
        boolean flag2 = vec.z() != vec3.z();
        boolean flag3 = this.onGround() || flag1 && vec.y() < 0.0;
        float stepHeight = (float)this.getAttribute(Attributes.STEP_HEIGHT).getValue();
        if (stepHeight > 0.0f && flag3 && (flag || flag2)) {
            Vec3 vec33;
            Vec3 vec31 = Dweller.collideBoundingBox((Entity)this, (Vec3)new Vec3(vec.x(), (double)stepHeight, vec.z()), (AABB)aabb, (Level)this.level(), (List)list);
            Vec3 vec32 = Dweller.collideBoundingBox((Entity)this, (Vec3)new Vec3(0.0, (double)stepHeight, 0.0), (AABB)aabb.expandTowards(vec.x(), 0.0, vec.z()), (Level)this.level(), (List)list);
            if (vec32.y() < (double)stepHeight && (vec33 = Dweller.collideBoundingBox((Entity)this, (Vec3)new Vec3(vec.x(), 0.0, vec.z()), (AABB)aabb.move(vec32), (Level)this.level(), (List)list).add(vec32)).horizontalDistanceSqr() > vec31.horizontalDistanceSqr()) {
                vec31 = vec33;
            }
            if (vec31.horizontalDistanceSqr() > vec3.horizontalDistanceSqr()) {
                return vec31.add(Dweller.collideBoundingBox((Entity)this, (Vec3)new Vec3(0.0, -vec31.y() + vec.y(), 0.0), (AABB)aabb.move(vec31), (Level)this.level(), (List)list));
            }
        }
        return vec3;
    }

    protected void dropEquipment() {
        super.dropEquipment();
        if (this.isSaddled()) {
            this.spawnAtLocation((ItemLike)Items.SADDLE);
        }
    }

    public void positionRider(Entity passenger, Entity.MoveFunction callback) {
        float ySin = Mth.sin((float)(this.yBodyRot * ((float)Math.PI / 180)));
        float yCos = Mth.cos((float)(this.yBodyRot * ((float)Math.PI / 180)));
        Vec3 vec3 = this.getPassengerRidingPosition(passenger);
        callback.accept(passenger, this.getX() + (double)(0.5f * ySin), vec3.y() + passenger.getVehicleAttachmentPoint((Entity)this).y(), this.getZ() - (double)(0.5f * yCos));
    }

    public boolean isJumping() {
        return this.isJumping;
    }

    public void setIsJumping(boolean jumping) {
        this.isJumping = jumping;
    }

    protected void tickRidden(Player player, Vec3 vec) {
        super.tickRidden(player, vec);
        this.steering.tickBoost();
        Vec2 vec2 = this.getRiddenRotation((LivingEntity)player);
        this.setRot(vec2.y, vec2.x);
        this.yBodyRot = this.yHeadRot = this.getYRot();
        this.yRotO = this.yHeadRot;
        if (this.isControlledByLocalInstance() && this.onGround()) {
            this.setIsJumping(false);
            if (this.playerJumpPendingScale > 0.0f && !this.isJumping()) {
                this.jump(vec.z() > 0.0);
            }
            this.playerJumpPendingScale = 0.0f;
        }
    }

    protected Vec2 getRiddenRotation(LivingEntity entity) {
        return new Vec2(entity.getXRot() * 0.5f, entity.getYRot());
    }

    public void jump(boolean moveHorizontally) {
        double d0 = this.getBlockJumpFactor();
        double d1 = d0 + (double)this.getJumpBoostPower();
        Vec3 vec3 = this.getDeltaMovement();
        this.setDeltaMovement(vec3.x(), d1, vec3.z());
        this.setIsJumping(true);
        this.hasImpulse = true;
        CommonHooks.onLivingJump((LivingEntity)this);
        if (moveHorizontally) {
            float f = Mth.sin((float)(this.getYRot() * ((float)Math.PI / 180)));
            float f1 = Mth.cos((float)(this.getYRot() * ((float)Math.PI / 180)));
            this.setDeltaMovement(this.getDeltaMovement().add((double)(-0.4f * f), 0.0, (double)(0.4f * f1)));
        }
    }

    public void onPlayerJump(int power) {
        if (this.isSaddled() && this.onGround()) {
            this.playerJumpPendingScale = 1.0f;
        }
    }

    public boolean canJump() {
        return this.isSaddled() && this.getControllingPassenger() != null;
    }

    public void handleStartJump(int pJumpPower) {
        if (this.onGround()) {
            this.playSound((SoundEvent)UGSoundEvents.DWELLER_JUMP.get(), this.getSoundVolume(), this.getVoicePitch());
            this.ambientSoundTime = -30;
        }
    }

    public void handleStopJump() {
    }

    @javax.annotation.Nullable
    public PanicGoal getPanicGoal() {
        return this.panicGoal;
    }

    @javax.annotation.Nullable
    public DwellerAvoidEntityGoal<?> getAvoidGoal() {
        return this.avoidGoal;
    }

    public int getWildJumpCooldown() {
        return this.wildJumpCooldown;
    }

    public void setWildJumpCooldown(int cooldown) {
        this.wildJumpCooldown = cooldown;
    }

    public static class DwellerAvoidEntityGoal<T extends LivingEntity>
    extends AvoidEntityGoal<T> {
        private boolean running;

        public DwellerAvoidEntityGoal(PathfinderMob pMob, Class<T> pEntityClassToAvoid, float pMaxDistance, double pWalkSpeedModifier, double pSprintSpeedModifier) {
            super(pMob, pEntityClassToAvoid, pMaxDistance, pWalkSpeedModifier, pSprintSpeedModifier);
        }

        public void start() {
            super.start();
            this.running = true;
        }

        public void stop() {
            super.stop();
            this.running = false;
        }

        public boolean isRunning() {
            return this.running;
        }
    }
}

