/*
 * Decompiled with CFR 0.152.
 */
package quek.undergarden.entity.cavern;

import net.minecraft.core.BlockPos;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.neoforged.neoforge.event.EventHooks;
import quek.undergarden.entity.cavern.CavernMonster;
import quek.undergarden.registry.UGSoundEvents;
import quek.undergarden.registry.UGTags;

public class Muncher
extends CavernMonster {
    public Muncher(EntityType<? extends CavernMonster> type, Level level) {
        super(type, level);
    }

    protected void registerGoals() {
        this.goalSelector.addGoal(0, (Goal)new FloatGoal((Mob)this));
        this.goalSelector.addGoal(1, (Goal)new MeleeAttackGoal((PathfinderMob)this, 1.0, true));
        this.goalSelector.addGoal(2, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 0.8));
        this.goalSelector.addGoal(3, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
        this.targetSelector.addGoal(0, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, false));
        this.targetSelector.addGoal(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
    }

    public static AttributeSupplier.Builder registerAttributes() {
        return CavernMonster.createMobAttributes().add(Attributes.MAX_HEALTH, 15.0).add(Attributes.ARMOR_TOUGHNESS, 5.0).add(Attributes.ATTACK_DAMAGE, 2.0).add(Attributes.MOVEMENT_SPEED, 0.3);
    }

    protected SoundEvent getAmbientSound() {
        return (SoundEvent)UGSoundEvents.MUNCHER_AMBIENT.get();
    }

    protected SoundEvent getHurtSound(DamageSource source) {
        return (SoundEvent)UGSoundEvents.MUNCHER_HURT.get();
    }

    protected SoundEvent getDeathSound() {
        return (SoundEvent)UGSoundEvents.MUNCHER_DEATH.get();
    }

    public void aiStep() {
        super.aiStep();
        if (this.isAggressive() && (this.horizontalCollision || this.verticalCollision && EventHooks.canEntityGrief((Level)this.level(), (Entity)this))) {
            AABB axisalignedbb = this.getBoundingBox();
            for (BlockPos blockpos : BlockPos.betweenClosed((int)Mth.floor((double)axisalignedbb.minX), (int)Mth.floor((double)axisalignedbb.minY), (int)Mth.floor((double)axisalignedbb.minZ), (int)Mth.floor((double)axisalignedbb.maxX), (int)Mth.floor((double)axisalignedbb.maxY), (int)Mth.floor((double)axisalignedbb.maxZ))) {
                BlockState blockstate = this.level().getBlockState(blockpos);
                if (!blockstate.is(UGTags.Blocks.MUNCHER_BREAKABLES)) continue;
                this.level().destroyBlock(blockpos, false, (Entity)this);
                this.heal(1.0f);
                this.playSound((SoundEvent)UGSoundEvents.MUNCHER_CHEW.get(), 1.0f, this.getVoicePitch());
            }
        }
    }
}

