/*
 * Decompiled with CFR 0.152.
 */
package quek.undergarden.entity.stoneborn.goals;

import java.util.EnumSet;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.player.Player;
import quek.undergarden.entity.stoneborn.Stoneborn;

public class StonebornTradeWithPlayerGoal
extends Goal {
    private final Stoneborn stoneborn;

    public StonebornTradeWithPlayerGoal(Stoneborn stoneborn) {
        this.stoneborn = stoneborn;
        this.setFlags(EnumSet.of(Goal.Flag.JUMP, Goal.Flag.MOVE));
    }

    public boolean canUse() {
        if (!this.stoneborn.isAlive()) {
            return false;
        }
        if (this.stoneborn.isInWater()) {
            return false;
        }
        if (!this.stoneborn.onGround()) {
            return false;
        }
        if (this.stoneborn.hurtMarked) {
            return false;
        }
        Player playerentity = this.stoneborn.getTradingPlayer();
        if (playerentity == null) {
            return false;
        }
        if (this.stoneborn.distanceToSqr((Entity)playerentity) > 16.0) {
            return false;
        }
        return playerentity.containerMenu != null;
    }

    public void start() {
        this.stoneborn.getNavigation().stop();
    }

    public void stop() {
        this.stoneborn.setTradingPlayer(null);
    }
}

