/*
 * Decompiled with CFR 0.152.
 */
package quek.undergarden.event;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.SpawnPlacementTypes;
import net.minecraft.world.entity.animal.AbstractFish;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.monster.EnderMan;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.PotionBrewing;
import net.minecraft.world.item.alchemy.Potions;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.FireBlock;
import net.minecraft.world.level.block.FlowerPotBlock;
import net.minecraft.world.level.block.RotatedPillarBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.WoodType;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.phys.Vec3;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.fml.event.lifecycle.FMLCommonSetupEvent;
import net.neoforged.neoforge.common.ItemAbilities;
import net.neoforged.neoforge.common.ItemAbility;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.common.NeoForgeMod;
import net.neoforged.neoforge.event.brewing.RegisterBrewingRecipesEvent;
import net.neoforged.neoforge.event.entity.EntityAttributeCreationEvent;
import net.neoforged.neoforge.event.entity.RegisterSpawnPlacementsEvent;
import net.neoforged.neoforge.event.entity.living.EnderManAngerEvent;
import net.neoforged.neoforge.event.entity.living.LivingIncomingDamageEvent;
import net.neoforged.neoforge.event.entity.living.LivingKnockBackEvent;
import net.neoforged.neoforge.event.level.BlockEvent;
import net.neoforged.neoforge.event.tick.EntityTickEvent;
import net.neoforged.neoforge.fluids.FluidInteractionRegistry;
import net.neoforged.neoforge.fluids.FluidType;
import quek.undergarden.attachment.UndergardenPortalAttachment;
import quek.undergarden.entity.Forgotten;
import quek.undergarden.entity.Minion;
import quek.undergarden.entity.animal.Brute;
import quek.undergarden.entity.animal.Gloomper;
import quek.undergarden.entity.animal.Gwib;
import quek.undergarden.entity.animal.Gwibling;
import quek.undergarden.entity.animal.Mog;
import quek.undergarden.entity.animal.Scintling;
import quek.undergarden.entity.animal.SmogMog;
import quek.undergarden.entity.animal.dweller.Dweller;
import quek.undergarden.entity.boss.ForgottenGuardian;
import quek.undergarden.entity.cavern.CavernMonster;
import quek.undergarden.entity.cavern.Muncher;
import quek.undergarden.entity.cavern.Nargoyle;
import quek.undergarden.entity.cavern.Sploogie;
import quek.undergarden.entity.projectile.slingshot.DepthrockPebble;
import quek.undergarden.entity.projectile.slingshot.GooBall;
import quek.undergarden.entity.projectile.slingshot.Gronglet;
import quek.undergarden.entity.projectile.slingshot.RottenBlisterberry;
import quek.undergarden.entity.projectile.slingshot.SlingshotProjectile;
import quek.undergarden.entity.rotspawn.Rotbeast;
import quek.undergarden.entity.rotspawn.Rotling;
import quek.undergarden.entity.rotspawn.RotspawnMonster;
import quek.undergarden.entity.rotspawn.Rotwalker;
import quek.undergarden.entity.stoneborn.Stoneborn;
import quek.undergarden.event.UndergardenToolEvents;
import quek.undergarden.item.tool.slingshot.AbstractSlingshotAmmoBehavior;
import quek.undergarden.item.tool.slingshot.SlingshotItem;
import quek.undergarden.registry.UGAttachments;
import quek.undergarden.registry.UGBlocks;
import quek.undergarden.registry.UGCauldronInteractions;
import quek.undergarden.registry.UGDispenserBehaviors;
import quek.undergarden.registry.UGEffects;
import quek.undergarden.registry.UGEntityTypes;
import quek.undergarden.registry.UGFluids;
import quek.undergarden.registry.UGItems;
import quek.undergarden.registry.UGPotions;
import quek.undergarden.registry.UGSoundEvents;
import quek.undergarden.registry.UGWoodStuff;

public class UndergardenCommonEvents {
    public static void initCommonEvents(IEventBus bus) {
        UndergardenToolEvents.setupToolEvents();
        bus.addListener(UndergardenCommonEvents::setup);
        bus.addListener(UndergardenCommonEvents::registerEntityAttributes);
        bus.addListener(UndergardenCommonEvents::registerSpawnPlacements);
        NeoForge.EVENT_BUS.addListener(UndergardenCommonEvents::tickPortalLogic);
        NeoForge.EVENT_BUS.addListener(UndergardenCommonEvents::blockToolInteractions);
        NeoForge.EVENT_BUS.addListener(UndergardenCommonEvents::applyBrittleness);
        NeoForge.EVENT_BUS.addListener(UndergardenCommonEvents::applyFeatherweight);
        NeoForge.EVENT_BUS.addListener(UndergardenCommonEvents::cancelPlayerFallDamageOnDweller);
        NeoForge.EVENT_BUS.addListener(UndergardenCommonEvents::lookedAtEndermanWithGloomgourd);
        NeoForge.EVENT_BUS.addListener(UndergardenCommonEvents::registerPotionRecipes);
    }

    private static void setup(FMLCommonSetupEvent event) {
        FluidInteractionRegistry.addInteraction((FluidType)((FluidType)UGFluids.VIRULENT_MIX_TYPE.get()), (FluidInteractionRegistry.InteractionInformation)new FluidInteractionRegistry.InteractionInformation((FluidType)NeoForgeMod.WATER_TYPE.value(), fluidState -> ((Block)UGBlocks.DEPTHROCK.get()).defaultBlockState()));
        FluidInteractionRegistry.addInteraction((FluidType)((FluidType)UGFluids.VIRULENT_MIX_TYPE.get()), (FluidInteractionRegistry.InteractionInformation)new FluidInteractionRegistry.InteractionInformation((FluidType)NeoForgeMod.LAVA_TYPE.value(), fluidState -> fluidState.isSource() ? Blocks.OBSIDIAN.defaultBlockState() : ((Block)UGBlocks.SHIVERSTONE.get()).defaultBlockState()));
        event.enqueueWork(() -> {
            UGCauldronInteractions.register();
            UGDispenserBehaviors.register();
            FlowerPotBlock pot = (FlowerPotBlock)Blocks.FLOWER_POT;
            pot.addPlant(UGBlocks.SMOGSTEM_SAPLING.getId(), UGBlocks.POTTED_SMOGSTEM_SAPLING);
            pot.addPlant(UGBlocks.WIGGLEWOOD_SAPLING.getId(), UGBlocks.POTTED_WIGGLEWOOD_SAPLING);
            pot.addPlant(UGBlocks.SHIMMERWEED.getId(), UGBlocks.POTTED_SHIMMERWEED);
            pot.addPlant(UGBlocks.INDIGO_MUSHROOM.getId(), UGBlocks.POTTED_INDIGO_MUSHROOM);
            pot.addPlant(UGBlocks.VEIL_MUSHROOM.getId(), UGBlocks.POTTED_VEIL_MUSHROOM);
            pot.addPlant(UGBlocks.INK_MUSHROOM.getId(), UGBlocks.POTTED_INK_MUSHROOM);
            pot.addPlant(UGBlocks.BLOOD_MUSHROOM.getId(), UGBlocks.POTTED_BLOOD_MUSHROOM);
            pot.addPlant(UGBlocks.GRONGLE_SAPLING.getId(), UGBlocks.POTTED_GRONGLE_SAPLING);
            pot.addPlant(UGBlocks.AMOROUS_BRISTLE.getId(), UGBlocks.POTTED_AMOROUS_BRISTLE);
            pot.addPlant(UGBlocks.MISERABELL.getId(), UGBlocks.POTTED_MISERABELL);
            pot.addPlant(UGBlocks.BUTTERBUNCH.getId(), UGBlocks.POTTED_BUTTERBUNCH);
            WoodType.register((WoodType)UGWoodStuff.SMOGSTEM_WOOD_TYPE);
            WoodType.register((WoodType)UGWoodStuff.WIGGLEWOOD_WOOD_TYPE);
            WoodType.register((WoodType)UGWoodStuff.GRONGLE_WOOD_TYPE);
            SlingshotItem.registerAmmo((ItemLike)UGItems.DEPTHROCK_PEBBLE.get(), new AbstractSlingshotAmmoBehavior(){

                @Override
                public SlingshotProjectile getProjectile(Level level, BlockPos pos, Player shooter, ItemStack stack) {
                    return new DepthrockPebble(level, (LivingEntity)shooter);
                }
            });
            SlingshotItem.registerAmmo((ItemLike)UGItems.ROTTEN_BLISTERBERRY.get(), new AbstractSlingshotAmmoBehavior(){

                @Override
                public SlingshotProjectile getProjectile(Level level, BlockPos pos, Player shooter, ItemStack stack) {
                    return new RottenBlisterberry(level, (LivingEntity)shooter);
                }
            });
            SlingshotItem.registerAmmo((ItemLike)UGItems.GOO_BALL.get(), new AbstractSlingshotAmmoBehavior(){

                @Override
                public SlingshotProjectile getProjectile(Level level, BlockPos pos, Player shooter, ItemStack stack) {
                    return new GooBall(level, (LivingEntity)shooter);
                }
            });
            SlingshotItem.registerAmmo((ItemLike)UGBlocks.GRONGLET.get(), new AbstractSlingshotAmmoBehavior(){

                @Override
                public SlingshotProjectile getProjectile(Level level, BlockPos pos, Player shooter, ItemStack stack) {
                    return new Gronglet((LivingEntity)shooter, level);
                }

                @Override
                public SoundEvent getFiringSound() {
                    return (SoundEvent)UGSoundEvents.GRONGLET_SHOOT.get();
                }
            });
            FireBlock fire = (FireBlock)Blocks.FIRE;
            fire.setFlammable((Block)UGBlocks.SMOGSTEM_PLANKS.get(), 5, 20);
            fire.setFlammable((Block)UGBlocks.WIGGLEWOOD_PLANKS.get(), 5, 20);
            fire.setFlammable((Block)UGBlocks.GRONGLE_PLANKS.get(), 5, 20);
            fire.setFlammable((Block)UGBlocks.SMOGSTEM_SLAB.get(), 5, 20);
            fire.setFlammable((Block)UGBlocks.WIGGLEWOOD_SLAB.get(), 5, 20);
            fire.setFlammable((Block)UGBlocks.GRONGLE_SLAB.get(), 5, 20);
            fire.setFlammable((Block)UGBlocks.SMOGSTEM_FENCE_GATE.get(), 5, 20);
            fire.setFlammable((Block)UGBlocks.WIGGLEWOOD_FENCE_GATE.get(), 5, 20);
            fire.setFlammable((Block)UGBlocks.GRONGLE_FENCE_GATE.get(), 5, 20);
            fire.setFlammable((Block)UGBlocks.SMOGSTEM_FENCE.get(), 5, 20);
            fire.setFlammable((Block)UGBlocks.WIGGLEWOOD_FENCE.get(), 5, 20);
            fire.setFlammable((Block)UGBlocks.GRONGLE_FENCE.get(), 5, 20);
            fire.setFlammable((Block)UGBlocks.SMOGSTEM_STAIRS.get(), 5, 20);
            fire.setFlammable((Block)UGBlocks.WIGGLEWOOD_STAIRS.get(), 5, 20);
            fire.setFlammable((Block)UGBlocks.GRONGLE_STAIRS.get(), 5, 20);
            fire.setFlammable((Block)UGBlocks.SMOGSTEM_LOG.get(), 5, 5);
            fire.setFlammable((Block)UGBlocks.WIGGLEWOOD_LOG.get(), 5, 5);
            fire.setFlammable((Block)UGBlocks.GRONGLE_LOG.get(), 5, 5);
            fire.setFlammable((Block)UGBlocks.STRIPPED_SMOGSTEM_LOG.get(), 5, 5);
            fire.setFlammable((Block)UGBlocks.STRIPPED_WIGGLEWOOD_LOG.get(), 5, 5);
            fire.setFlammable((Block)UGBlocks.STRIPPED_GRONGLE_LOG.get(), 5, 5);
            fire.setFlammable((Block)UGBlocks.SMOGSTEM_WOOD.get(), 5, 5);
            fire.setFlammable((Block)UGBlocks.WIGGLEWOOD_WOOD.get(), 5, 5);
            fire.setFlammable((Block)UGBlocks.GRONGLE_WOOD.get(), 5, 5);
            fire.setFlammable((Block)UGBlocks.STRIPPED_SMOGSTEM_WOOD.get(), 5, 5);
            fire.setFlammable((Block)UGBlocks.STRIPPED_WIGGLEWOOD_WOOD.get(), 5, 5);
            fire.setFlammable((Block)UGBlocks.STRIPPED_GRONGLE_WOOD.get(), 5, 5);
            fire.setFlammable((Block)UGBlocks.SMOGSTEM_LEAVES.get(), 30, 60);
            fire.setFlammable((Block)UGBlocks.WIGGLEWOOD_LEAVES.get(), 30, 60);
            fire.setFlammable((Block)UGBlocks.GRONGLE_LEAVES.get(), 30, 60);
            fire.setFlammable((Block)UGBlocks.HANGING_GRONGLE_LEAVES.get(), 30, 60);
            fire.setFlammable((Block)UGBlocks.DEEPTURF.get(), 60, 100);
            fire.setFlammable((Block)UGBlocks.ASHEN_DEEPTURF.get(), 60, 100);
            fire.setFlammable((Block)UGBlocks.FROZEN_DEEPTURF.get(), 60, 100);
            fire.setFlammable((Block)UGBlocks.SHIMMERWEED.get(), 60, 100);
            fire.setFlammable((Block)UGBlocks.TALL_DEEPTURF.get(), 60, 100);
            fire.setFlammable((Block)UGBlocks.TALL_SHIMMERWEED.get(), 60, 100);
            fire.setFlammable((Block)UGBlocks.UNDERBEAN_BUSH.get(), 60, 100);
            fire.setFlammable((Block)UGBlocks.BLISTERBERRY_BUSH.get(), 60, 100);
            fire.setFlammable((Block)UGBlocks.ASHEN_DEEPTURF.get(), 60, 100);
            fire.setFlammable((Block)UGBlocks.DITCHBULB_PLANT.get(), 60, 100);
            fire.setFlammable((Block)UGBlocks.DROOPVINE.get(), 15, 60);
            fire.setFlammable((Block)UGBlocks.DROOPVINE_PLANT.get(), 15, 60);
            fire.setFlammable((Block)UGBlocks.AMOROUS_BRISTLE.get(), 60, 100);
            fire.setFlammable((Block)UGBlocks.MISERABELL.get(), 60, 100);
            fire.setFlammable((Block)UGBlocks.BUTTERBUNCH.get(), 60, 100);
            fire.setFlammable((Block)UGBlocks.MOGMOSS_RUG.get(), 60, 20);
            fire.setFlammable((Block)UGBlocks.BLUE_MOGMOSS_RUG.get(), 60, 20);
            fire.setFlammable((Block)UGBlocks.BOOMGOURD.get(), 15, 100);
            fire.setFlammable((Block)UGBlocks.GRONGLET.get(), 100, 100);
        });
    }

    private static void registerSpawnPlacements(RegisterSpawnPlacementsEvent event) {
        event.register((EntityType)UGEntityTypes.GWIBLING.get(), SpawnPlacementTypes.IN_WATER, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, Gwibling::canGwiblingSpawn, RegisterSpawnPlacementsEvent.Operation.REPLACE);
        event.register((EntityType)UGEntityTypes.DWELLER.get(), SpawnPlacementTypes.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, Animal::checkAnimalSpawnRules, RegisterSpawnPlacementsEvent.Operation.REPLACE);
        event.register((EntityType)UGEntityTypes.ROTLING.get(), SpawnPlacementTypes.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, RotspawnMonster::canRotspawnSpawn, RegisterSpawnPlacementsEvent.Operation.REPLACE);
        event.register((EntityType)UGEntityTypes.ROTWALKER.get(), SpawnPlacementTypes.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, RotspawnMonster::canRotspawnSpawn, RegisterSpawnPlacementsEvent.Operation.REPLACE);
        event.register((EntityType)UGEntityTypes.ROTBEAST.get(), SpawnPlacementTypes.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, RotspawnMonster::canRotspawnSpawn, RegisterSpawnPlacementsEvent.Operation.REPLACE);
        event.register((EntityType)UGEntityTypes.BRUTE.get(), SpawnPlacementTypes.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, Animal::checkAnimalSpawnRules, RegisterSpawnPlacementsEvent.Operation.REPLACE);
        event.register((EntityType)UGEntityTypes.SCINTLING.get(), SpawnPlacementTypes.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, Scintling::canScintlingSpawn, RegisterSpawnPlacementsEvent.Operation.REPLACE);
        event.register((EntityType)UGEntityTypes.GLOOMPER.get(), SpawnPlacementTypes.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, Animal::checkAnimalSpawnRules, RegisterSpawnPlacementsEvent.Operation.REPLACE);
        event.register((EntityType)UGEntityTypes.STONEBORN.get(), SpawnPlacementTypes.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, Stoneborn::canStonebornSpawn, RegisterSpawnPlacementsEvent.Operation.REPLACE);
        event.register((EntityType)UGEntityTypes.NARGOYLE.get(), SpawnPlacementTypes.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, CavernMonster::canCreatureSpawn, RegisterSpawnPlacementsEvent.Operation.REPLACE);
        event.register((EntityType)UGEntityTypes.MUNCHER.get(), SpawnPlacementTypes.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, CavernMonster::canCreatureSpawn, RegisterSpawnPlacementsEvent.Operation.REPLACE);
        event.register((EntityType)UGEntityTypes.SPLOOGIE.get(), SpawnPlacementTypes.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, CavernMonster::canCreatureSpawn, RegisterSpawnPlacementsEvent.Operation.REPLACE);
        event.register((EntityType)UGEntityTypes.GWIB.get(), SpawnPlacementTypes.IN_WATER, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, Gwib::canGwibSpawn, RegisterSpawnPlacementsEvent.Operation.REPLACE);
        event.register((EntityType)UGEntityTypes.MOG.get(), SpawnPlacementTypes.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, Animal::checkAnimalSpawnRules, RegisterSpawnPlacementsEvent.Operation.REPLACE);
        event.register((EntityType)UGEntityTypes.SMOG_MOG.get(), SpawnPlacementTypes.NO_RESTRICTIONS, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, SmogMog::checkSmogMogSpawnRules, RegisterSpawnPlacementsEvent.Operation.REPLACE);
        event.register((EntityType)UGEntityTypes.FORGOTTEN.get(), SpawnPlacementTypes.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, Monster::checkMonsterSpawnRules, RegisterSpawnPlacementsEvent.Operation.REPLACE);
        event.register((EntityType)UGEntityTypes.FORGOTTEN_GUARDIAN.get(), SpawnPlacementTypes.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, Monster::checkMonsterSpawnRules, RegisterSpawnPlacementsEvent.Operation.REPLACE);
    }

    private static void registerEntityAttributes(EntityAttributeCreationEvent event) {
        event.put((EntityType)UGEntityTypes.ROTLING.get(), Rotling.registerAttributes().build());
        event.put((EntityType)UGEntityTypes.ROTWALKER.get(), Rotwalker.registerAttributes().build());
        event.put((EntityType)UGEntityTypes.ROTBEAST.get(), Rotbeast.registerAttributes().build());
        event.put((EntityType)UGEntityTypes.DWELLER.get(), Dweller.registerAttributes().build());
        event.put((EntityType)UGEntityTypes.GWIBLING.get(), AbstractFish.createAttributes().build());
        event.put((EntityType)UGEntityTypes.BRUTE.get(), Brute.registerAttributes().build());
        event.put((EntityType)UGEntityTypes.SCINTLING.get(), Scintling.registerAttributes().build());
        event.put((EntityType)UGEntityTypes.GLOOMPER.get(), Gloomper.registerAttributes().build());
        event.put((EntityType)UGEntityTypes.STONEBORN.get(), Stoneborn.registerAttributes().build());
        event.put((EntityType)UGEntityTypes.NARGOYLE.get(), Nargoyle.registerAttributes().build());
        event.put((EntityType)UGEntityTypes.FORGOTTEN_GUARDIAN.get(), ForgottenGuardian.registerAttributes().build());
        event.put((EntityType)UGEntityTypes.MUNCHER.get(), Muncher.registerAttributes().build());
        event.put((EntityType)UGEntityTypes.SPLOOGIE.get(), Sploogie.registerAttributes().build());
        event.put((EntityType)UGEntityTypes.MINION.get(), Minion.registerAttributes().build());
        event.put((EntityType)UGEntityTypes.GWIB.get(), Gwib.registerAttributes().build());
        event.put((EntityType)UGEntityTypes.MOG.get(), Mog.registerAttributes().build());
        event.put((EntityType)UGEntityTypes.SMOG_MOG.get(), SmogMog.registerAttributes().build());
        event.put((EntityType)UGEntityTypes.FORGOTTEN.get(), Forgotten.createAttributes().build());
    }

    private static void registerPotionRecipes(RegisterBrewingRecipesEvent event) {
        PotionBrewing.Builder builder = event.getBuilder();
        builder.addMix(Potions.AWKWARD, (Item)UGItems.BLOOD_GLOBULE.get(), UGPotions.BRITTLENESS);
        builder.addMix(UGPotions.BRITTLENESS, Items.REDSTONE, UGPotions.LONG_BRITTLENESS);
        builder.addMix(UGPotions.BRITTLENESS, Items.GLOWSTONE_DUST, UGPotions.STRONG_BRITTLENESS);
        builder.addMix(Potions.AWKWARD, ((Block)UGBlocks.VEIL_MUSHROOM.get()).asItem(), UGPotions.FEATHERWEIGHT);
        builder.addMix(UGPotions.FEATHERWEIGHT, Items.REDSTONE, UGPotions.LONG_FEATHERWEIGHT);
        builder.addMix(UGPotions.FEATHERWEIGHT, Items.GLOWSTONE_DUST, UGPotions.STRONG_FEATHERWEIGHT);
        builder.addMix(Potions.AWKWARD, ((Block)UGBlocks.GLOOMGOURD.get()).asItem(), UGPotions.VIRULENT_RESISTANCE);
        builder.addMix(UGPotions.VIRULENT_RESISTANCE, Items.REDSTONE, UGPotions.LONG_VIRULENT_RESISTANCE);
        builder.addMix(Potions.AWKWARD, (Item)UGItems.DROOPFRUIT.get(), UGPotions.GLOWING);
        builder.addMix(UGPotions.GLOWING, Items.REDSTONE, UGPotions.LONG_GLOWING);
    }

    private static void tickPortalLogic(EntityTickEvent.Pre event) {
        Entity entity = event.getEntity();
        if (entity instanceof Player) {
            Player player = (Player)entity;
            ((UndergardenPortalAttachment)player.getData(UGAttachments.UNDERGARDEN_PORTAL)).handleUndergardenPortal(player);
        }
    }

    private static void blockToolInteractions(BlockEvent.BlockToolModificationEvent event) {
        ItemAbility action = event.getItemAbility();
        BlockState state = event.getState();
        UseOnContext context = event.getContext();
        if (!event.isSimulated()) {
            if (action == ItemAbilities.AXE_STRIP) {
                if (state.is((Block)UGBlocks.SMOGSTEM_LOG.get())) {
                    event.setFinalState(((RotatedPillarBlock)UGBlocks.STRIPPED_SMOGSTEM_LOG.get()).withPropertiesOf(state));
                }
                if (state.is((Block)UGBlocks.SMOGSTEM_WOOD.get())) {
                    event.setFinalState(((RotatedPillarBlock)UGBlocks.STRIPPED_SMOGSTEM_WOOD.get()).withPropertiesOf(state));
                }
                if (state.is((Block)UGBlocks.WIGGLEWOOD_LOG.get())) {
                    event.setFinalState(((RotatedPillarBlock)UGBlocks.STRIPPED_WIGGLEWOOD_LOG.get()).withPropertiesOf(state));
                }
                if (state.is((Block)UGBlocks.WIGGLEWOOD_WOOD.get())) {
                    event.setFinalState(((RotatedPillarBlock)UGBlocks.STRIPPED_WIGGLEWOOD_WOOD.get()).withPropertiesOf(state));
                }
                if (state.is((Block)UGBlocks.GRONGLE_LOG.get())) {
                    event.setFinalState(((RotatedPillarBlock)UGBlocks.STRIPPED_GRONGLE_LOG.get()).withPropertiesOf(state));
                }
                if (state.is((Block)UGBlocks.GRONGLE_WOOD.get())) {
                    event.setFinalState(((RotatedPillarBlock)UGBlocks.STRIPPED_GRONGLE_WOOD.get()).withPropertiesOf(state));
                }
            }
            if (action == ItemAbilities.HOE_TILL && context.getClickedFace() != Direction.DOWN && context.getLevel().getBlockState(context.getClickedPos().above()).isAir()) {
                if (state.is((Block)UGBlocks.DEEPTURF_BLOCK.get()) || state.is((Block)UGBlocks.DEEPSOIL.get()) || state.is((Block)UGBlocks.ASHEN_DEEPTURF_BLOCK.get()) || state.is((Block)UGBlocks.FROZEN_DEEPTURF_BLOCK.get())) {
                    event.setFinalState(((Block)UGBlocks.DEEPSOIL_FARMLAND.get()).defaultBlockState());
                }
                if (state.is((Block)UGBlocks.COARSE_DEEPSOIL.get())) {
                    event.setFinalState(((Block)UGBlocks.DEEPSOIL.get()).defaultBlockState());
                }
            }
        }
    }

    private static void applyBrittleness(LivingIncomingDamageEvent event) {
        LivingEntity entity = event.getEntity();
        DamageSource source = event.getSource();
        float damage = event.getAmount();
        if (entity.hasEffect(UGEffects.BRITTLENESS) && !source.is(DamageTypeTags.BYPASSES_INVULNERABILITY)) {
            int amplifier = entity.getEffect(UGEffects.BRITTLENESS).getAmplifier() + 1 + entity.getArmorValue() / 4 * 2;
            event.setAmount(damage + (float)amplifier);
        }
    }

    private static void applyFeatherweight(LivingKnockBackEvent event) {
        LivingEntity entity = event.getEntity();
        if (entity.hasEffect(UGEffects.FEATHERWEIGHT)) {
            int amplifier = entity.getEffect(UGEffects.FEATHERWEIGHT).getAmplifier() + 2;
            event.setStrength(event.getStrength() * (float)amplifier);
        }
    }

    private static void cancelPlayerFallDamageOnDweller(LivingIncomingDamageEvent event) {
        Player player;
        LivingEntity livingEntity = event.getEntity();
        if (livingEntity instanceof Player && (player = (Player)livingEntity).getVehicle() instanceof Dweller && event.getSource().is(DamageTypeTags.IS_FALL)) {
            event.setCanceled(true);
        }
    }

    private static void lookedAtEndermanWithGloomgourd(EnderManAngerEvent event) {
        if (!event.isCanceled() && !event.getPlayer().isCreative() && UndergardenCommonEvents.isPlayerLookingAtEnderman(event.getPlayer(), event.getEntity()) && !event.getEntity().isAngryAt((LivingEntity)event.getPlayer()) && event.getPlayer().getItemBySlot(EquipmentSlot.HEAD).is(((Block)UGBlocks.CARVED_GLOOMGOURD.get()).asItem())) {
            event.getEntity().level().getEntitiesOfClass(EnderMan.class, event.getEntity().getBoundingBox().inflate(64.0), enderMan -> enderMan.hasLineOfSight((Entity)event.getPlayer())).forEach(enderMan -> enderMan.setTarget((LivingEntity)event.getPlayer()));
        }
    }

    private static boolean isPlayerLookingAtEnderman(Player player, EnderMan enderMan) {
        Vec3 vec3 = player.getViewVector(1.0f).normalize();
        Vec3 vec31 = new Vec3(enderMan.getX() - player.getX(), enderMan.getEyeY() - player.getEyeY(), enderMan.getZ() - player.getZ());
        double d0 = vec31.length();
        double d1 = vec3.dot(vec31 = vec31.normalize());
        return d1 > 1.0 - 0.025 / d0 && player.hasLineOfSight((Entity)enderMan);
    }
}

