/*
 * Decompiled with CFR 0.152.
 */
package quek.undergarden.event;

import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.common.Tags;
import net.neoforged.neoforge.event.entity.living.LivingIncomingDamageEvent;
import net.neoforged.neoforge.event.entity.player.PlayerEvent;
import net.neoforged.neoforge.event.tick.EntityTickEvent;
import net.neoforged.neoforge.network.PacketDistributor;
import quek.undergarden.network.CreateCritParticlePacket;
import quek.undergarden.registry.UGEffects;
import quek.undergarden.registry.UGItems;
import quek.undergarden.registry.UGParticleTypes;
import quek.undergarden.registry.UGTags;

public class UndergardenToolEvents {
    protected static void setupToolEvents() {
        NeoForge.EVENT_BUS.addListener(UndergardenToolEvents::forgottenAttackEvent);
        NeoForge.EVENT_BUS.addListener(UndergardenToolEvents::forgottenDigEvent);
        NeoForge.EVENT_BUS.addListener(UndergardenToolEvents::utheriumAttackEvent);
        NeoForge.EVENT_BUS.addListener(UndergardenToolEvents::froststeelAttackEvent);
        NeoForge.EVENT_BUS.addListener(UndergardenToolEvents::froststeelTickEvent);
    }

    private static void forgottenAttackEvent(LivingIncomingDamageEvent event) {
        Player player;
        Entity source = event.getSource().getEntity();
        float damage = event.getAmount();
        if (source instanceof Player && ((player = (Player)source).getMainHandItem().getItem() == UGItems.FORGOTTEN_SWORD.get() || player.getMainHandItem().getItem() == UGItems.FORGOTTEN_AXE.get() || player.getMainHandItem().getItem() == UGItems.FORGOTTEN_BATTLEAXE.get()) && BuiltInRegistries.ENTITY_TYPE.getKey((Object)event.getEntity().getType()).getNamespace().equals("undergarden") && !event.getEntity().getType().is(Tags.EntityTypes.BOSSES)) {
            event.setAmount(damage * 1.5f);
        }
    }

    private static void forgottenDigEvent(PlayerEvent.BreakSpeed event) {
        Player player = event.getEntity();
        BlockState state = event.getState();
        if ((player.getMainHandItem().getItem() == UGItems.FORGOTTEN_PICKAXE.get() || player.getMainHandItem().getItem() == UGItems.FORGOTTEN_AXE.get() || player.getMainHandItem().getItem() == UGItems.FORGOTTEN_SHOVEL.get() || player.getMainHandItem().getItem() == UGItems.FORGOTTEN_HOE.get()) && state != null && BuiltInRegistries.BLOCK.getKey((Object)state.getBlock()).getNamespace().equals("undergarden")) {
            event.setNewSpeed(event.getOriginalSpeed() * 1.5f);
        }
    }

    private static void utheriumAttackEvent(LivingIncomingDamageEvent event) {
        Player player;
        Entity source = event.getSource().getEntity();
        float damage = event.getAmount();
        if (source instanceof Player && ((player = (Player)source).getMainHandItem().is((Item)UGItems.UTHERIUM_SWORD.get()) || player.getMainHandItem().is((Item)UGItems.UTHERIUM_AXE.get())) && event.getEntity().getType().is(UGTags.Entities.ROTSPAWN)) {
            event.setAmount(damage * 1.5f);
            if (!event.getEntity().level().isClientSide()) {
                PacketDistributor.sendToPlayersTrackingEntity((Entity)event.getEntity(), (CustomPacketPayload)new CreateCritParticlePacket(event.getEntity().getId(), 2, (ParticleOptions)UGParticleTypes.UTHERIUM_CRIT.get()), (CustomPacketPayload[])new CustomPacketPayload[0]);
            }
        }
    }

    private static void froststeelAttackEvent(LivingIncomingDamageEvent event) {
        Entity source = event.getSource().getEntity();
        if (source instanceof Player) {
            Player player = (Player)source;
            if (player.getMainHandItem().is((Item)UGItems.FROSTSTEEL_SWORD.get()) || player.getMainHandItem().is((Item)UGItems.FROSTSTEEL_AXE.get())) {
                event.getEntity().addEffect(new MobEffectInstance(UGEffects.CHILLY, 600, 2, false, false));
            }
            if (player.getMainHandItem().is((Item)UGItems.FROSTSTEEL_PICKAXE.get()) || player.getMainHandItem().is((Item)UGItems.FROSTSTEEL_SHOVEL.get())) {
                event.getEntity().addEffect(new MobEffectInstance(UGEffects.CHILLY, 600, 1, false, false));
            }
        }
    }

    private static void froststeelTickEvent(EntityTickEvent.Pre event) {
        Entity entity = event.getEntity();
        if (entity instanceof LivingEntity) {
            LivingEntity living = (LivingEntity)entity;
            if (living.tickCount % 5 == 0 && living.level().isClientSide() && living.getAttribute(Attributes.MOVEMENT_SPEED).getModifier(ResourceLocation.fromNamespaceAndPath((String)"undergarden", (String)"effect.chilly_slowness")) != null) {
                for (int i = 0; i < 5; ++i) {
                    double d2;
                    double d1;
                    double d0 = living.getRandom().nextFloat() * 2.0f - 1.0f;
                    if (d0 * d0 + (d1 = (double)(living.getRandom().nextFloat() * 2.0f - 1.0f)) * d1 + (d2 = (double)(living.getRandom().nextFloat() * 2.0f - 1.0f)) * d2 > 1.0) continue;
                    double d3 = living.getX(d0 / 2.0);
                    double d4 = living.getY(0.75 + d1 / 4.0);
                    double d5 = living.getZ(d2 / 2.0);
                    living.level().addParticle((ParticleOptions)UGParticleTypes.SNOWFLAKE.get(), false, d3, d4, d5, d0, d1 + 0.2, d2);
                }
            }
        }
    }
}

