/*
 * Decompiled with CFR 0.152.
 */
package quek.undergarden.registry;

import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.OptionalInt;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.BootstrapContext;
import net.minecraft.data.worldgen.features.FeatureUtils;
import net.minecraft.data.worldgen.placement.PlacementUtils;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.valueproviders.ConstantInt;
import net.minecraft.util.valueproviders.IntProvider;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.feature.ConfiguredFeature;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.configurations.BlockStateConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.DeltaFeatureConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.FeatureConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.HugeMushroomFeatureConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.OreConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.RandomPatchConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.SimpleBlockConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.TreeConfiguration;
import net.minecraft.world.level.levelgen.feature.featuresize.FeatureSize;
import net.minecraft.world.level.levelgen.feature.featuresize.ThreeLayersFeatureSize;
import net.minecraft.world.level.levelgen.feature.featuresize.TwoLayersFeatureSize;
import net.minecraft.world.level.levelgen.feature.foliageplacers.AcaciaFoliagePlacer;
import net.minecraft.world.level.levelgen.feature.foliageplacers.BlobFoliagePlacer;
import net.minecraft.world.level.levelgen.feature.foliageplacers.BushFoliagePlacer;
import net.minecraft.world.level.levelgen.feature.foliageplacers.DarkOakFoliagePlacer;
import net.minecraft.world.level.levelgen.feature.foliageplacers.FoliagePlacer;
import net.minecraft.world.level.levelgen.feature.stateproviders.BlockStateProvider;
import net.minecraft.world.level.levelgen.feature.stateproviders.RandomizedIntStateProvider;
import net.minecraft.world.level.levelgen.feature.treedecorators.AttachedToLeavesDecorator;
import net.minecraft.world.level.levelgen.feature.trunkplacers.DarkOakTrunkPlacer;
import net.minecraft.world.level.levelgen.feature.trunkplacers.ForkingTrunkPlacer;
import net.minecraft.world.level.levelgen.feature.trunkplacers.MegaJungleTrunkPlacer;
import net.minecraft.world.level.levelgen.feature.trunkplacers.StraightTrunkPlacer;
import net.minecraft.world.level.levelgen.feature.trunkplacers.TrunkPlacer;
import net.minecraft.world.level.levelgen.structure.templatesystem.RuleTest;
import net.minecraft.world.level.levelgen.structure.templatesystem.TagMatchTest;
import quek.undergarden.block.BlisterberryBushBlock;
import quek.undergarden.block.DepthrockPebblesBlock;
import quek.undergarden.block.DitchbulbBlock;
import quek.undergarden.block.UnderbeanBushBlock;
import quek.undergarden.registry.UGBlocks;
import quek.undergarden.registry.UGFeatures;
import quek.undergarden.registry.UGTags;
import quek.undergarden.world.gen.foliageplacer.VeilFoliagePlacer;
import quek.undergarden.world.gen.treedecorator.GrongleLeafDecorator;
import quek.undergarden.world.gen.treedecorator.GrongletTrunkDecorator;
import quek.undergarden.world.gen.treedecorator.ReplaceLeafDecorator;
import quek.undergarden.world.gen.trunkplacer.SingleForkingTrunkPlacer;
import quek.undergarden.world.gen.trunkplacer.SmogstemTrunkPlacer;

public class UGConfiguredFeatures {
    public static final RuleTest BASE_STONE_UNDERGARDEN = new TagMatchTest(UGTags.Blocks.BASE_STONE_UNDERGARDEN);
    public static final RuleTest DEPTHROCK_ORE_REPLACEABLES = new TagMatchTest(UGTags.Blocks.DEPTHROCK_ORE_REPLACEABLES);
    public static final RuleTest SHIVERSTONE_ORE_REPLACEABLES = new TagMatchTest(UGTags.Blocks.SHIVERSTONE_ORE_REPLACEABLES);
    public static final RuleTest TREMBLECRUST_ORE_REPLACEABLES = new TagMatchTest(UGTags.Blocks.TREMBLECRUST_ORE_REPLACEABLES);
    public static final ResourceKey<ConfiguredFeature<?, ?>> COAL_ORE = UGConfiguredFeatures.create("coal_ore");
    public static final ResourceKey<ConfiguredFeature<?, ?>> IRON_ORE = UGConfiguredFeatures.create("iron_ore");
    public static final ResourceKey<ConfiguredFeature<?, ?>> GOLD_ORE = UGConfiguredFeatures.create("gold_ore");
    public static final ResourceKey<ConfiguredFeature<?, ?>> DIAMOND_ORE = UGConfiguredFeatures.create("diamond_ore");
    public static final ResourceKey<ConfiguredFeature<?, ?>> CLOGGRUM_ORE = UGConfiguredFeatures.create("cloggrum_ore");
    public static final ResourceKey<ConfiguredFeature<?, ?>> FROSTSTEEL_ORE = UGConfiguredFeatures.create("froststeel_ore");
    public static final ResourceKey<ConfiguredFeature<?, ?>> UTHERIUM_ORE = UGConfiguredFeatures.create("utherium_ore");
    public static final ResourceKey<ConfiguredFeature<?, ?>> REGALIUM_ORE = UGConfiguredFeatures.create("regalium_ore");
    public static final ResourceKey<ConfiguredFeature<?, ?>> SHIVERSTONE_ORE = UGConfiguredFeatures.create("shiverstone_ore");
    public static final ResourceKey<ConfiguredFeature<?, ?>> DEEPSOIL_ORE = UGConfiguredFeatures.create("deepsoil_ore");
    public static final ResourceKey<ConfiguredFeature<?, ?>> ICE_ORE = UGConfiguredFeatures.create("ice_ore");
    public static final ResourceKey<ConfiguredFeature<?, ?>> SEDIMENT_ORE = UGConfiguredFeatures.create("sediment_ore");
    public static final ResourceKey<ConfiguredFeature<?, ?>> BOG_DELTA = UGConfiguredFeatures.create("bog_delta");
    public static final ResourceKey<ConfiguredFeature<?, ?>> GRONGLEGROWTH_DELTA = UGConfiguredFeatures.create("gronglegrowth_delta");
    public static final ResourceKey<ConfiguredFeature<?, ?>> AMOROUS_BRISTLE_PATCH = UGConfiguredFeatures.create("amorous_bristle_patch");
    public static final ResourceKey<ConfiguredFeature<?, ?>> MISERABELL_PATCH = UGConfiguredFeatures.create("miserabell_patch");
    public static final ResourceKey<ConfiguredFeature<?, ?>> BUTTERBUNCH_PATCH = UGConfiguredFeatures.create("butterbunch_patch");
    public static final ResourceKey<ConfiguredFeature<?, ?>> DEEPTURF_PATCH = UGConfiguredFeatures.create("deepturf_patch");
    public static final ResourceKey<ConfiguredFeature<?, ?>> ASHEN_DEEPTURF_PATCH = UGConfiguredFeatures.create("ashen_deepturf_patch");
    public static final ResourceKey<ConfiguredFeature<?, ?>> FROZEN_DEEPTURF_PATCH = UGConfiguredFeatures.create("frozen_deepturf_patch");
    public static final ResourceKey<ConfiguredFeature<?, ?>> SHIMMERWEED_PATCH = UGConfiguredFeatures.create("shimmerweed_patch");
    public static final ResourceKey<ConfiguredFeature<?, ?>> DEPTHROCK_PEBBLE_PATCH = UGConfiguredFeatures.create("depthrock_pebble_patch");
    public static final ResourceKey<ConfiguredFeature<?, ?>> DITCHBULB_PATCH = UGConfiguredFeatures.create("ditchbulb_patch");
    public static final ResourceKey<ConfiguredFeature<?, ?>> TALL_DEEPTURF_PATCH = UGConfiguredFeatures.create("tall_deepturf_patch");
    public static final ResourceKey<ConfiguredFeature<?, ?>> TALL_SHIMMERWEED_PATCH = UGConfiguredFeatures.create("tall_shimmerweed_patch");
    public static final ResourceKey<ConfiguredFeature<?, ?>> INDIGO_MUSHROOM_PATCH = UGConfiguredFeatures.create("indigo_mushroom_patch");
    public static final ResourceKey<ConfiguredFeature<?, ?>> VEIL_MUSHROOM_PATCH = UGConfiguredFeatures.create("veil_mushroom_patch");
    public static final ResourceKey<ConfiguredFeature<?, ?>> INK_MUSHROOM_PATCH = UGConfiguredFeatures.create("ink_mushroom_patch");
    public static final ResourceKey<ConfiguredFeature<?, ?>> BLOOD_MUSHROOM_PATCH = UGConfiguredFeatures.create("blood_mushroom_patch");
    public static final ResourceKey<ConfiguredFeature<?, ?>> UNDERBEAN_BUSH_PATCH = UGConfiguredFeatures.create("underbean_bush_patch");
    public static final ResourceKey<ConfiguredFeature<?, ?>> BLISTERBERRY_BUSH_PATCH = UGConfiguredFeatures.create("blisterberry_bush_patch");
    public static final ResourceKey<ConfiguredFeature<?, ?>> GLOOMGOURD_PATCH = UGConfiguredFeatures.create("gloomgourd_patch");
    public static final ResourceKey<ConfiguredFeature<?, ?>> DROOPVINE = UGConfiguredFeatures.create("droopvine");
    public static final ResourceKey<ConfiguredFeature<?, ?>> GLITTERKELP = UGConfiguredFeatures.create("glitterkelp");
    public static final ResourceKey<ConfiguredFeature<?, ?>> SMOGSTEM_TREE = UGConfiguredFeatures.create("smogstem_tree");
    public static final ResourceKey<ConfiguredFeature<?, ?>> WIDE_SMOGSTEM_TREE = UGConfiguredFeatures.create("wide_smogstem_tree");
    public static final ResourceKey<ConfiguredFeature<?, ?>> TALL_SMOGSTEM_TREE = UGConfiguredFeatures.create("tall_smogstem_tree");
    public static final ResourceKey<ConfiguredFeature<?, ?>> SMOGSTEM_BUSH = UGConfiguredFeatures.create("smogstem_bush");
    public static final ResourceKey<ConfiguredFeature<?, ?>> WIGGLEWOOD_TREE = UGConfiguredFeatures.create("wigglewood_tree");
    public static final ResourceKey<ConfiguredFeature<?, ?>> TALL_WIGGLEWOOD_TREE = UGConfiguredFeatures.create("tall_wigglewood_tree");
    public static final ResourceKey<ConfiguredFeature<?, ?>> GRONGLE_TREE = UGConfiguredFeatures.create("grongle_tree");
    public static final ResourceKey<ConfiguredFeature<?, ?>> SMALL_GRONGLE_TREE = UGConfiguredFeatures.create("small_grongle_tree");
    public static final ResourceKey<ConfiguredFeature<?, ?>> GRONGLE_BUSH = UGConfiguredFeatures.create("grongle_bush");
    public static final ResourceKey<ConfiguredFeature<?, ?>> HUGE_INDIGO_MUSHROOM = UGConfiguredFeatures.create("huge_indigo_mushroom");
    public static final ResourceKey<ConfiguredFeature<?, ?>> HUGE_VEIL_MUSHROOM = UGConfiguredFeatures.create("huge_veil_mushroom");
    public static final ResourceKey<ConfiguredFeature<?, ?>> HUGE_INK_MUSHROOM = UGConfiguredFeatures.create("huge_ink_mushroom");
    public static final ResourceKey<ConfiguredFeature<?, ?>> HUGE_BLOOD_MUSHROOM = UGConfiguredFeatures.create("huge_blood_mushroom");
    public static final ResourceKey<ConfiguredFeature<?, ?>> DEPTHROCK_ROCK = UGConfiguredFeatures.create("depthrock_rock");
    public static final ResourceKey<ConfiguredFeature<?, ?>> SHIVERSTONE_ROCK = UGConfiguredFeatures.create("shiverstone_rock");
    public static final ResourceKey<ConfiguredFeature<?, ?>> SMOG_VENT = UGConfiguredFeatures.create("smog_vent");
    public static final ResourceKey<ConfiguredFeature<?, ?>> ICE_PILLAR = UGConfiguredFeatures.create("ice_pillar");

    public static ResourceKey<ConfiguredFeature<?, ?>> create(String name) {
        return ResourceKey.create((ResourceKey)Registries.CONFIGURED_FEATURE, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"undergarden", (String)name));
    }

    public static void bootstrap(BootstrapContext<ConfiguredFeature<?, ?>> context) {
        context.register(COAL_ORE, (Object)new ConfiguredFeature(Feature.ORE, (FeatureConfiguration)new OreConfiguration((List)ImmutableList.of((Object)OreConfiguration.target((RuleTest)DEPTHROCK_ORE_REPLACEABLES, (BlockState)((Block)UGBlocks.DEPTHROCK_COAL_ORE.get()).defaultBlockState()), (Object)OreConfiguration.target((RuleTest)SHIVERSTONE_ORE_REPLACEABLES, (BlockState)((Block)UGBlocks.SHIVERSTONE_COAL_ORE.get()).defaultBlockState())), 17)));
        context.register(IRON_ORE, (Object)new ConfiguredFeature(Feature.ORE, (FeatureConfiguration)new OreConfiguration((List)ImmutableList.of((Object)OreConfiguration.target((RuleTest)DEPTHROCK_ORE_REPLACEABLES, (BlockState)((Block)UGBlocks.DEPTHROCK_IRON_ORE.get()).defaultBlockState()), (Object)OreConfiguration.target((RuleTest)SHIVERSTONE_ORE_REPLACEABLES, (BlockState)((Block)UGBlocks.SHIVERSTONE_IRON_ORE.get()).defaultBlockState())), 9, 0.5f)));
        context.register(GOLD_ORE, (Object)new ConfiguredFeature(Feature.ORE, (FeatureConfiguration)new OreConfiguration((List)ImmutableList.of((Object)OreConfiguration.target((RuleTest)DEPTHROCK_ORE_REPLACEABLES, (BlockState)((Block)UGBlocks.DEPTHROCK_GOLD_ORE.get()).defaultBlockState())), 9, 0.5f)));
        context.register(DIAMOND_ORE, (Object)new ConfiguredFeature(Feature.ORE, (FeatureConfiguration)new OreConfiguration((List)ImmutableList.of((Object)OreConfiguration.target((RuleTest)DEPTHROCK_ORE_REPLACEABLES, (BlockState)((Block)UGBlocks.DEPTHROCK_DIAMOND_ORE.get()).defaultBlockState()), (Object)OreConfiguration.target((RuleTest)SHIVERSTONE_ORE_REPLACEABLES, (BlockState)((Block)UGBlocks.SHIVERSTONE_DIAMOND_ORE.get()).defaultBlockState())), 8, 0.5f)));
        context.register(CLOGGRUM_ORE, (Object)new ConfiguredFeature(Feature.ORE, (FeatureConfiguration)new OreConfiguration((List)ImmutableList.of((Object)OreConfiguration.target((RuleTest)DEPTHROCK_ORE_REPLACEABLES, (BlockState)((Block)UGBlocks.DEPTHROCK_CLOGGRUM_ORE.get()).defaultBlockState()), (Object)OreConfiguration.target((RuleTest)SHIVERSTONE_ORE_REPLACEABLES, (BlockState)((Block)UGBlocks.SHIVERSTONE_CLOGGRUM_ORE.get()).defaultBlockState())), 9)));
        context.register(FROSTSTEEL_ORE, (Object)new ConfiguredFeature(Feature.ORE, (FeatureConfiguration)new OreConfiguration((List)ImmutableList.of((Object)OreConfiguration.target((RuleTest)SHIVERSTONE_ORE_REPLACEABLES, (BlockState)((Block)UGBlocks.SHIVERSTONE_FROSTSTEEL_ORE.get()).defaultBlockState())), 9)));
        context.register(UTHERIUM_ORE, (Object)new ConfiguredFeature(Feature.ORE, (FeatureConfiguration)new OreConfiguration((List)ImmutableList.of((Object)OreConfiguration.target((RuleTest)DEPTHROCK_ORE_REPLACEABLES, (BlockState)((Block)UGBlocks.DEPTHROCK_UTHERIUM_ORE.get()).defaultBlockState()), (Object)OreConfiguration.target((RuleTest)SHIVERSTONE_ORE_REPLACEABLES, (BlockState)((Block)UGBlocks.SHIVERSTONE_UTHERIUM_ORE.get()).defaultBlockState()), (Object)OreConfiguration.target((RuleTest)TREMBLECRUST_ORE_REPLACEABLES, (BlockState)((Block)UGBlocks.TREMBLECRUST_UTHERIUM_ORE.get()).defaultBlockState())), 8, 0.5f)));
        context.register(REGALIUM_ORE, (Object)new ConfiguredFeature(Feature.ORE, (FeatureConfiguration)new OreConfiguration((List)ImmutableList.of((Object)OreConfiguration.target((RuleTest)DEPTHROCK_ORE_REPLACEABLES, (BlockState)((Block)UGBlocks.DEPTHROCK_REGALIUM_ORE.get()).defaultBlockState()), (Object)OreConfiguration.target((RuleTest)SHIVERSTONE_ORE_REPLACEABLES, (BlockState)((Block)UGBlocks.SHIVERSTONE_REGALIUM_ORE.get()).defaultBlockState())), 4)));
        context.register(SHIVERSTONE_ORE, (Object)new ConfiguredFeature(Feature.ORE, (FeatureConfiguration)new OreConfiguration(BASE_STONE_UNDERGARDEN, ((Block)UGBlocks.SHIVERSTONE.get()).defaultBlockState(), 33)));
        context.register(DEEPSOIL_ORE, (Object)new ConfiguredFeature(Feature.ORE, (FeatureConfiguration)new OreConfiguration(BASE_STONE_UNDERGARDEN, ((Block)UGBlocks.DEEPSOIL.get()).defaultBlockState(), 33)));
        context.register(ICE_ORE, (Object)new ConfiguredFeature(Feature.ORE, (FeatureConfiguration)new OreConfiguration(BASE_STONE_UNDERGARDEN, Blocks.PACKED_ICE.defaultBlockState(), 33)));
        context.register(SEDIMENT_ORE, (Object)new ConfiguredFeature(Feature.ORE, (FeatureConfiguration)new OreConfiguration(BASE_STONE_UNDERGARDEN, ((Block)UGBlocks.SEDIMENT.get()).defaultBlockState(), 33)));
        context.register(BOG_DELTA, (Object)new ConfiguredFeature((Feature)UGFeatures.DELTA.get(), (FeatureConfiguration)new DeltaFeatureConfiguration(((LiquidBlock)UGBlocks.VIRULENT_MIX.get()).defaultBlockState(), ((Block)UGBlocks.COARSE_DEEPSOIL.get()).defaultBlockState(), (IntProvider)UniformInt.of((int)6, (int)8), (IntProvider)UniformInt.of((int)2, (int)4))));
        context.register(GRONGLEGROWTH_DELTA, (Object)new ConfiguredFeature((Feature)UGFeatures.DELTA.get(), (FeatureConfiguration)new DeltaFeatureConfiguration(Blocks.WATER.defaultBlockState(), ((Block)UGBlocks.SEDIMENT.get()).defaultBlockState(), (IntProvider)UniformInt.of((int)3, (int)4), (IntProvider)UniformInt.of((int)2, (int)4))));
        context.register(AMOROUS_BRISTLE_PATCH, (Object)new ConfiguredFeature(Feature.FLOWER, (FeatureConfiguration)UGConfiguredFeatures.patch((Block)UGBlocks.AMOROUS_BRISTLE.get(), 64)));
        context.register(MISERABELL_PATCH, (Object)new ConfiguredFeature(Feature.FLOWER, (FeatureConfiguration)UGConfiguredFeatures.patch((Block)UGBlocks.MISERABELL.get(), 64)));
        context.register(BUTTERBUNCH_PATCH, (Object)new ConfiguredFeature(Feature.FLOWER, (FeatureConfiguration)UGConfiguredFeatures.patch((Block)UGBlocks.BUTTERBUNCH.get(), 64)));
        context.register(DEEPTURF_PATCH, (Object)new ConfiguredFeature(Feature.RANDOM_PATCH, (FeatureConfiguration)UGConfiguredFeatures.patch((Block)UGBlocks.DEEPTURF.get(), 64)));
        context.register(ASHEN_DEEPTURF_PATCH, (Object)new ConfiguredFeature(Feature.RANDOM_PATCH, (FeatureConfiguration)UGConfiguredFeatures.patch((Block)UGBlocks.ASHEN_DEEPTURF.get(), 64)));
        context.register(FROZEN_DEEPTURF_PATCH, (Object)new ConfiguredFeature(Feature.RANDOM_PATCH, (FeatureConfiguration)UGConfiguredFeatures.patch((Block)UGBlocks.FROZEN_DEEPTURF.get(), 64)));
        context.register(SHIMMERWEED_PATCH, (Object)new ConfiguredFeature(Feature.RANDOM_PATCH, (FeatureConfiguration)UGConfiguredFeatures.patch((Block)UGBlocks.SHIMMERWEED.get(), 32)));
        context.register(DEPTHROCK_PEBBLE_PATCH, (Object)new ConfiguredFeature(Feature.RANDOM_PATCH, (FeatureConfiguration)UGConfiguredFeatures.pebble((Block)UGBlocks.DEPTHROCK_PEBBLES.get(), List.of((Block)UGBlocks.DEEPTURF_BLOCK.get(), (Block)UGBlocks.ASHEN_DEEPTURF_BLOCK.get(), (Block)UGBlocks.DEPTHROCK.get(), (Block)UGBlocks.SHIVERSTONE.get(), (Block)UGBlocks.SEDIMENT.get(), (Block)UGBlocks.COARSE_DEEPSOIL.get()))));
        context.register(DITCHBULB_PATCH, (Object)new ConfiguredFeature(Feature.RANDOM_PATCH, (FeatureConfiguration)UGConfiguredFeatures.patch((BlockState)((Block)UGBlocks.DITCHBULB_PLANT.get()).defaultBlockState().setValue((Property)DitchbulbBlock.AGE, (Comparable)Integer.valueOf(1)), 16, List.of((Block)UGBlocks.DEPTHROCK.get()))));
        context.register(TALL_DEEPTURF_PATCH, (Object)new ConfiguredFeature(Feature.RANDOM_PATCH, (FeatureConfiguration)UGConfiguredFeatures.patch((Block)UGBlocks.TALL_DEEPTURF.get(), 32)));
        context.register(TALL_SHIMMERWEED_PATCH, (Object)new ConfiguredFeature(Feature.RANDOM_PATCH, (FeatureConfiguration)UGConfiguredFeatures.patch((Block)UGBlocks.TALL_SHIMMERWEED.get(), 32)));
        context.register(INDIGO_MUSHROOM_PATCH, (Object)new ConfiguredFeature(Feature.RANDOM_PATCH, (FeatureConfiguration)UGConfiguredFeatures.patch((Block)UGBlocks.INDIGO_MUSHROOM.get(), 64)));
        context.register(VEIL_MUSHROOM_PATCH, (Object)new ConfiguredFeature(Feature.RANDOM_PATCH, (FeatureConfiguration)UGConfiguredFeatures.patch((Block)UGBlocks.VEIL_MUSHROOM.get(), 64)));
        context.register(INK_MUSHROOM_PATCH, (Object)new ConfiguredFeature(Feature.RANDOM_PATCH, (FeatureConfiguration)UGConfiguredFeatures.patch((Block)UGBlocks.INK_MUSHROOM.get(), 64)));
        context.register(BLOOD_MUSHROOM_PATCH, (Object)new ConfiguredFeature(Feature.RANDOM_PATCH, (FeatureConfiguration)UGConfiguredFeatures.patch((Block)UGBlocks.BLOOD_MUSHROOM.get(), 64)));
        context.register(UNDERBEAN_BUSH_PATCH, (Object)new ConfiguredFeature(Feature.RANDOM_PATCH, (FeatureConfiguration)UGConfiguredFeatures.patch((BlockState)((Block)UGBlocks.UNDERBEAN_BUSH.get()).defaultBlockState().setValue((Property)UnderbeanBushBlock.AGE, (Comparable)Integer.valueOf(3)), 64, List.of((Block)UGBlocks.DEEPTURF_BLOCK.get()))));
        context.register(BLISTERBERRY_BUSH_PATCH, (Object)new ConfiguredFeature(Feature.RANDOM_PATCH, (FeatureConfiguration)UGConfiguredFeatures.patch((BlockState)((Block)UGBlocks.BLISTERBERRY_BUSH.get()).defaultBlockState().setValue((Property)BlisterberryBushBlock.AGE, (Comparable)Integer.valueOf(3)), 64, List.of((Block)UGBlocks.ASHEN_DEEPTURF_BLOCK.get()))));
        context.register(GLOOMGOURD_PATCH, (Object)new ConfiguredFeature(Feature.RANDOM_PATCH, (FeatureConfiguration)UGConfiguredFeatures.patch((Block)UGBlocks.GLOOMGOURD.get(), 16, List.of((Block)UGBlocks.DEEPTURF_BLOCK.get()))));
        context.register(DROOPVINE, (Object)new ConfiguredFeature((Feature)UGFeatures.DROOPVINE.get(), (FeatureConfiguration)FeatureConfiguration.NONE));
        context.register(GLITTERKELP, (Object)new ConfiguredFeature((Feature)UGFeatures.GLITTERKELP.get(), (FeatureConfiguration)FeatureConfiguration.NONE));
        context.register(SMOGSTEM_TREE, (Object)new ConfiguredFeature(Feature.TREE, (FeatureConfiguration)new TreeConfiguration.TreeConfigurationBuilder((BlockStateProvider)BlockStateProvider.simple((Block)((Block)UGBlocks.SMOGSTEM_LOG.get())), (TrunkPlacer)new SmogstemTrunkPlacer(10, 2, 2, 1), (BlockStateProvider)BlockStateProvider.simple((Block)((Block)UGBlocks.SMOGSTEM_LEAVES.get())), (FoliagePlacer)new BlobFoliagePlacer((IntProvider)ConstantInt.of((int)3), (IntProvider)ConstantInt.of((int)0), 2), (FeatureSize)new TwoLayersFeatureSize(1, 1, 2)).ignoreVines().dirt((BlockStateProvider)BlockStateProvider.simple((Block)((Block)UGBlocks.DEEPSOIL.get()))).build()));
        context.register(WIDE_SMOGSTEM_TREE, (Object)new ConfiguredFeature(Feature.TREE, (FeatureConfiguration)new TreeConfiguration.TreeConfigurationBuilder((BlockStateProvider)BlockStateProvider.simple((Block)((Block)UGBlocks.SMOGSTEM_LOG.get())), (TrunkPlacer)new SmogstemTrunkPlacer(10, 2, 2, 2), (BlockStateProvider)BlockStateProvider.simple((Block)((Block)UGBlocks.SMOGSTEM_LEAVES.get())), (FoliagePlacer)new BlobFoliagePlacer((IntProvider)ConstantInt.of((int)3), (IntProvider)ConstantInt.of((int)0), 2), (FeatureSize)new TwoLayersFeatureSize(1, 1, 2)).ignoreVines().dirt((BlockStateProvider)BlockStateProvider.simple((Block)((Block)UGBlocks.DEEPSOIL.get()))).build()));
        context.register(TALL_SMOGSTEM_TREE, (Object)new ConfiguredFeature(Feature.TREE, (FeatureConfiguration)new TreeConfiguration.TreeConfigurationBuilder((BlockStateProvider)BlockStateProvider.simple((Block)((Block)UGBlocks.SMOGSTEM_LOG.get())), (TrunkPlacer)new SmogstemTrunkPlacer(15, 4, 4, 2), (BlockStateProvider)BlockStateProvider.simple((Block)((Block)UGBlocks.SMOGSTEM_LEAVES.get())), (FoliagePlacer)new BlobFoliagePlacer((IntProvider)ConstantInt.of((int)3), (IntProvider)ConstantInt.of((int)0), 2), (FeatureSize)new TwoLayersFeatureSize(1, 1, 2)).ignoreVines().dirt((BlockStateProvider)BlockStateProvider.simple((Block)((Block)UGBlocks.DEEPSOIL.get()))).build()));
        context.register(SMOGSTEM_BUSH, (Object)new ConfiguredFeature(Feature.TREE, (FeatureConfiguration)new TreeConfiguration.TreeConfigurationBuilder((BlockStateProvider)BlockStateProvider.simple((Block)((Block)UGBlocks.SMOGSTEM_LOG.get())), (TrunkPlacer)new StraightTrunkPlacer(1, 0, 0), (BlockStateProvider)BlockStateProvider.simple((Block)((Block)UGBlocks.SMOGSTEM_LEAVES.get())), (FoliagePlacer)new BushFoliagePlacer((IntProvider)ConstantInt.of((int)2), (IntProvider)ConstantInt.of((int)1), 2), (FeatureSize)new TwoLayersFeatureSize(0, 0, 0)).ignoreVines().dirt((BlockStateProvider)BlockStateProvider.simple((Block)((Block)UGBlocks.DEEPSOIL.get()))).build()));
        context.register(WIGGLEWOOD_TREE, (Object)new ConfiguredFeature(Feature.TREE, (FeatureConfiguration)new TreeConfiguration.TreeConfigurationBuilder((BlockStateProvider)BlockStateProvider.simple((Block)((Block)UGBlocks.WIGGLEWOOD_LOG.get())), (TrunkPlacer)new ForkingTrunkPlacer(3, 1, 1), (BlockStateProvider)BlockStateProvider.simple((Block)((Block)UGBlocks.WIGGLEWOOD_LEAVES.get())), (FoliagePlacer)new BushFoliagePlacer((IntProvider)ConstantInt.of((int)2), (IntProvider)ConstantInt.of((int)0), 0), (FeatureSize)new TwoLayersFeatureSize(1, 0, 2)).ignoreVines().dirt((BlockStateProvider)BlockStateProvider.simple((Block)((Block)UGBlocks.DEEPSOIL.get()))).build()));
        context.register(TALL_WIGGLEWOOD_TREE, (Object)new ConfiguredFeature(Feature.TREE, (FeatureConfiguration)new TreeConfiguration.TreeConfigurationBuilder((BlockStateProvider)BlockStateProvider.simple((Block)((Block)UGBlocks.WIGGLEWOOD_LOG.get())), (TrunkPlacer)new ForkingTrunkPlacer(6, 1, 1), (BlockStateProvider)BlockStateProvider.simple((Block)((Block)UGBlocks.WIGGLEWOOD_LEAVES.get())), (FoliagePlacer)new BushFoliagePlacer((IntProvider)ConstantInt.of((int)2), (IntProvider)ConstantInt.of((int)0), 0), (FeatureSize)new TwoLayersFeatureSize(1, 0, 2)).ignoreVines().dirt((BlockStateProvider)BlockStateProvider.simple((Block)((Block)UGBlocks.DEEPSOIL.get()))).build()));
        context.register(GRONGLE_TREE, (Object)new ConfiguredFeature(Feature.TREE, (FeatureConfiguration)new TreeConfiguration.TreeConfigurationBuilder((BlockStateProvider)BlockStateProvider.simple((Block)((Block)UGBlocks.GRONGLE_LOG.get())), (TrunkPlacer)new MegaJungleTrunkPlacer(10, 2, 19), (BlockStateProvider)BlockStateProvider.simple((Block)((Block)UGBlocks.GRONGLE_LEAVES.get())), (FoliagePlacer)new DarkOakFoliagePlacer((IntProvider)ConstantInt.of((int)0), (IntProvider)ConstantInt.of((int)0)), (FeatureSize)new TwoLayersFeatureSize(1, 1, 2)).ignoreVines().dirt((BlockStateProvider)BlockStateProvider.simple((Block)((Block)UGBlocks.DEEPSOIL.get()))).decorators((List)ImmutableList.of((Object)((Object)GrongleLeafDecorator.INSTANCE), (Object)((Object)GrongletTrunkDecorator.INSTANCE))).build()));
        context.register(SMALL_GRONGLE_TREE, (Object)new ConfiguredFeature(Feature.TREE, (FeatureConfiguration)new TreeConfiguration.TreeConfigurationBuilder((BlockStateProvider)BlockStateProvider.simple((Block)((Block)UGBlocks.GRONGLE_LOG.get())), (TrunkPlacer)new StraightTrunkPlacer(5, 2, 19), (BlockStateProvider)BlockStateProvider.simple((Block)((Block)UGBlocks.GRONGLE_LEAVES.get())), (FoliagePlacer)new DarkOakFoliagePlacer((IntProvider)ConstantInt.of((int)0), (IntProvider)ConstantInt.of((int)0)), (FeatureSize)new TwoLayersFeatureSize(1, 0, 1)).ignoreVines().dirt((BlockStateProvider)BlockStateProvider.simple((Block)((Block)UGBlocks.DEEPSOIL.get()))).decorators((List)ImmutableList.of((Object)((Object)GrongleLeafDecorator.INSTANCE), (Object)((Object)GrongletTrunkDecorator.INSTANCE))).build()));
        context.register(GRONGLE_BUSH, (Object)new ConfiguredFeature(Feature.TREE, (FeatureConfiguration)new TreeConfiguration.TreeConfigurationBuilder((BlockStateProvider)BlockStateProvider.simple((Block)((Block)UGBlocks.GRONGLE_LOG.get())), (TrunkPlacer)new StraightTrunkPlacer(1, 0, 0), (BlockStateProvider)BlockStateProvider.simple((Block)((Block)UGBlocks.GRONGLE_LEAVES.get())), (FoliagePlacer)new DarkOakFoliagePlacer((IntProvider)ConstantInt.of((int)0), (IntProvider)ConstantInt.of((int)0)), (FeatureSize)new TwoLayersFeatureSize(0, 0, 0)).ignoreVines().dirt((BlockStateProvider)BlockStateProvider.simple((Block)((Block)UGBlocks.DEEPSOIL.get()))).build()));
        context.register(HUGE_INDIGO_MUSHROOM, (Object)new ConfiguredFeature(Feature.HUGE_BROWN_MUSHROOM, (FeatureConfiguration)new HugeMushroomFeatureConfiguration((BlockStateProvider)BlockStateProvider.simple((BlockState)((Block)UGBlocks.INDIGO_MUSHROOM_CAP.get()).defaultBlockState()), (BlockStateProvider)BlockStateProvider.simple((BlockState)((Block)UGBlocks.INDIGO_MUSHROOM_STEM.get()).defaultBlockState()), 3)));
        context.register(HUGE_VEIL_MUSHROOM, (Object)new ConfiguredFeature(Feature.TREE, (FeatureConfiguration)new TreeConfiguration.TreeConfigurationBuilder((BlockStateProvider)BlockStateProvider.simple((Block)((Block)UGBlocks.VEIL_MUSHROOM_STEM.get())), (TrunkPlacer)new StraightTrunkPlacer(9, 1, 1), (BlockStateProvider)BlockStateProvider.simple((Block)((Block)UGBlocks.VEIL_MUSHROOM_CAP.get())), (FoliagePlacer)new VeilFoliagePlacer((IntProvider)ConstantInt.of((int)3), (IntProvider)ConstantInt.of((int)0)), (FeatureSize)new TwoLayersFeatureSize(1, 0, 1)).dirt((BlockStateProvider)BlockStateProvider.simple((Block)((Block)UGBlocks.DEEPSOIL.get()))).build()));
        context.register(HUGE_INK_MUSHROOM, (Object)new ConfiguredFeature(Feature.TREE, (FeatureConfiguration)new TreeConfiguration.TreeConfigurationBuilder((BlockStateProvider)BlockStateProvider.simple((Block)((Block)UGBlocks.INK_MUSHROOM_STEM.get())), (TrunkPlacer)new SingleForkingTrunkPlacer(6, 2, 2), (BlockStateProvider)BlockStateProvider.simple((Block)((Block)UGBlocks.INK_MUSHROOM_CAP.get())), (FoliagePlacer)new AcaciaFoliagePlacer((IntProvider)ConstantInt.of((int)2), (IntProvider)ConstantInt.of((int)0)), (FeatureSize)new TwoLayersFeatureSize(1, 0, 2)).dirt((BlockStateProvider)BlockStateProvider.simple((Block)((Block)UGBlocks.DEEPSOIL.get()))).decorators((List)ImmutableList.of((Object)new AttachedToLeavesDecorator(0.2f, 1, 0, (BlockStateProvider)BlockStateProvider.simple((Block)((Block)UGBlocks.SEEPING_INK.get())), 1, List.of(Direction.DOWN)))).build()));
        context.register(HUGE_BLOOD_MUSHROOM, (Object)new ConfiguredFeature(Feature.TREE, (FeatureConfiguration)new TreeConfiguration.TreeConfigurationBuilder((BlockStateProvider)BlockStateProvider.simple((Block)((Block)UGBlocks.BLOOD_MUSHROOM_STEM.get())), (TrunkPlacer)new DarkOakTrunkPlacer(6, 2, 2), (BlockStateProvider)BlockStateProvider.simple((Block)((Block)UGBlocks.BLOOD_MUSHROOM_CAP.get())), (FoliagePlacer)new DarkOakFoliagePlacer((IntProvider)ConstantInt.of((int)0), (IntProvider)ConstantInt.of((int)0)), (FeatureSize)new ThreeLayersFeatureSize(1, 1, 0, 1, 2, OptionalInt.empty())).dirt((BlockStateProvider)BlockStateProvider.simple((Block)((Block)UGBlocks.DEEPSOIL.get()))).decorators((List)ImmutableList.of((Object)((Object)new ReplaceLeafDecorator(0.2f, (BlockStateProvider)BlockStateProvider.simple((Block)((Block)UGBlocks.ENGORGED_BLOOD_MUSHROOM_CAP.get())))))).build()));
        context.register(DEPTHROCK_ROCK, (Object)new ConfiguredFeature(Feature.FOREST_ROCK, (FeatureConfiguration)new BlockStateConfiguration(((Block)UGBlocks.DEPTHROCK.get()).defaultBlockState())));
        context.register(SHIVERSTONE_ROCK, (Object)new ConfiguredFeature(Feature.FOREST_ROCK, (FeatureConfiguration)new BlockStateConfiguration(((Block)UGBlocks.SHIVERSTONE.get()).defaultBlockState())));
        context.register(SMOG_VENT, (Object)new ConfiguredFeature((Feature)UGFeatures.SMOG_VENT.get(), (FeatureConfiguration)FeatureConfiguration.NONE));
        context.register(ICE_PILLAR, (Object)new ConfiguredFeature((Feature)UGFeatures.ICE_PILLAR.get(), (FeatureConfiguration)FeatureConfiguration.NONE));
    }

    private static RandomPatchConfiguration patch(Block block, int tries) {
        return FeatureUtils.simpleRandomPatchConfiguration((int)tries, (Holder)PlacementUtils.onlyWhenEmpty((Feature)Feature.SIMPLE_BLOCK, (FeatureConfiguration)new SimpleBlockConfiguration((BlockStateProvider)BlockStateProvider.simple((Block)block))));
    }

    private static RandomPatchConfiguration patch(Block block, int tries, List<Block> whitelist) {
        return FeatureUtils.simplePatchConfiguration((Feature)Feature.SIMPLE_BLOCK, (FeatureConfiguration)new SimpleBlockConfiguration((BlockStateProvider)BlockStateProvider.simple((Block)block)), whitelist, (int)tries);
    }

    private static RandomPatchConfiguration pebble(Block block, List<Block> whitelist) {
        return FeatureUtils.simplePatchConfiguration((Feature)Feature.SIMPLE_BLOCK, (FeatureConfiguration)new SimpleBlockConfiguration((BlockStateProvider)new RandomizedIntStateProvider((BlockStateProvider)BlockStateProvider.simple((Block)block), DepthrockPebblesBlock.PEBBLES, (IntProvider)UniformInt.of((int)1, (int)2))), whitelist, (int)32);
    }

    private static RandomPatchConfiguration patch(BlockState block, int tries, List<Block> whitelist) {
        return FeatureUtils.simplePatchConfiguration((Feature)Feature.SIMPLE_BLOCK, (FeatureConfiguration)new SimpleBlockConfiguration((BlockStateProvider)BlockStateProvider.simple((BlockState)block)), whitelist, (int)tries);
    }
}

