/*
 * Decompiled with CFR 0.152.
 */
package quek.undergarden.registry;

import com.google.common.collect.ImmutableList;
import com.mojang.datafixers.util.Pair;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.HolderSet;
import net.minecraft.core.Vec3i;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.BootstrapContext;
import net.minecraft.data.worldgen.Pools;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.random.WeightedEntry;
import net.minecraft.util.random.WeightedRandomList;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.level.biome.MobSpawnSettings;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.levelgen.GenerationStep;
import net.minecraft.world.level.levelgen.VerticalAnchor;
import net.minecraft.world.level.levelgen.heightproviders.ConstantHeight;
import net.minecraft.world.level.levelgen.heightproviders.HeightProvider;
import net.minecraft.world.level.levelgen.heightproviders.UniformHeight;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.StructureSet;
import net.minecraft.world.level.levelgen.structure.StructureSpawnOverride;
import net.minecraft.world.level.levelgen.structure.StructureType;
import net.minecraft.world.level.levelgen.structure.TerrainAdjustment;
import net.minecraft.world.level.levelgen.structure.placement.RandomSpreadStructurePlacement;
import net.minecraft.world.level.levelgen.structure.placement.RandomSpreadType;
import net.minecraft.world.level.levelgen.structure.placement.StructurePlacement;
import net.minecraft.world.level.levelgen.structure.pools.DimensionPadding;
import net.minecraft.world.level.levelgen.structure.pools.StructurePoolElement;
import net.minecraft.world.level.levelgen.structure.pools.StructureTemplatePool;
import net.minecraft.world.level.levelgen.structure.templatesystem.AlwaysTrueTest;
import net.minecraft.world.level.levelgen.structure.templatesystem.LiquidSettings;
import net.minecraft.world.level.levelgen.structure.templatesystem.ProcessorRule;
import net.minecraft.world.level.levelgen.structure.templatesystem.RandomBlockMatchTest;
import net.minecraft.world.level.levelgen.structure.templatesystem.RuleProcessor;
import net.minecraft.world.level.levelgen.structure.templatesystem.RuleTest;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessorList;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.neoforged.neoforge.registries.DeferredRegister;
import quek.undergarden.registry.UGBlocks;
import quek.undergarden.registry.UGEntityTypes;
import quek.undergarden.registry.UGTags;
import quek.undergarden.world.gen.structure.BiggerJigsawStructure;

public class UGStructures {
    public static final DeferredRegister<StructureType<?>> STRUCTURES = DeferredRegister.create((ResourceKey)Registries.STRUCTURE_TYPE, (String)"undergarden");
    public static final DeferredHolder<StructureType<?>, StructureType<BiggerJigsawStructure>> BIGGER_JIGSAW = STRUCTURES.register("bigger_jigsaw", () -> () -> BiggerJigsawStructure.CODEC);
    public static final ResourceKey<Structure> CATACOMBS = ResourceKey.create((ResourceKey)Registries.STRUCTURE, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"undergarden", (String)"catacombs"));
    public static final ResourceKey<StructureSet> CATACOMBS_SET = ResourceKey.create((ResourceKey)Registries.STRUCTURE_SET, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"undergarden", (String)"catacombs"));
    public static final ResourceKey<StructureTemplatePool> CATACOMBS_START = ResourceKey.create((ResourceKey)Registries.TEMPLATE_POOL, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"undergarden", (String)"catacombs/catacombs_entrance"));
    public static final ResourceKey<StructureTemplatePool> CATACOMBS_STAIR = ResourceKey.create((ResourceKey)Registries.TEMPLATE_POOL, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"undergarden", (String)"catacombs/stair_pool"));
    public static final ResourceKey<StructureTemplatePool> CATACOMBS_CHEST = ResourceKey.create((ResourceKey)Registries.TEMPLATE_POOL, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"undergarden", (String)"catacombs/chest_pool"));
    public static final ResourceKey<StructureTemplatePool> CATACOMBS_INTERIOR = ResourceKey.create((ResourceKey)Registries.TEMPLATE_POOL, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"undergarden", (String)"catacombs/interior_pool"));
    public static final ResourceKey<StructureTemplatePool> CATACOMBS_TUNNEL = ResourceKey.create((ResourceKey)Registries.TEMPLATE_POOL, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"undergarden", (String)"catacombs/tunnel_pool"));
    public static final ResourceKey<StructureTemplatePool> CATACOMBS_TUNNEL_FALLBACK = ResourceKey.create((ResourceKey)Registries.TEMPLATE_POOL, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"undergarden", (String)"catacombs/tunnel_fallback_pool"));
    public static final ResourceKey<StructureTemplatePool> CATACOMBS_WAY = ResourceKey.create((ResourceKey)Registries.TEMPLATE_POOL, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"undergarden", (String)"catacombs/way_pool"));
    public static final ResourceKey<StructureProcessorList> CATACOMBS_DEGRADATION = ResourceKey.create((ResourceKey)Registries.PROCESSOR_LIST, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"undergarden", (String)"catacombs_degradation"));
    public static final ResourceKey<Structure> FORGOTTEN_VESTIGE = ResourceKey.create((ResourceKey)Registries.STRUCTURE, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"undergarden", (String)"forgotten_vestige"));
    public static final ResourceKey<StructureSet> FORGOTTEN_VESTIGE_SET = ResourceKey.create((ResourceKey)Registries.STRUCTURE_SET, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"undergarden", (String)"forgotten_vestige"));
    public static final ResourceKey<StructureTemplatePool> FORGOTTEN_VESTIGE_POOL = ResourceKey.create((ResourceKey)Registries.TEMPLATE_POOL, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"undergarden", (String)"forgotten_vestige"));
    public static final ResourceKey<StructureProcessorList> FORGOTTEN_VESTIGE_DEGRADATION = ResourceKey.create((ResourceKey)Registries.PROCESSOR_LIST, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"undergarden", (String)"forgotten_vestige_degradation"));

    public static void bootstrapStructures(BootstrapContext<Structure> context) {
        HolderGetter biomes = context.lookup(Registries.BIOME);
        HolderGetter pools = context.lookup(Registries.TEMPLATE_POOL);
        context.register(CATACOMBS, (Object)new BiggerJigsawStructure(new Structure.StructureSettings((HolderSet)biomes.getOrThrow(UGTags.Biomes.HAS_CATACOMBS), Map.of(MobCategory.MONSTER, new StructureSpawnOverride(StructureSpawnOverride.BoundingBoxType.PIECE, WeightedRandomList.create((WeightedEntry[])new MobSpawnSettings.SpawnerData[]{new MobSpawnSettings.SpawnerData((EntityType)UGEntityTypes.FORGOTTEN.get(), 1, 1, 4)}))), GenerationStep.Decoration.SURFACE_STRUCTURES, TerrainAdjustment.NONE), (Holder<StructureTemplatePool>)pools.getOrThrow(CATACOMBS_START), Optional.empty(), 15, (HeightProvider)ConstantHeight.of((VerticalAnchor)VerticalAnchor.aboveBottom((int)48)), Optional.empty(), 116, List.of(), DimensionPadding.ZERO, LiquidSettings.IGNORE_WATERLOGGING));
        context.register(FORGOTTEN_VESTIGE, (Object)new BiggerJigsawStructure(new Structure.StructureSettings((HolderSet)biomes.getOrThrow(UGTags.Biomes.HAS_FORGOTTEN_VESTIGE), Map.of(), GenerationStep.Decoration.UNDERGROUND_STRUCTURES, TerrainAdjustment.BEARD_THIN), (Holder<StructureTemplatePool>)pools.getOrThrow(FORGOTTEN_VESTIGE_POOL), Optional.empty(), 5, (HeightProvider)UniformHeight.of((VerticalAnchor)VerticalAnchor.absolute((int)32), (VerticalAnchor)VerticalAnchor.TOP), Optional.empty(), 10, List.of(), DimensionPadding.ZERO, LiquidSettings.APPLY_WATERLOGGING));
    }

    public static void bootstrapSets(BootstrapContext<StructureSet> context) {
        HolderGetter structures = context.lookup(Registries.STRUCTURE);
        context.register(CATACOMBS_SET, (Object)new StructureSet((Holder)structures.getOrThrow(CATACOMBS), (StructurePlacement)new RandomSpreadStructurePlacement(24, 12, RandomSpreadType.LINEAR, 276320045)));
        context.register(FORGOTTEN_VESTIGE_SET, (Object)new StructureSet((Holder)structures.getOrThrow(FORGOTTEN_VESTIGE), (StructurePlacement)new RandomSpreadStructurePlacement(Vec3i.ZERO, StructurePlacement.FrequencyReductionMethod.DEFAULT, 0.85f, 276320046, Optional.empty(), 6, 3, RandomSpreadType.LINEAR)));
    }

    public static void bootstrapPools(BootstrapContext<StructureTemplatePool> context) {
        Holder.Reference emptyPool = context.lookup(Registries.TEMPLATE_POOL).getOrThrow(Pools.EMPTY);
        HolderGetter processors = context.lookup(Registries.PROCESSOR_LIST);
        context.register(CATACOMBS_START, (Object)new StructureTemplatePool((Holder)emptyPool, (List)ImmutableList.of((Object)Pair.of((Object)StructurePoolElement.single((String)UGStructures.name("catacombs/entrance1"), (Holder)processors.getOrThrow(CATACOMBS_DEGRADATION)), (Object)1), (Object)Pair.of((Object)StructurePoolElement.single((String)UGStructures.name("catacombs/entrance2"), (Holder)processors.getOrThrow(CATACOMBS_DEGRADATION)), (Object)1), (Object)Pair.of((Object)StructurePoolElement.single((String)UGStructures.name("catacombs/entrance3"), (Holder)processors.getOrThrow(CATACOMBS_DEGRADATION)), (Object)1), (Object)Pair.of((Object)StructurePoolElement.single((String)UGStructures.name("catacombs/entrance4"), (Holder)processors.getOrThrow(CATACOMBS_DEGRADATION)), (Object)1), (Object)Pair.of((Object)StructurePoolElement.single((String)UGStructures.name("catacombs/entrance5"), (Holder)processors.getOrThrow(CATACOMBS_DEGRADATION)), (Object)1)), StructureTemplatePool.Projection.RIGID));
        context.register(CATACOMBS_STAIR, (Object)new StructureTemplatePool((Holder)emptyPool, (List)ImmutableList.of((Object)Pair.of((Object)StructurePoolElement.single((String)UGStructures.name("catacombs/stair"), (Holder)processors.getOrThrow(CATACOMBS_DEGRADATION)), (Object)1)), StructureTemplatePool.Projection.RIGID));
        context.register(CATACOMBS_CHEST, (Object)new StructureTemplatePool((Holder)emptyPool, (List)ImmutableList.of((Object)Pair.of((Object)StructurePoolElement.single((String)"minecraft:empty"), (Object)2), (Object)Pair.of((Object)StructurePoolElement.single((String)UGStructures.name("catacombs/chest")), (Object)2), (Object)Pair.of((Object)StructurePoolElement.single((String)UGStructures.name("catacombs/chest_forgotten")), (Object)1)), StructureTemplatePool.Projection.RIGID));
        context.register(CATACOMBS_INTERIOR, (Object)new StructureTemplatePool((Holder)emptyPool, (List)ImmutableList.of((Object)Pair.of((Object)StructurePoolElement.single((String)UGStructures.name("catacombs/interior2"), (Holder)processors.getOrThrow(CATACOMBS_DEGRADATION)), (Object)1), (Object)Pair.of((Object)StructurePoolElement.single((String)UGStructures.name("catacombs/interior3"), (Holder)processors.getOrThrow(CATACOMBS_DEGRADATION)), (Object)1), (Object)Pair.of((Object)StructurePoolElement.single((String)UGStructures.name("catacombs/interior4_new"), (Holder)processors.getOrThrow(CATACOMBS_DEGRADATION)), (Object)1), (Object)Pair.of((Object)StructurePoolElement.single((String)UGStructures.name("catacombs/interior_altar"), (Holder)processors.getOrThrow(CATACOMBS_DEGRADATION)), (Object)1), (Object)Pair.of((Object)StructurePoolElement.single((String)UGStructures.name("catacombs/interior_grass"), (Holder)processors.getOrThrow(CATACOMBS_DEGRADATION)), (Object)1), (Object)Pair.of((Object)StructurePoolElement.single((String)UGStructures.name("catacombs/interior_jail"), (Holder)processors.getOrThrow(CATACOMBS_DEGRADATION)), (Object)1), (Object)Pair.of((Object)StructurePoolElement.single((String)UGStructures.name("catacombs/interior_morgue"), (Holder)processors.getOrThrow(CATACOMBS_DEGRADATION)), (Object)1)), StructureTemplatePool.Projection.RIGID));
        context.register(CATACOMBS_TUNNEL, (Object)new StructureTemplatePool((Holder)context.lookup(Registries.TEMPLATE_POOL).getOrThrow(CATACOMBS_TUNNEL_FALLBACK), (List)ImmutableList.of((Object)Pair.of((Object)StructurePoolElement.single((String)UGStructures.name("catacombs/tunnel1"), (Holder)processors.getOrThrow(CATACOMBS_DEGRADATION)), (Object)1), (Object)Pair.of((Object)StructurePoolElement.single((String)UGStructures.name("catacombs/tunnel2"), (Holder)processors.getOrThrow(CATACOMBS_DEGRADATION)), (Object)1), (Object)Pair.of((Object)StructurePoolElement.single((String)UGStructures.name("catacombs/tunnel3_new"), (Holder)processors.getOrThrow(CATACOMBS_DEGRADATION)), (Object)1), (Object)Pair.of((Object)StructurePoolElement.single((String)UGStructures.name("catacombs/tunnel4"), (Holder)processors.getOrThrow(CATACOMBS_DEGRADATION)), (Object)1), (Object)Pair.of((Object)StructurePoolElement.single((String)UGStructures.name("catacombs/tunnel5"), (Holder)processors.getOrThrow(CATACOMBS_DEGRADATION)), (Object)1), (Object)Pair.of((Object)StructurePoolElement.single((String)UGStructures.name("catacombs/tunnel6"), (Holder)processors.getOrThrow(CATACOMBS_DEGRADATION)), (Object)1), (Object)Pair.of((Object)StructurePoolElement.single((String)UGStructures.name("catacombs/tunnel7"), (Holder)processors.getOrThrow(CATACOMBS_DEGRADATION)), (Object)1), (Object)Pair.of((Object)StructurePoolElement.single((String)UGStructures.name("catacombs/tunnel_altar"), (Holder)processors.getOrThrow(CATACOMBS_DEGRADATION)), (Object)1), (Object)Pair.of((Object)StructurePoolElement.single((String)UGStructures.name("catacombs/tunnel_altar2"), (Holder)processors.getOrThrow(CATACOMBS_DEGRADATION)), (Object)1), (Object)Pair.of((Object)StructurePoolElement.single((String)UGStructures.name("catacombs/tunnel_altar_shiverstone"), (Holder)processors.getOrThrow(CATACOMBS_DEGRADATION)), (Object)1), (Object)Pair.of((Object)StructurePoolElement.single((String)UGStructures.name("catacombs/tunnel_bend_altar"), (Holder)processors.getOrThrow(CATACOMBS_DEGRADATION)), (Object)1), (Object)Pair.of((Object)StructurePoolElement.single((String)UGStructures.name("catacombs/tunnel_bend_candle_grass"), (Holder)processors.getOrThrow(CATACOMBS_DEGRADATION)), (Object)1), (Object[])new Pair[]{Pair.of((Object)StructurePoolElement.single((String)UGStructures.name("catacombs/tunnel_bend_dirt"), (Holder)processors.getOrThrow(CATACOMBS_DEGRADATION)), (Object)1), Pair.of((Object)StructurePoolElement.single((String)UGStructures.name("catacombs/tunnel_bend_grass_bars"), (Holder)processors.getOrThrow(CATACOMBS_DEGRADATION)), (Object)1), Pair.of((Object)StructurePoolElement.single((String)UGStructures.name("catacombs/tunnel_bend_water"), (Holder)processors.getOrThrow(CATACOMBS_DEGRADATION)), (Object)1), Pair.of((Object)StructurePoolElement.single((String)UGStructures.name("catacombs/tunnel_candle"), (Holder)processors.getOrThrow(CATACOMBS_DEGRADATION)), (Object)1), Pair.of((Object)StructurePoolElement.single((String)UGStructures.name("catacombs/tunnel_candle_dirt"), (Holder)processors.getOrThrow(CATACOMBS_DEGRADATION)), (Object)1), Pair.of((Object)StructurePoolElement.single((String)UGStructures.name("catacombs/tunnel_chiseled"), (Holder)processors.getOrThrow(CATACOMBS_DEGRADATION)), (Object)1), Pair.of((Object)StructurePoolElement.single((String)UGStructures.name("catacombs/tunnel_cloggrum"), (Holder)processors.getOrThrow(CATACOMBS_DEGRADATION)), (Object)1), Pair.of((Object)StructurePoolElement.single((String)UGStructures.name("catacombs/tunnel_dirt"), (Holder)processors.getOrThrow(CATACOMBS_DEGRADATION)), (Object)1), Pair.of((Object)StructurePoolElement.single((String)UGStructures.name("catacombs/tunnel_grass"), (Holder)processors.getOrThrow(CATACOMBS_DEGRADATION)), (Object)1), Pair.of((Object)StructurePoolElement.single((String)UGStructures.name("catacombs/tunnel_grass_dirt"), (Holder)processors.getOrThrow(CATACOMBS_DEGRADATION)), (Object)1), Pair.of((Object)StructurePoolElement.single((String)UGStructures.name("catacombs/tunnel_grass_pillars"), (Holder)processors.getOrThrow(CATACOMBS_DEGRADATION)), (Object)1), Pair.of((Object)StructurePoolElement.single((String)UGStructures.name("catacombs/tunnel_hidden"), (Holder)processors.getOrThrow(CATACOMBS_DEGRADATION)), (Object)1), Pair.of((Object)StructurePoolElement.single((String)UGStructures.name("catacombs/tunnel_morgue1"), (Holder)processors.getOrThrow(CATACOMBS_DEGRADATION)), (Object)1), Pair.of((Object)StructurePoolElement.single((String)UGStructures.name("catacombs/tunnel_morgue2"), (Holder)processors.getOrThrow(CATACOMBS_DEGRADATION)), (Object)1), Pair.of((Object)StructurePoolElement.single((String)UGStructures.name("catacombs/tunnel_rock"), (Holder)processors.getOrThrow(CATACOMBS_DEGRADATION)), (Object)1), Pair.of((Object)StructurePoolElement.single((String)UGStructures.name("catacombs/altar"), (Holder)processors.getOrThrow(CATACOMBS_DEGRADATION)), (Object)1), Pair.of((Object)StructurePoolElement.single((String)UGStructures.name("catacombs/altar_pool"), (Holder)processors.getOrThrow(CATACOMBS_DEGRADATION)), (Object)1), Pair.of((Object)StructurePoolElement.single((String)UGStructures.name("catacombs/room1"), (Holder)processors.getOrThrow(CATACOMBS_DEGRADATION)), (Object)1), Pair.of((Object)StructurePoolElement.single((String)UGStructures.name("catacombs/room2"), (Holder)processors.getOrThrow(CATACOMBS_DEGRADATION)), (Object)1), Pair.of((Object)StructurePoolElement.single((String)UGStructures.name("catacombs/room3"), (Holder)processors.getOrThrow(CATACOMBS_DEGRADATION)), (Object)1), Pair.of((Object)StructurePoolElement.single((String)UGStructures.name("catacombs/room4"), (Holder)processors.getOrThrow(CATACOMBS_DEGRADATION)), (Object)1), Pair.of((Object)StructurePoolElement.single((String)UGStructures.name("catacombs/room5"), (Holder)processors.getOrThrow(CATACOMBS_DEGRADATION)), (Object)1), Pair.of((Object)StructurePoolElement.single((String)UGStructures.name("catacombs/3way_candle"), (Holder)processors.getOrThrow(CATACOMBS_DEGRADATION)), (Object)1), Pair.of((Object)StructurePoolElement.single((String)UGStructures.name("catacombs/3way_candle_grass"), (Holder)processors.getOrThrow(CATACOMBS_DEGRADATION)), (Object)1), Pair.of((Object)StructurePoolElement.single((String)UGStructures.name("catacombs/3way_chiseled"), (Holder)processors.getOrThrow(CATACOMBS_DEGRADATION)), (Object)1), Pair.of((Object)StructurePoolElement.single((String)UGStructures.name("catacombs/3way_cloggrum"), (Holder)processors.getOrThrow(CATACOMBS_DEGRADATION)), (Object)1), Pair.of((Object)StructurePoolElement.single((String)UGStructures.name("catacombs/3way_dirt"), (Holder)processors.getOrThrow(CATACOMBS_DEGRADATION)), (Object)1), Pair.of((Object)StructurePoolElement.single((String)UGStructures.name("catacombs/3way_morgue"), (Holder)processors.getOrThrow(CATACOMBS_DEGRADATION)), (Object)1), Pair.of((Object)StructurePoolElement.single((String)UGStructures.name("catacombs/big3way_intersection"), (Holder)processors.getOrThrow(CATACOMBS_DEGRADATION)), (Object)1), Pair.of((Object)StructurePoolElement.single((String)UGStructures.name("catacombs/big3way_intersection_grass"), (Holder)processors.getOrThrow(CATACOMBS_DEGRADATION)), (Object)1), Pair.of((Object)StructurePoolElement.single((String)UGStructures.name("catacombs/big_bend_morgue"), (Holder)processors.getOrThrow(CATACOMBS_DEGRADATION)), (Object)1), Pair.of((Object)StructurePoolElement.single((String)UGStructures.name("catacombs/4way_arches"), (Holder)processors.getOrThrow(CATACOMBS_DEGRADATION)), (Object)1), Pair.of((Object)StructurePoolElement.single((String)UGStructures.name("catacombs/4way_arches2"), (Holder)processors.getOrThrow(CATACOMBS_DEGRADATION)), (Object)1), Pair.of((Object)StructurePoolElement.single((String)UGStructures.name("catacombs/4way_arches3"), (Holder)processors.getOrThrow(CATACOMBS_DEGRADATION)), (Object)1), Pair.of((Object)StructurePoolElement.single((String)UGStructures.name("catacombs/4way_cross"), (Holder)processors.getOrThrow(CATACOMBS_DEGRADATION)), (Object)1), Pair.of((Object)StructurePoolElement.single((String)UGStructures.name("catacombs/4way_smog_vent"), (Holder)processors.getOrThrow(CATACOMBS_DEGRADATION)), (Object)1), Pair.of((Object)StructurePoolElement.single((String)UGStructures.name("catacombs/intersection_altar"), (Holder)processors.getOrThrow(CATACOMBS_DEGRADATION)), (Object)1), Pair.of((Object)StructurePoolElement.single((String)UGStructures.name("catacombs/intersection_dirt"), (Holder)processors.getOrThrow(CATACOMBS_DEGRADATION)), (Object)1), Pair.of((Object)StructurePoolElement.single((String)UGStructures.name("catacombs/intersection_grass_pillars"), (Holder)processors.getOrThrow(CATACOMBS_DEGRADATION)), (Object)1), Pair.of((Object)StructurePoolElement.single((String)UGStructures.name("catacombs/tunnel_guardian"), (Holder)processors.getOrThrow(CATACOMBS_DEGRADATION)), (Object)1)}), StructureTemplatePool.Projection.RIGID));
        context.register(CATACOMBS_TUNNEL_FALLBACK, (Object)new StructureTemplatePool((Holder)emptyPool, (List)ImmutableList.of((Object)Pair.of((Object)StructurePoolElement.single((String)UGStructures.name("catacombs/tunnel_dead_end"), (Holder)processors.getOrThrow(CATACOMBS_DEGRADATION)), (Object)1)), StructureTemplatePool.Projection.RIGID));
        context.register(CATACOMBS_WAY, (Object)new StructureTemplatePool((Holder)emptyPool, (List)ImmutableList.of((Object)Pair.of((Object)StructurePoolElement.single((String)UGStructures.name("catacombs/4way"), (Holder)processors.getOrThrow(CATACOMBS_DEGRADATION)), (Object)1), (Object)Pair.of((Object)StructurePoolElement.single((String)UGStructures.name("catacombs/3way"), (Holder)processors.getOrThrow(CATACOMBS_DEGRADATION)), (Object)1), (Object)Pair.of((Object)StructurePoolElement.single((String)UGStructures.name("catacombs/2way"), (Holder)processors.getOrThrow(CATACOMBS_DEGRADATION)), (Object)1), (Object)Pair.of((Object)StructurePoolElement.single((String)UGStructures.name("catacombs/1way"), (Holder)processors.getOrThrow(CATACOMBS_DEGRADATION)), (Object)1)), StructureTemplatePool.Projection.RIGID));
        context.register(FORGOTTEN_VESTIGE_POOL, (Object)new StructureTemplatePool((Holder)emptyPool, (List)ImmutableList.of((Object)Pair.of((Object)StructurePoolElement.single((String)UGStructures.name("forgotten_vestige/depthrock/arch_1"), (Holder)processors.getOrThrow(FORGOTTEN_VESTIGE_DEGRADATION)), (Object)1), (Object)Pair.of((Object)StructurePoolElement.single((String)UGStructures.name("forgotten_vestige/depthrock/arch_2"), (Holder)processors.getOrThrow(FORGOTTEN_VESTIGE_DEGRADATION)), (Object)1), (Object)Pair.of((Object)StructurePoolElement.single((String)UGStructures.name("forgotten_vestige/depthrock/arch_3"), (Holder)processors.getOrThrow(FORGOTTEN_VESTIGE_DEGRADATION)), (Object)1), (Object)Pair.of((Object)StructurePoolElement.single((String)UGStructures.name("forgotten_vestige/depthrock/arch_4"), (Holder)processors.getOrThrow(FORGOTTEN_VESTIGE_DEGRADATION)), (Object)1), (Object)Pair.of((Object)StructurePoolElement.single((String)UGStructures.name("forgotten_vestige/depthrock/arch_5"), (Holder)processors.getOrThrow(FORGOTTEN_VESTIGE_DEGRADATION)), (Object)1), (Object)Pair.of((Object)StructurePoolElement.single((String)UGStructures.name("forgotten_vestige/depthrock/arch_6"), (Holder)processors.getOrThrow(FORGOTTEN_VESTIGE_DEGRADATION)), (Object)1), (Object)Pair.of((Object)StructurePoolElement.single((String)UGStructures.name("forgotten_vestige/depthrock/face_1"), (Holder)processors.getOrThrow(FORGOTTEN_VESTIGE_DEGRADATION)), (Object)1), (Object)Pair.of((Object)StructurePoolElement.single((String)UGStructures.name("forgotten_vestige/depthrock/face_2"), (Holder)processors.getOrThrow(FORGOTTEN_VESTIGE_DEGRADATION)), (Object)1), (Object)Pair.of((Object)StructurePoolElement.single((String)UGStructures.name("forgotten_vestige/depthrock/face_3"), (Holder)processors.getOrThrow(FORGOTTEN_VESTIGE_DEGRADATION)), (Object)1), (Object)Pair.of((Object)StructurePoolElement.single((String)UGStructures.name("forgotten_vestige/depthrock/house_1"), (Holder)processors.getOrThrow(FORGOTTEN_VESTIGE_DEGRADATION)), (Object)1), (Object)Pair.of((Object)StructurePoolElement.single((String)UGStructures.name("forgotten_vestige/depthrock/house_2"), (Holder)processors.getOrThrow(FORGOTTEN_VESTIGE_DEGRADATION)), (Object)1), (Object)Pair.of((Object)StructurePoolElement.single((String)UGStructures.name("forgotten_vestige/depthrock/house_3"), (Holder)processors.getOrThrow(FORGOTTEN_VESTIGE_DEGRADATION)), (Object)1), (Object[])new Pair[]{Pair.of((Object)StructurePoolElement.single((String)UGStructures.name("forgotten_vestige/depthrock/house_4"), (Holder)processors.getOrThrow(FORGOTTEN_VESTIGE_DEGRADATION)), (Object)1), Pair.of((Object)StructurePoolElement.single((String)UGStructures.name("forgotten_vestige/depthrock/house_5"), (Holder)processors.getOrThrow(FORGOTTEN_VESTIGE_DEGRADATION)), (Object)1), Pair.of((Object)StructurePoolElement.single((String)UGStructures.name("forgotten_vestige/depthrock/house_6"), (Holder)processors.getOrThrow(FORGOTTEN_VESTIGE_DEGRADATION)), (Object)1), Pair.of((Object)StructurePoolElement.single((String)UGStructures.name("forgotten_vestige/shiverstone/arch_1"), (Holder)processors.getOrThrow(FORGOTTEN_VESTIGE_DEGRADATION)), (Object)1), Pair.of((Object)StructurePoolElement.single((String)UGStructures.name("forgotten_vestige/shiverstone/arch_2"), (Holder)processors.getOrThrow(FORGOTTEN_VESTIGE_DEGRADATION)), (Object)1), Pair.of((Object)StructurePoolElement.single((String)UGStructures.name("forgotten_vestige/shiverstone/arch_3"), (Holder)processors.getOrThrow(FORGOTTEN_VESTIGE_DEGRADATION)), (Object)1), Pair.of((Object)StructurePoolElement.single((String)UGStructures.name("forgotten_vestige/shiverstone/arch_4"), (Holder)processors.getOrThrow(FORGOTTEN_VESTIGE_DEGRADATION)), (Object)1), Pair.of((Object)StructurePoolElement.single((String)UGStructures.name("forgotten_vestige/shiverstone/arch_5"), (Holder)processors.getOrThrow(FORGOTTEN_VESTIGE_DEGRADATION)), (Object)1), Pair.of((Object)StructurePoolElement.single((String)UGStructures.name("forgotten_vestige/shiverstone/arch_6"), (Holder)processors.getOrThrow(FORGOTTEN_VESTIGE_DEGRADATION)), (Object)1)}), StructureTemplatePool.Projection.RIGID));
    }

    public static void bootstrapProcessors(BootstrapContext<StructureProcessorList> context) {
        context.register(CATACOMBS_DEGRADATION, (Object)new StructureProcessorList(List.of(new RuleProcessor(List.of(new ProcessorRule((RuleTest)new RandomBlockMatchTest((Block)UGBlocks.DEPTHROCK_BRICKS.get(), 0.5f), (RuleTest)AlwaysTrueTest.INSTANCE, ((Block)UGBlocks.CRACKED_DEPTHROCK_BRICKS.get()).defaultBlockState()))))));
        context.register(FORGOTTEN_VESTIGE_DEGRADATION, (Object)new StructureProcessorList(List.of(new RuleProcessor(List.of(new ProcessorRule((RuleTest)new RandomBlockMatchTest((Block)UGBlocks.DEPTHROCK_BRICKS.get(), 0.25f), (RuleTest)AlwaysTrueTest.INSTANCE, ((Block)UGBlocks.CRACKED_DEPTHROCK_BRICKS.get()).defaultBlockState()), new ProcessorRule((RuleTest)new RandomBlockMatchTest((Block)UGBlocks.SHIVERSTONE_BRICKS.get(), 0.25f), (RuleTest)AlwaysTrueTest.INSTANCE, ((Block)UGBlocks.CRACKED_SHIVERSTONE_BRICKS.get()).defaultBlockState()), new ProcessorRule((RuleTest)new RandomBlockMatchTest((Block)UGBlocks.CLOGGRUM_BLOCK.get(), 0.5f), (RuleTest)AlwaysTrueTest.INSTANCE, ((Block)UGBlocks.RAW_CLOGGRUM_BLOCK.get()).defaultBlockState()))))));
    }

    private static String name(String name) {
        return ResourceLocation.fromNamespaceAndPath((String)"undergarden", (String)name).toString();
    }
}

