/*
 * Decompiled with CFR 0.152.
 */
package quek.undergarden.world.gen.feature;

import com.mojang.serialization.Codec;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.GrowingPlantHeadBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.configurations.NoneFeatureConfiguration;
import quek.undergarden.block.Droopvine;
import quek.undergarden.block.DroopvineBlock;
import quek.undergarden.block.DroopvinePlantBlock;
import quek.undergarden.registry.UGBlocks;
import quek.undergarden.registry.UGTags;

public class DroopvineFeature
extends Feature<NoneFeatureConfiguration> {
    public DroopvineFeature(Codec<NoneFeatureConfiguration> codec) {
        super(codec);
    }

    public boolean place(FeaturePlaceContext<NoneFeatureConfiguration> context) {
        WorldGenLevel level = context.level();
        BlockPos pos = context.origin();
        RandomSource random = context.random();
        if (!level.isEmptyBlock(pos)) {
            return false;
        }
        BlockState blockstate = level.getBlockState(pos.above());
        if (!blockstate.is(UGTags.Blocks.BASE_STONE_UNDERGARDEN)) {
            return false;
        }
        this.placeRoofDroopvine((LevelAccessor)level, random, pos);
        return true;
    }

    private void placeRoofDroopvine(LevelAccessor level, RandomSource random, BlockPos pos) {
        BlockPos.MutableBlockPos posMutable = new BlockPos.MutableBlockPos();
        for (int i = 0; i < 100; ++i) {
            BlockState blockstate;
            posMutable.setWithOffset((Vec3i)pos, random.nextInt(8) - random.nextInt(8), random.nextInt(2) - random.nextInt(7), random.nextInt(8) - random.nextInt(8));
            if (!level.isEmptyBlock((BlockPos)posMutable) || !(blockstate = level.getBlockState(posMutable.above())).is(UGTags.Blocks.BASE_STONE_UNDERGARDEN)) continue;
            int length = Mth.nextInt((RandomSource)random, (int)1, (int)8);
            if (random.nextInt(6) == 0) {
                length *= 2;
            }
            if (random.nextInt(5) == 0) {
                length = 1;
            }
            DroopvineFeature.placeDroopvineColumn(level, random, posMutable, length, 17, 25);
        }
    }

    private static void placeDroopvineColumn(LevelAccessor level, RandomSource random, BlockPos.MutableBlockPos posMutable, int length, int min, int max) {
        for (int i = 0; i <= length; ++i) {
            if (level.isEmptyBlock((BlockPos)posMutable)) {
                if (i == length || !level.isEmptyBlock(posMutable.below())) {
                    level.setBlock((BlockPos)posMutable, (BlockState)((BlockState)((DroopvineBlock)UGBlocks.DROOPVINE.get()).defaultBlockState().setValue((Property)Droopvine.GLOWY, (Comparable)Boolean.valueOf(level.getRandom().nextBoolean()))).setValue((Property)GrowingPlantHeadBlock.AGE, (Comparable)Integer.valueOf(Mth.nextInt((RandomSource)random, (int)min, (int)max))), 2);
                    break;
                }
                level.setBlock((BlockPos)posMutable, (BlockState)((DroopvinePlantBlock)UGBlocks.DROOPVINE_PLANT.get()).defaultBlockState().setValue((Property)Droopvine.GLOWY, (Comparable)Boolean.valueOf(level.getRandom().nextBoolean())), 2);
            }
            posMutable.move(Direction.DOWN);
        }
    }
}

