/*
 * Decompiled with CFR 0.152.
 */
package com.illusivesoulworks.elytraslot;

import com.illusivesoulworks.caelus.api.RenderCapeEvent;
import com.illusivesoulworks.elytraslot.ElytraSlotCommonMod;
import com.illusivesoulworks.elytraslot.client.ElytraSlotLayer;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.client.resources.PlayerSkin;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.neoforge.client.event.EntityRenderersEvent;
import net.neoforged.neoforge.common.NeoForge;

public class ElytraSlotNeoForgeClientMod {
    public static void setup(IEventBus eventBus) {
        eventBus.addListener(ElytraSlotNeoForgeClientMod::addLayers);
        NeoForge.EVENT_BUS.addListener(ElytraSlotNeoForgeClientMod::renderCape);
    }

    private static void addLayers(EntityRenderersEvent.AddLayers evt) {
        ElytraSlotNeoForgeClientMod.addEntityLayer(evt, EntityType.ARMOR_STAND);
        for (PlayerSkin.Model skin : evt.getSkins()) {
            ElytraSlotNeoForgeClientMod.addPlayerLayer(evt, skin);
        }
    }

    private static void addPlayerLayer(EntityRenderersEvent.AddLayers evt, PlayerSkin.Model skin) {
        boolean slim;
        EntityRenderer renderer = evt.getSkin(skin);
        boolean bl = slim = skin == PlayerSkin.Model.SLIM;
        if (renderer instanceof LivingEntityRenderer) {
            LivingEntityRenderer livingRenderer = (LivingEntityRenderer)renderer;
            livingRenderer.addLayer(new ElytraSlotLayer(livingRenderer, evt.getEntityModels()));
        }
    }

    private static <T extends LivingEntity, M extends HumanoidModel<T>, R extends LivingEntityRenderer<T, M>> void addEntityLayer(EntityRenderersEvent.AddLayers evt, EntityType<? extends T> entityType) {
        LivingEntityRenderer renderer = (LivingEntityRenderer)evt.getRenderer(entityType);
        if (renderer != null) {
            renderer.addLayer(new ElytraSlotLayer(renderer, evt.getEntityModels()));
        }
    }

    private static void renderCape(RenderCapeEvent evt) {
        if (ElytraSlotCommonMod.isEquipped((LivingEntity)evt.getEntity())) {
            evt.setCanceled(true);
        }
    }
}

