/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.boss.enderdragon;

import com.google.common.collect.Lists;
import com.mojang.logging.LogUtils;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.game.ClientboundAddEntityPacket;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.tags.TagKey;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageType;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.ExperienceOrb;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.entity.boss.EnderDragonPart;
import net.minecraft.world.entity.boss.enderdragon.EndCrystal;
import net.minecraft.world.entity.boss.enderdragon.phases.DragonPhaseInstance;
import net.minecraft.world.entity.boss.enderdragon.phases.EnderDragonPhase;
import net.minecraft.world.entity.boss.enderdragon.phases.EnderDragonPhaseManager;
import net.minecraft.world.entity.monster.Enemy;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.dimension.end.EndDragonFight;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.feature.EndPodiumFeature;
import net.minecraft.world.level.pathfinder.BinaryHeap;
import net.minecraft.world.level.pathfinder.Node;
import net.minecraft.world.level.pathfinder.Path;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.common.CommonHooks;
import net.neoforged.neoforge.entity.PartEntity;
import net.neoforged.neoforge.event.EventHooks;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;

public class EnderDragon
extends Mob
implements Enemy {
    private static final Logger LOGGER = LogUtils.getLogger();
    public static final EntityDataAccessor<Integer> DATA_PHASE = SynchedEntityData.defineId(EnderDragon.class, EntityDataSerializers.INT);
    private static final TargetingConditions CRYSTAL_DESTROY_TARGETING = TargetingConditions.forCombat().range(64.0);
    private static final int GROWL_INTERVAL_MIN = 200;
    private static final int GROWL_INTERVAL_MAX = 400;
    private static final float SITTING_ALLOWED_DAMAGE_PERCENTAGE = 0.25f;
    private static final String DRAGON_DEATH_TIME_KEY = "DragonDeathTime";
    private static final String DRAGON_PHASE_KEY = "DragonPhase";
    public final double[][] positions = new double[64][3];
    public int posPointer = -1;
    private final EnderDragonPart[] subEntities;
    public final EnderDragonPart head;
    private final EnderDragonPart neck;
    private final EnderDragonPart body;
    private final EnderDragonPart tail1;
    private final EnderDragonPart tail2;
    private final EnderDragonPart tail3;
    private final EnderDragonPart wing1;
    private final EnderDragonPart wing2;
    public float oFlapTime;
    public float flapTime;
    public boolean inWall;
    public int dragonDeathTime;
    public float yRotA;
    @javax.annotation.Nullable
    public EndCrystal nearestCrystal;
    @javax.annotation.Nullable
    private EndDragonFight dragonFight;
    private BlockPos fightOrigin = BlockPos.ZERO;
    private final EnderDragonPhaseManager phaseManager;
    private int growlTime = 100;
    private float sittingDamageReceived;
    private final Node[] nodes = new Node[24];
    private final int[] nodeAdjacency = new int[24];
    private final BinaryHeap openSet = new BinaryHeap();
    @Nullable
    private Player unlimitedLastHurtByPlayer = null;

    public EnderDragon(EntityType<? extends EnderDragon> p_31096_, Level p_31097_) {
        super((EntityType<? extends Mob>)EntityType.ENDER_DRAGON, p_31097_);
        this.head = new EnderDragonPart(this, "head", 1.0f, 1.0f);
        this.neck = new EnderDragonPart(this, "neck", 3.0f, 3.0f);
        this.body = new EnderDragonPart(this, "body", 5.0f, 3.0f);
        this.tail1 = new EnderDragonPart(this, "tail", 2.0f, 2.0f);
        this.tail2 = new EnderDragonPart(this, "tail", 2.0f, 2.0f);
        this.tail3 = new EnderDragonPart(this, "tail", 2.0f, 2.0f);
        this.wing1 = new EnderDragonPart(this, "wing", 4.0f, 2.0f);
        this.wing2 = new EnderDragonPart(this, "wing", 4.0f, 2.0f);
        this.subEntities = new EnderDragonPart[]{this.head, this.neck, this.body, this.tail1, this.tail2, this.tail3, this.wing1, this.wing2};
        this.setHealth(this.getMaxHealth());
        this.noPhysics = true;
        this.noCulling = true;
        this.phaseManager = new EnderDragonPhaseManager(this);
        this.setId(ENTITY_COUNTER.getAndAdd(this.subEntities.length + 1) + 1);
    }

    @Override
    public void setId(int id) {
        super.setId(id);
        for (int i = 0; i < this.subEntities.length; ++i) {
            this.subEntities[i].setId(id + i + 1);
        }
    }

    public void setDragonFight(EndDragonFight p_287736_) {
        this.dragonFight = p_287736_;
    }

    public void setFightOrigin(BlockPos p_287665_) {
        this.fightOrigin = p_287665_;
    }

    public BlockPos getFightOrigin() {
        return this.fightOrigin;
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.createMobAttributes().add(Attributes.MAX_HEALTH, 200.0);
    }

    @Override
    public boolean isFlapping() {
        float f = Mth.cos((float)(this.flapTime * ((float)Math.PI * 2)));
        float f1 = Mth.cos((float)(this.oFlapTime * ((float)Math.PI * 2)));
        return f1 <= -0.3f && f >= -0.3f;
    }

    @Override
    public void onFlap() {
        if (this.level().isClientSide && !this.isSilent()) {
            this.level().playLocalSound(this.getX(), this.getY(), this.getZ(), SoundEvents.ENDER_DRAGON_FLAP, this.getSoundSource(), 5.0f, 0.8f + this.random.nextFloat() * 0.3f, false);
        }
    }

    @Override
    protected void defineSynchedData(SynchedEntityData.Builder p_326491_) {
        super.defineSynchedData(p_326491_);
        p_326491_.define(DATA_PHASE, EnderDragonPhase.HOVERING.getId());
    }

    public double[] getLatencyPos(int p_31102_, float p_31103_) {
        if (this.isDeadOrDying()) {
            p_31103_ = 0.0f;
        }
        p_31103_ = 1.0f - p_31103_;
        int i = this.posPointer - p_31102_ & 0x3F;
        int j = this.posPointer - p_31102_ - 1 & 0x3F;
        double[] adouble = new double[3];
        double d0 = this.positions[i][0];
        double d1 = Mth.wrapDegrees((double)(this.positions[j][0] - d0));
        adouble[0] = d0 + d1 * (double)p_31103_;
        d0 = this.positions[i][1];
        d1 = this.positions[j][1] - d0;
        adouble[1] = d0 + d1 * (double)p_31103_;
        adouble[2] = Mth.lerp((double)p_31103_, (double)this.positions[i][2], (double)this.positions[j][2]);
        return adouble;
    }

    @Override
    public void aiStep() {
        ServerLevel serverlevel;
        EndDragonFight enddragonfight;
        Level level;
        if (this.lastHurtByPlayer != null) {
            this.unlimitedLastHurtByPlayer = this.lastHurtByPlayer;
        }
        if (this.unlimitedLastHurtByPlayer != null && this.unlimitedLastHurtByPlayer.isRemoved()) {
            this.unlimitedLastHurtByPlayer = null;
        }
        this.processFlappingMovement();
        if (this.level().isClientSide) {
            this.setHealth(this.getHealth());
            if (!this.isSilent() && !this.phaseManager.getCurrentPhase().isSitting() && --this.growlTime < 0) {
                this.level().playLocalSound(this.getX(), this.getY(), this.getZ(), SoundEvents.ENDER_DRAGON_GROWL, this.getSoundSource(), 2.5f, 0.8f + this.random.nextFloat() * 0.3f, false);
                this.growlTime = 200 + this.random.nextInt(200);
            }
        }
        if (this.dragonFight == null && (level = this.level()) instanceof ServerLevel && (enddragonfight = (serverlevel = (ServerLevel)level).getDragonFight()) != null && this.getUUID().equals(enddragonfight.getDragonUUID())) {
            this.dragonFight = enddragonfight;
        }
        this.oFlapTime = this.flapTime;
        if (this.isDeadOrDying()) {
            float f7 = (this.random.nextFloat() - 0.5f) * 8.0f;
            float f9 = (this.random.nextFloat() - 0.5f) * 4.0f;
            float f10 = (this.random.nextFloat() - 0.5f) * 8.0f;
            this.level().addParticle((ParticleOptions)ParticleTypes.EXPLOSION, this.getX() + (double)f7, this.getY() + 2.0 + (double)f9, this.getZ() + (double)f10, 0.0, 0.0, 0.0);
        } else {
            this.checkCrystals();
            Vec3 vec34 = this.getDeltaMovement();
            float f8 = 0.2f / ((float)vec34.horizontalDistance() * 10.0f + 1.0f);
            this.flapTime = this.phaseManager.getCurrentPhase().isSitting() ? (this.flapTime += 0.1f) : (this.inWall ? (this.flapTime += f8 * 0.5f) : (this.flapTime += (f8 *= (float)Math.pow(2.0, vec34.y))));
            this.setYRot(Mth.wrapDegrees((float)this.getYRot()));
            if (this.isNoAi()) {
                this.flapTime = 0.5f;
            } else {
                if (this.posPointer < 0) {
                    for (int i = 0; i < this.positions.length; ++i) {
                        this.positions[i][0] = this.getYRot();
                        this.positions[i][1] = this.getY();
                    }
                }
                if (++this.posPointer == this.positions.length) {
                    this.posPointer = 0;
                }
                this.positions[this.posPointer][0] = this.getYRot();
                this.positions[this.posPointer][1] = this.getY();
                if (this.level().isClientSide) {
                    if (this.lerpSteps > 0) {
                        this.lerpPositionAndRotationStep(this.lerpSteps, this.lerpX, this.lerpY, this.lerpZ, this.lerpYRot, this.lerpXRot);
                        --this.lerpSteps;
                    }
                    this.phaseManager.getCurrentPhase().doClientTick();
                } else {
                    Vec3 vec3;
                    DragonPhaseInstance dragonphaseinstance = this.phaseManager.getCurrentPhase();
                    dragonphaseinstance.doServerTick();
                    if (this.phaseManager.getCurrentPhase() != dragonphaseinstance) {
                        dragonphaseinstance = this.phaseManager.getCurrentPhase();
                        dragonphaseinstance.doServerTick();
                    }
                    if ((vec3 = dragonphaseinstance.getFlyTargetLocation()) != null) {
                        double d0 = vec3.x - this.getX();
                        double d1 = vec3.y - this.getY();
                        double d2 = vec3.z - this.getZ();
                        double d3 = d0 * d0 + d1 * d1 + d2 * d2;
                        float f3 = dragonphaseinstance.getFlySpeed();
                        double d4 = Math.sqrt(d0 * d0 + d2 * d2);
                        if (d4 > 0.0) {
                            d1 = Mth.clamp((double)(d1 / d4), (double)(-f3), (double)f3);
                        }
                        this.setDeltaMovement(this.getDeltaMovement().add(0.0, d1 * 0.01, 0.0));
                        this.setYRot(Mth.wrapDegrees((float)this.getYRot()));
                        Vec3 vec31 = vec3.subtract(this.getX(), this.getY(), this.getZ()).normalize();
                        Vec3 vec32 = new Vec3((double)Mth.sin((float)(this.getYRot() * ((float)Math.PI / 180))), this.getDeltaMovement().y, (double)(-Mth.cos((float)(this.getYRot() * ((float)Math.PI / 180))))).normalize();
                        float f4 = Math.max(((float)vec32.dot(vec31) + 0.5f) / 1.5f, 0.0f);
                        if (Math.abs(d0) > (double)1.0E-5f || Math.abs(d2) > (double)1.0E-5f) {
                            float f5 = Mth.clamp((float)Mth.wrapDegrees((float)(180.0f - (float)Mth.atan2((double)d0, (double)d2) * 57.295776f - this.getYRot())), (float)-50.0f, (float)50.0f);
                            this.yRotA *= 0.8f;
                            this.yRotA += f5 * dragonphaseinstance.getTurnSpeed();
                            this.setYRot(this.getYRot() + this.yRotA * 0.1f);
                        }
                        float f19 = (float)(2.0 / (d3 + 1.0));
                        float f6 = 0.06f;
                        this.moveRelative(0.06f * (f4 * f19 + (1.0f - f19)), new Vec3(0.0, 0.0, -1.0));
                        if (this.inWall) {
                            this.move(MoverType.SELF, this.getDeltaMovement().scale((double)0.8f));
                        } else {
                            this.move(MoverType.SELF, this.getDeltaMovement());
                        }
                        Vec3 vec33 = this.getDeltaMovement().normalize();
                        double d5 = 0.8 + 0.15 * (vec33.dot(vec32) + 1.0) / 2.0;
                        this.setDeltaMovement(this.getDeltaMovement().multiply(d5, (double)0.91f, d5));
                    }
                }
                this.yBodyRot = this.getYRot();
                Vec3[] avec3 = new Vec3[this.subEntities.length];
                for (int j = 0; j < this.subEntities.length; ++j) {
                    avec3[j] = new Vec3(this.subEntities[j].getX(), this.subEntities[j].getY(), this.subEntities[j].getZ());
                }
                float f11 = (float)(this.getLatencyPos(5, 1.0f)[1] - this.getLatencyPos(10, 1.0f)[1]) * 10.0f * ((float)Math.PI / 180);
                float f12 = Mth.cos((float)f11);
                float f = Mth.sin((float)f11);
                float f13 = this.getYRot() * ((float)Math.PI / 180);
                float f1 = Mth.sin((float)f13);
                float f14 = Mth.cos((float)f13);
                this.tickPart(this.body, f1 * 0.5f, 0.0, -f14 * 0.5f);
                this.tickPart(this.wing1, f14 * 4.5f, 2.0, f1 * 4.5f);
                this.tickPart(this.wing2, f14 * -4.5f, 2.0, f1 * -4.5f);
                Level d3 = this.level();
                if (d3 instanceof ServerLevel) {
                    ServerLevel serverlevel1 = (ServerLevel)d3;
                    if (this.hurtTime == 0) {
                        this.knockBack(serverlevel1, serverlevel1.getEntities(this, this.wing1.getBoundingBox().inflate(4.0, 2.0, 4.0).move(0.0, -2.0, 0.0), EntitySelector.NO_CREATIVE_OR_SPECTATOR));
                        this.knockBack(serverlevel1, serverlevel1.getEntities(this, this.wing2.getBoundingBox().inflate(4.0, 2.0, 4.0).move(0.0, -2.0, 0.0), EntitySelector.NO_CREATIVE_OR_SPECTATOR));
                        this.hurt(serverlevel1.getEntities(this, this.head.getBoundingBox().inflate(1.0), EntitySelector.NO_CREATIVE_OR_SPECTATOR));
                        this.hurt(serverlevel1.getEntities(this, this.neck.getBoundingBox().inflate(1.0), EntitySelector.NO_CREATIVE_OR_SPECTATOR));
                    }
                }
                float f15 = Mth.sin((float)(this.getYRot() * ((float)Math.PI / 180) - this.yRotA * 0.01f));
                float f16 = Mth.cos((float)(this.getYRot() * ((float)Math.PI / 180) - this.yRotA * 0.01f));
                float f2 = this.getHeadYOffset();
                this.tickPart(this.head, f15 * 6.5f * f12, f2 + f * 6.5f, -f16 * 6.5f * f12);
                this.tickPart(this.neck, f15 * 5.5f * f12, f2 + f * 5.5f, -f16 * 5.5f * f12);
                double[] adouble = this.getLatencyPos(5, 1.0f);
                for (int k = 0; k < 3; ++k) {
                    EnderDragonPart enderdragonpart = null;
                    if (k == 0) {
                        enderdragonpart = this.tail1;
                    }
                    if (k == 1) {
                        enderdragonpart = this.tail2;
                    }
                    if (k == 2) {
                        enderdragonpart = this.tail3;
                    }
                    double[] adouble1 = this.getLatencyPos(12 + k * 2, 1.0f);
                    float f17 = this.getYRot() * ((float)Math.PI / 180) + this.rotWrap(adouble1[0] - adouble[0]) * ((float)Math.PI / 180);
                    float f18 = Mth.sin((float)f17);
                    float f20 = Mth.cos((float)f17);
                    float f21 = 1.5f;
                    float f22 = (float)(k + 1) * 2.0f;
                    this.tickPart(enderdragonpart, -(f1 * 1.5f + f18 * f22) * f12, adouble1[1] - adouble[1] - (double)((f22 + 1.5f) * f) + 1.5, (f14 * 1.5f + f20 * f22) * f12);
                }
                if (!this.level().isClientSide) {
                    this.inWall = this.checkWalls(this.head.getBoundingBox()) | this.checkWalls(this.neck.getBoundingBox()) | this.checkWalls(this.body.getBoundingBox());
                    if (this.dragonFight != null) {
                        this.dragonFight.updateDragon(this);
                    }
                }
                for (int l = 0; l < this.subEntities.length; ++l) {
                    this.subEntities[l].xo = avec3[l].x;
                    this.subEntities[l].yo = avec3[l].y;
                    this.subEntities[l].zo = avec3[l].z;
                    this.subEntities[l].xOld = avec3[l].x;
                    this.subEntities[l].yOld = avec3[l].y;
                    this.subEntities[l].zOld = avec3[l].z;
                }
            }
        }
    }

    private void tickPart(EnderDragonPart p_31116_, double p_31117_, double p_31118_, double p_31119_) {
        p_31116_.setPos(this.getX() + p_31117_, this.getY() + p_31118_, this.getZ() + p_31119_);
    }

    private float getHeadYOffset() {
        if (this.phaseManager.getCurrentPhase().isSitting()) {
            return -1.0f;
        }
        double[] adouble = this.getLatencyPos(5, 1.0f);
        double[] adouble1 = this.getLatencyPos(0, 1.0f);
        return (float)(adouble[1] - adouble1[1]);
    }

    private void checkCrystals() {
        if (this.nearestCrystal != null) {
            if (this.nearestCrystal.isRemoved()) {
                this.nearestCrystal = null;
            } else if (this.tickCount % 10 == 0 && this.getHealth() < this.getMaxHealth()) {
                this.setHealth(this.getHealth() + 1.0f);
            }
        }
        if (this.random.nextInt(10) == 0) {
            List list = this.level().getEntitiesOfClass(EndCrystal.class, this.getBoundingBox().inflate(32.0));
            EndCrystal endcrystal = null;
            double d0 = Double.MAX_VALUE;
            for (EndCrystal endcrystal1 : list) {
                double d1 = endcrystal1.distanceToSqr((Entity)this);
                if (!(d1 < d0)) continue;
                d0 = d1;
                endcrystal = endcrystal1;
            }
            this.nearestCrystal = endcrystal;
        }
    }

    private void knockBack(ServerLevel p_345435_, List<Entity> p_31132_) {
        double d0 = (this.body.getBoundingBox().minX + this.body.getBoundingBox().maxX) / 2.0;
        double d1 = (this.body.getBoundingBox().minZ + this.body.getBoundingBox().maxZ) / 2.0;
        for (Entity entity : p_31132_) {
            if (!(entity instanceof LivingEntity)) continue;
            LivingEntity livingentity = (LivingEntity)entity;
            double d2 = entity.getX() - d0;
            double d3 = entity.getZ() - d1;
            double d4 = Math.max(d2 * d2 + d3 * d3, 0.1);
            entity.push(d2 / d4 * 4.0, 0.2f, d3 / d4 * 4.0);
            if (this.phaseManager.getCurrentPhase().isSitting() || livingentity.getLastHurtByMobTimestamp() >= entity.tickCount - 2) continue;
            DamageSource damagesource = this.damageSources().mobAttack((LivingEntity)this);
            entity.hurt(damagesource, 5.0f);
            EnchantmentHelper.doPostAttackEffects(p_345435_, entity, damagesource);
        }
    }

    private void hurt(List<Entity> p_31142_) {
        for (Entity entity : p_31142_) {
            if (!(entity instanceof LivingEntity)) continue;
            DamageSource damagesource = this.damageSources().mobAttack((LivingEntity)this);
            entity.hurt(damagesource, 10.0f);
            Level level = this.level();
            if (!(level instanceof ServerLevel)) continue;
            ServerLevel serverlevel = (ServerLevel)level;
            EnchantmentHelper.doPostAttackEffects(serverlevel, entity, damagesource);
        }
    }

    private float rotWrap(double p_31165_) {
        return (float)Mth.wrapDegrees((double)p_31165_);
    }

    private boolean checkWalls(AABB p_31140_) {
        int i = Mth.floor((double)p_31140_.minX);
        int j = Mth.floor((double)p_31140_.minY);
        int k = Mth.floor((double)p_31140_.minZ);
        int l = Mth.floor((double)p_31140_.maxX);
        int i1 = Mth.floor((double)p_31140_.maxY);
        int j1 = Mth.floor((double)p_31140_.maxZ);
        boolean flag = false;
        boolean flag1 = false;
        for (int k1 = i; k1 <= l; ++k1) {
            for (int l1 = j; l1 <= i1; ++l1) {
                for (int i2 = k; i2 <= j1; ++i2) {
                    BlockPos blockpos = new BlockPos(k1, l1, i2);
                    BlockState blockstate = this.level().getBlockState(blockpos);
                    if (blockstate.isAir() || blockstate.is(BlockTags.DRAGON_TRANSPARENT)) continue;
                    if (CommonHooks.canEntityDestroy((Level)this.level(), (BlockPos)blockpos, (LivingEntity)this) && !blockstate.is(BlockTags.DRAGON_IMMUNE)) {
                        flag1 = this.level().removeBlock(blockpos, false) || flag1;
                        continue;
                    }
                    flag = true;
                }
            }
        }
        if (flag1) {
            BlockPos blockpos1 = new BlockPos(i + this.random.nextInt(l - i + 1), j + this.random.nextInt(i1 - j + 1), k + this.random.nextInt(j1 - k + 1));
            this.level().levelEvent(2008, blockpos1, 0);
        }
        return flag;
    }

    public boolean hurt(EnderDragonPart p_31121_, DamageSource p_31122_, float p_31123_) {
        if (this.phaseManager.getCurrentPhase().getPhase() == EnderDragonPhase.DYING) {
            return false;
        }
        p_31123_ = this.phaseManager.getCurrentPhase().onHurt(p_31122_, p_31123_);
        if (p_31121_ != this.head) {
            p_31123_ = p_31123_ / 4.0f + Math.min(p_31123_, 1.0f);
        }
        if (p_31123_ < 0.01f) {
            return false;
        }
        if (p_31122_.getEntity() instanceof Player || p_31122_.is((TagKey<DamageType>)DamageTypeTags.ALWAYS_HURTS_ENDER_DRAGONS)) {
            float f = this.getHealth();
            this.reallyHurt(p_31122_, p_31123_);
            if (this.isDeadOrDying() && !this.phaseManager.getCurrentPhase().isSitting()) {
                this.setHealth(1.0f);
                this.phaseManager.setPhase(EnderDragonPhase.DYING);
            }
            if (this.phaseManager.getCurrentPhase().isSitting()) {
                this.sittingDamageReceived = this.sittingDamageReceived + f - this.getHealth();
                if (this.sittingDamageReceived > 0.25f * this.getMaxHealth()) {
                    this.sittingDamageReceived = 0.0f;
                    this.phaseManager.setPhase(EnderDragonPhase.TAKEOFF);
                }
            }
        }
        return true;
    }

    @Override
    public boolean hurt(DamageSource p_31113_, float p_31114_) {
        return !this.level().isClientSide ? this.hurt(this.body, p_31113_, p_31114_) : false;
    }

    protected boolean reallyHurt(DamageSource p_31162_, float p_31163_) {
        return super.hurt(p_31162_, p_31163_);
    }

    @Override
    public void kill() {
        this.remove(Entity.RemovalReason.KILLED);
        this.gameEvent(GameEvent.ENTITY_DIE);
        if (this.dragonFight != null) {
            this.dragonFight.updateDragon(this);
            this.dragonFight.setDragonKilled(this);
        }
    }

    @Override
    protected void tickDeath() {
        if (this.dragonFight != null) {
            this.dragonFight.updateDragon(this);
        }
        ++this.dragonDeathTime;
        if (this.dragonDeathTime >= 180 && this.dragonDeathTime <= 200) {
            float f = (this.random.nextFloat() - 0.5f) * 8.0f;
            float f1 = (this.random.nextFloat() - 0.5f) * 4.0f;
            float f2 = (this.random.nextFloat() - 0.5f) * 8.0f;
            this.level().addParticle((ParticleOptions)ParticleTypes.EXPLOSION_EMITTER, this.getX() + (double)f, this.getY() + 2.0 + (double)f1, this.getZ() + (double)f2, 0.0, 0.0, 0.0);
        }
        boolean flag = this.level().getGameRules().getBoolean(GameRules.RULE_DOMOBLOOT);
        int i = 500;
        if (this.dragonFight != null && !this.dragonFight.hasPreviouslyKilledDragon()) {
            i = 12000;
        }
        if (this.level() instanceof ServerLevel) {
            if (this.dragonDeathTime > 150 && this.dragonDeathTime % 5 == 0 && flag) {
                int award = EventHooks.getExperienceDrop((LivingEntity)this, (Player)this.unlimitedLastHurtByPlayer, (int)Mth.floor((float)((float)i * 0.08f)));
                ExperienceOrb.award((ServerLevel)this.level(), this.position(), award);
            }
            if (this.dragonDeathTime == 1 && !this.isSilent()) {
                this.level().globalLevelEvent(1028, this.blockPosition(), 0);
            }
        }
        this.move(MoverType.SELF, new Vec3(0.0, (double)0.1f, 0.0));
        if (this.dragonDeathTime == 200 && this.level() instanceof ServerLevel) {
            if (flag) {
                int award = EventHooks.getExperienceDrop((LivingEntity)this, (Player)this.unlimitedLastHurtByPlayer, (int)Mth.floor((float)((float)i * 0.2f)));
                ExperienceOrb.award((ServerLevel)this.level(), this.position(), award);
            }
            if (this.dragonFight != null) {
                this.dragonFight.setDragonKilled(this);
            }
            this.remove(Entity.RemovalReason.KILLED);
            this.gameEvent(GameEvent.ENTITY_DIE);
        }
    }

    public int findClosestNode() {
        if (this.nodes[0] == null) {
            for (int i = 0; i < 24; ++i) {
                int i1;
                int l;
                int j = 5;
                if (i < 12) {
                    l = Mth.floor((float)(60.0f * Mth.cos((float)(2.0f * ((float)(-Math.PI) + 0.2617994f * (float)i)))));
                    i1 = Mth.floor((float)(60.0f * Mth.sin((float)(2.0f * ((float)(-Math.PI) + 0.2617994f * (float)i)))));
                } else if (i < 20) {
                    int $$2 = i - 12;
                    l = Mth.floor((float)(40.0f * Mth.cos((float)(2.0f * ((float)(-Math.PI) + 0.3926991f * (float)$$2)))));
                    i1 = Mth.floor((float)(40.0f * Mth.sin((float)(2.0f * ((float)(-Math.PI) + 0.3926991f * (float)$$2)))));
                    j += 10;
                } else {
                    int k1 = i - 20;
                    l = Mth.floor((float)(20.0f * Mth.cos((float)(2.0f * ((float)(-Math.PI) + 0.7853982f * (float)k1)))));
                    i1 = Mth.floor((float)(20.0f * Mth.sin((float)(2.0f * ((float)(-Math.PI) + 0.7853982f * (float)k1)))));
                }
                int j1 = Math.max(this.level().getSeaLevel() + 10, this.level().getHeightmapPos(Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, new BlockPos(l, 0, i1)).getY() + j);
                this.nodes[i] = new Node(l, j1, i1);
            }
            this.nodeAdjacency[0] = 6146;
            this.nodeAdjacency[1] = 8197;
            this.nodeAdjacency[2] = 8202;
            this.nodeAdjacency[3] = 16404;
            this.nodeAdjacency[4] = 32808;
            this.nodeAdjacency[5] = 32848;
            this.nodeAdjacency[6] = 65696;
            this.nodeAdjacency[7] = 131392;
            this.nodeAdjacency[8] = 131712;
            this.nodeAdjacency[9] = 263424;
            this.nodeAdjacency[10] = 526848;
            this.nodeAdjacency[11] = 525313;
            this.nodeAdjacency[12] = 1581057;
            this.nodeAdjacency[13] = 3166214;
            this.nodeAdjacency[14] = 2138120;
            this.nodeAdjacency[15] = 6373424;
            this.nodeAdjacency[16] = 4358208;
            this.nodeAdjacency[17] = 12910976;
            this.nodeAdjacency[18] = 9044480;
            this.nodeAdjacency[19] = 9706496;
            this.nodeAdjacency[20] = 15216640;
            this.nodeAdjacency[21] = 0xD0E000;
            this.nodeAdjacency[22] = 11763712;
            this.nodeAdjacency[23] = 0x7E0000;
        }
        return this.findClosestNode(this.getX(), this.getY(), this.getZ());
    }

    public int findClosestNode(double p_31171_, double p_31172_, double p_31173_) {
        float f = 10000.0f;
        int i = 0;
        Node node = new Node(Mth.floor((double)p_31171_), Mth.floor((double)p_31172_), Mth.floor((double)p_31173_));
        int j = 0;
        if (this.dragonFight == null || this.dragonFight.getCrystalsAlive() == 0) {
            j = 12;
        }
        for (int k = j; k < 24; ++k) {
            float f1;
            if (this.nodes[k] == null || !((f1 = this.nodes[k].distanceToSqr(node)) < f)) continue;
            f = f1;
            i = k;
        }
        return i;
    }

    @javax.annotation.Nullable
    public Path findPath(int p_31105_, int p_31106_, @javax.annotation.Nullable Node p_31107_) {
        for (int i = 0; i < 24; ++i) {
            Node node = this.nodes[i];
            node.closed = false;
            node.f = 0.0f;
            node.g = 0.0f;
            node.h = 0.0f;
            node.cameFrom = null;
            node.heapIdx = -1;
        }
        Node node4 = this.nodes[p_31105_];
        Node node5 = this.nodes[p_31106_];
        node4.g = 0.0f;
        node4.f = node4.h = node4.distanceTo(node5);
        this.openSet.clear();
        this.openSet.insert(node4);
        Node node1 = node4;
        int j = 0;
        if (this.dragonFight == null || this.dragonFight.getCrystalsAlive() == 0) {
            j = 12;
        }
        while (!this.openSet.isEmpty()) {
            Node node2 = this.openSet.pop();
            if (node2.equals((Object)node5)) {
                if (p_31107_ != null) {
                    p_31107_.cameFrom = node5;
                    node5 = p_31107_;
                }
                return this.reconstructPath(node4, node5);
            }
            if (node2.distanceTo(node5) < node1.distanceTo(node5)) {
                node1 = node2;
            }
            node2.closed = true;
            int k = 0;
            for (int l = 0; l < 24; ++l) {
                if (this.nodes[l] != node2) continue;
                k = l;
                break;
            }
            for (int i1 = j; i1 < 24; ++i1) {
                if ((this.nodeAdjacency[k] & 1 << i1) <= 0) continue;
                Node node3 = this.nodes[i1];
                if (node3.closed) continue;
                float f = node2.g + node2.distanceTo(node3);
                if (node3.inOpenSet() && !(f < node3.g)) continue;
                node3.cameFrom = node2;
                node3.g = f;
                node3.h = node3.distanceTo(node5);
                if (node3.inOpenSet()) {
                    this.openSet.changeCost(node3, node3.g + node3.h);
                    continue;
                }
                node3.f = node3.g + node3.h;
                this.openSet.insert(node3);
            }
        }
        if (node1 == node4) {
            return null;
        }
        LOGGER.debug("Failed to find path from {} to {}", (Object)p_31105_, (Object)p_31106_);
        if (p_31107_ != null) {
            p_31107_.cameFrom = node1;
            node1 = p_31107_;
        }
        return this.reconstructPath(node4, node1);
    }

    private Path reconstructPath(Node p_31129_, Node p_31130_) {
        ArrayList list = Lists.newArrayList();
        Node node = p_31130_;
        list.add(0, p_31130_);
        while (node.cameFrom != null) {
            node = node.cameFrom;
            list.add(0, node);
        }
        return new Path((List)list, new BlockPos(p_31130_.x, p_31130_.y, p_31130_.z), true);
    }

    @Override
    public void addAdditionalSaveData(CompoundTag p_31144_) {
        super.addAdditionalSaveData(p_31144_);
        p_31144_.putInt(DRAGON_PHASE_KEY, this.phaseManager.getCurrentPhase().getPhase().getId());
        p_31144_.putInt(DRAGON_DEATH_TIME_KEY, this.dragonDeathTime);
    }

    @Override
    public void readAdditionalSaveData(CompoundTag p_31134_) {
        super.readAdditionalSaveData(p_31134_);
        if (p_31134_.contains(DRAGON_PHASE_KEY)) {
            this.phaseManager.setPhase(EnderDragonPhase.getById((int)p_31134_.getInt(DRAGON_PHASE_KEY)));
        }
        if (p_31134_.contains(DRAGON_DEATH_TIME_KEY)) {
            this.dragonDeathTime = p_31134_.getInt(DRAGON_DEATH_TIME_KEY);
        }
    }

    @Override
    public void checkDespawn() {
    }

    public EnderDragonPart[] getSubEntities() {
        return this.subEntities;
    }

    @Override
    public boolean isPickable() {
        return false;
    }

    @Override
    public SoundSource getSoundSource() {
        return SoundSource.HOSTILE;
    }

    @Override
    protected SoundEvent getAmbientSound() {
        return SoundEvents.ENDER_DRAGON_AMBIENT;
    }

    @Override
    protected SoundEvent getHurtSound(DamageSource p_31154_) {
        return SoundEvents.ENDER_DRAGON_HURT;
    }

    @Override
    protected float getSoundVolume() {
        return 5.0f;
    }

    public float getHeadPartYOffset(int p_31109_, double[] p_31110_, double[] p_31111_) {
        double d0;
        DragonPhaseInstance dragonphaseinstance = this.phaseManager.getCurrentPhase();
        EnderDragonPhase enderdragonphase = dragonphaseinstance.getPhase();
        if (enderdragonphase == EnderDragonPhase.LANDING || enderdragonphase == EnderDragonPhase.TAKEOFF) {
            BlockPos blockpos = this.level().getHeightmapPos(Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, EndPodiumFeature.getLocation((BlockPos)this.fightOrigin));
            double d1 = Math.max(Math.sqrt(blockpos.distToCenterSqr((Position)this.position())) / 4.0, 1.0);
            d0 = (double)p_31109_ / d1;
        } else {
            d0 = dragonphaseinstance.isSitting() ? (double)p_31109_ : (p_31109_ == 6 ? 0.0 : p_31111_[1] - p_31110_[1]);
        }
        return (float)d0;
    }

    public Vec3 getHeadLookVector(float p_31175_) {
        Vec3 vec3;
        DragonPhaseInstance dragonphaseinstance = this.phaseManager.getCurrentPhase();
        EnderDragonPhase enderdragonphase = dragonphaseinstance.getPhase();
        if (enderdragonphase == EnderDragonPhase.LANDING || enderdragonphase == EnderDragonPhase.TAKEOFF) {
            BlockPos blockpos = this.level().getHeightmapPos(Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, EndPodiumFeature.getLocation((BlockPos)this.fightOrigin));
            float f5 = Math.max((float)Math.sqrt(blockpos.distToCenterSqr((Position)this.position())) / 4.0f, 1.0f);
            float f2 = 6.0f / f5;
            float f3 = this.getXRot();
            float f4 = 1.5f;
            this.setXRot(-f2 * 1.5f * 5.0f);
            vec3 = this.getViewVector(p_31175_);
            this.setXRot(f3);
        } else if (dragonphaseinstance.isSitting()) {
            float f = this.getXRot();
            float f1 = 1.5f;
            this.setXRot(-45.0f);
            vec3 = this.getViewVector(p_31175_);
            this.setXRot(f);
        } else {
            vec3 = this.getViewVector(p_31175_);
        }
        return vec3;
    }

    public void onCrystalDestroyed(EndCrystal p_31125_, BlockPos p_31126_, DamageSource p_31127_) {
        Player player = p_31127_.getEntity() instanceof Player ? (Player)p_31127_.getEntity() : this.level().getNearestPlayer(CRYSTAL_DESTROY_TARGETING, p_31126_.getX(), p_31126_.getY(), p_31126_.getZ());
        if (p_31125_ == this.nearestCrystal) {
            this.hurt(this.head, this.damageSources().explosion((Entity)p_31125_, (Entity)player), 10.0f);
        }
        this.phaseManager.getCurrentPhase().onCrystalDestroyed(p_31125_, p_31126_, p_31127_, player);
    }

    @Override
    public void onSyncedDataUpdated(EntityDataAccessor<?> p_31136_) {
        if (DATA_PHASE.equals(p_31136_) && this.level().isClientSide) {
            this.phaseManager.setPhase(EnderDragonPhase.getById((int)this.getEntityData().get(DATA_PHASE)));
        }
        super.onSyncedDataUpdated(p_31136_);
    }

    public EnderDragonPhaseManager getPhaseManager() {
        return this.phaseManager;
    }

    @javax.annotation.Nullable
    public EndDragonFight getDragonFight() {
        return this.dragonFight;
    }

    @Override
    public boolean addEffect(MobEffectInstance p_182394_, @javax.annotation.Nullable Entity p_182395_) {
        return false;
    }

    @Override
    protected boolean canRide(Entity p_31169_) {
        return false;
    }

    @Override
    public boolean canUsePortal(boolean p_352948_) {
        return false;
    }

    public boolean isMultipartEntity() {
        return true;
    }

    public PartEntity<?>[] getParts() {
        return this.subEntities;
    }

    @Override
    public void recreateFromPacket(ClientboundAddEntityPacket p_218825_) {
        super.recreateFromPacket(p_218825_);
    }

    @Override
    public boolean canAttack(LivingEntity p_149576_) {
        return p_149576_.canBeSeenAsEnemy();
    }

    @Override
    protected float sanitizeScale(float p_341615_) {
        return 1.0f;
    }
}

