/*
 * Decompiled with CFR 0.152.
 */
package baguchan.hunters_return.entity.ai;

import baguchan.hunters_return.entity.Hunter;
import baguchan.hunters_return.entity.ai.DodgeMoveControl;
import java.util.EnumSet;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.BowItem;

public class DodgeGoal
extends Goal {
    public Hunter hunter;
    @Nullable
    protected List<? extends Projectile> toAvoid;
    protected final Class<? extends Projectile> dodgeAtType;
    protected final TargetingConditions lookAtContext;
    private int cooldownTime;
    private int dodgeTime;
    private boolean dodgeDirection;

    public DodgeGoal(Hunter hunterEntity, Class<? extends Projectile> dodgeAtType) {
        this.hunter = hunterEntity;
        this.dodgeAtType = dodgeAtType;
        this.lookAtContext = TargetingConditions.forNonCombat().range(10.0);
        this.setFlags(EnumSet.of(Goal.Flag.MOVE));
    }

    public boolean canUse() {
        if (!this.hunter.isHolding(item -> item.getItem() instanceof BowItem)) {
            return false;
        }
        if (--this.cooldownTime < 0) {
            if (this.hunter.getTarget() != null) {
                this.toAvoid = this.hunter.level().getEntitiesOfClass(this.dodgeAtType, this.hunter.getBoundingBox().inflate(10.0, 5.0, 10.0), p_148124_ -> !(p_148124_ instanceof AbstractArrow) || !((AbstractArrow)p_148124_).inGround && p_148124_.getOwner() != this.hunter && (p_148124_.getOwner() == null || !this.hunter.isAlliedTo(p_148124_.getOwner())));
                return !this.toAvoid.isEmpty();
            }
            this.cooldownTime = 10;
        }
        return false;
    }

    public boolean canContinueToUse() {
        return this.dodgeTime > 0;
    }

    public void start() {
        super.start();
        this.dodgeTime = 20;
        this.dodgeDirection = this.hunter.getRandom().nextBoolean();
    }

    public void tick() {
        super.tick();
        --this.dodgeTime;
        if (this.hunter.getMoveControl() instanceof DodgeMoveControl) {
            ((DodgeMoveControl)this.hunter.getMoveControl()).dodge(0.0f, this.dodgeDirection ? 0.8f : -0.8f);
        }
    }

    public boolean requiresUpdateEveryTick() {
        return true;
    }

    public void stop() {
        super.stop();
        this.cooldownTime = 40;
        this.hunter.getMoveControl().strafe(0.0f, 0.0f);
    }
}

