/*
 * Decompiled with CFR 0.152.
 */
package baguchan.hunters_return.entity.projectile;

import baguchan.hunters_return.init.HunterDamageSource;
import baguchan.hunters_return.init.HunterEnchantments;
import baguchan.hunters_return.init.HunterEntityRegistry;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Registry;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.entity.EntityTypeTest;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.neoforge.event.EventHooks;
import net.neoforged.neoforge.fluids.FluidType;

public class BoomerangEntity
extends Projectile {
    private static final EntityDataAccessor<Integer> RETURN_LEVEL = SynchedEntityData.defineId(BoomerangEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private static final EntityDataAccessor<Integer> BOUNCE_LEVEL = SynchedEntityData.defineId(BoomerangEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private static final EntityDataAccessor<Boolean> RETURNING = SynchedEntityData.defineId(BoomerangEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private static final EntityDataAccessor<Boolean> TOUCH_GROUND = SynchedEntityData.defineId(BoomerangEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private static final EntityDataAccessor<ItemStack> BOOMERANG = SynchedEntityData.defineId(BoomerangEntity.class, (EntityDataSerializer)EntityDataSerializers.ITEM_STACK);
    private static final int RETURN_TICK = 30;
    private int totalHits;
    private int flyTick;
    public boolean inGround;
    protected int inGroundTime;
    private double baseDamage = 3.0;
    @Nullable
    private BlockState lastState;

    public BoomerangEntity(EntityType<? extends BoomerangEntity> entityEntityType, Level world) {
        super(entityEntityType, world);
    }

    public BoomerangEntity(EntityType<? extends BoomerangEntity> type, Level world, LivingEntity shootingEntity, ItemStack boomerang) {
        super(type, world);
        this.setPos(shootingEntity.getX(), shootingEntity.getEyeY() - (double)0.1f, shootingEntity.getZ());
        this.setOwner((Entity)shootingEntity);
        this.setBoomerang(boomerang);
        Registry enchantments = world.registryAccess().registryOrThrow(Registries.ENCHANTMENT);
        this.entityData.set(RETURN_LEVEL, (Object)EnchantmentHelper.getTagEnchantmentLevel((Holder)enchantments.getHolderOrThrow(HunterEnchantments.RETURN), (ItemStack)boomerang));
        this.entityData.set(BOUNCE_LEVEL, (Object)EnchantmentHelper.getTagEnchantmentLevel((Holder)enchantments.getHolderOrThrow(HunterEnchantments.BOUNCE), (ItemStack)boomerang));
        this.totalHits = 0;
        this.setTouchGround(false);
    }

    public BoomerangEntity(Level world, LivingEntity entity, ItemStack boomerang) {
        this(HunterEntityRegistry.BOOMERANG.get(), world, entity, boomerang);
    }

    public DamageSource boomerangAttack(@Nullable Entity p_270857_) {
        return this.damageSources().source(HunterDamageSource.BOOMERANG, (Entity)this, p_270857_);
    }

    protected void onHitEntity(EntityHitResult result) {
        super.onHitEntity(result);
        boolean returnToOwner = false;
        int loyaltyLevel = this.getReturnLevel();
        Entity shooter = this.getOwner();
        if (!(result.getEntity() == shooter || this.isReturning() && loyaltyLevel > 0)) {
            int damage = (int)(this.baseDamage * Math.sqrt(this.getDeltaMovement().length()));
            float realDamage = damage;
            if (this.isOnFire()) {
                result.getEntity().setRemainingFireTicks(5);
            }
            DamageSource damageSource = this.boomerangAttack(shooter);
            Level level = this.level();
            if (level instanceof ServerLevel) {
                ServerLevel serverlevel = (ServerLevel)level;
                realDamage = EnchantmentHelper.modifyDamage((ServerLevel)serverlevel, (ItemStack)this.getWeaponItem(), (Entity)this.getOwner(), (DamageSource)damageSource, (float)realDamage);
            }
            if (realDamage > 0.0f && result.getEntity().hurt(damageSource, realDamage) && (level = result.getEntity()) instanceof LivingEntity) {
                LivingEntity livingEntity = (LivingEntity)level;
                this.doKnockback(livingEntity, damageSource);
                if (this.level() instanceof ServerLevel) {
                    ServerLevel serverlevel1 = (ServerLevel)this.level();
                    EnchantmentHelper.doPostAttackEffectsWithItemSource((ServerLevel)serverlevel1, (Entity)livingEntity, (DamageSource)damageSource, (ItemStack)this.getWeaponItem());
                }
            }
            double speed = this.getSpeed();
            if (this.totalHits >= this.getBounceLevel() || this.totalHits >= this.getBounceLevel() && speed > (double)0.4f) {
                returnToOwner = true;
            } else if (this.totalHits < this.getBounceLevel() || this.totalHits < this.getBounceLevel() && speed <= (double)0.4f) {
                Vec3 motion = this.getDeltaMovement();
                double motionX = motion.x;
                double motionY = motion.y;
                double motionZ = motion.z;
                motionX = -motionX;
                motionZ = -motionZ;
                this.setDeltaMovement(motionX, motionY, motionZ);
                this.setDeltaMovement(this.getDeltaMovement().scale((double)(0.91f + (float)this.getBounceLevel() * 0.01f)));
            }
            ++this.totalHits;
        }
        if (returnToOwner && !this.isReturning()) {
            if (this.getOwner() != null && this.shouldReturnToThrower() && loyaltyLevel > 0) {
                this.level().playSound(null, shooter.blockPosition(), SoundEvents.TRIDENT_RETURN, SoundSource.PLAYERS, 1.0f, 1.0f);
                Vec3 motion = this.getDeltaMovement();
                double motionX = motion.x;
                motionY = motion.y;
                double motionZ = motion.z;
                motionX = -motionX;
                motionZ = -motionZ;
                this.setDeltaMovement(motionX, motionY, motionZ);
                if (loyaltyLevel > 0 && !this.isReturning() && shooter != null) {
                    this.level().playSound(null, shooter.blockPosition(), SoundEvents.TRIDENT_RETURN, SoundSource.PLAYERS, 1.0f, 1.0f);
                    this.setReturning(true);
                }
            } else {
                Vec3 motion = this.getDeltaMovement();
                double motionX = motion.x;
                motionY = motion.y;
                double motionZ = motion.z;
                motionX = -motionX;
                motionZ = -motionZ;
                this.setDeltaMovement(motionX, motionY, motionZ);
                if (loyaltyLevel > 0 && !this.isReturning() && shooter != null) {
                    this.level().playSound(null, shooter.blockPosition(), SoundEvents.TRIDENT_RETURN, SoundSource.PLAYERS, 1.0f, 1.0f);
                    this.setReturning(true);
                }
            }
        }
    }

    public ItemStack getWeaponItem() {
        return this.getBoomerang();
    }

    protected void onHitBlock(BlockHitResult result) {
        super.onHitBlock(result);
        BlockPos pos = result.getBlockPos();
        BlockState state = this.level().getBlockState(pos);
        SoundType soundType = state.getSoundType((LevelReader)this.level(), pos, (Entity)this);
        ItemStack itemstack = this.getWeaponItem();
        Level var5 = this.level();
        int returnLevel = this.getReturnLevel();
        Entity entity = this.getOwner();
        Vec3 movement = this.getDeltaMovement();
        if (!this.isReturning() || returnLevel > 0 && this.isReturning()) {
            if (var5 instanceof ServerLevel) {
                ServerLevel serverlevel = (ServerLevel)var5;
                if (itemstack != null) {
                    this.hitBlockEnchantmentEffects(serverlevel, result, itemstack);
                }
            }
            if (movement.length() < (double)0.35f && movement.y <= 0.0) {
                if (returnLevel > 0) {
                    if (!this.isReturning() && entity != null) {
                        this.level().playSound(null, entity.blockPosition(), SoundEvents.TRIDENT_RETURN, SoundSource.PLAYERS, 1.0f, 1.0f);
                        this.setReturning(true);
                    }
                } else {
                    this.setReturning(false);
                    this.inGround = true;
                    this.lastState = this.level().getBlockState(result.getBlockPos());
                    Vec3 vec3 = result.getLocation().subtract(this.getX(), this.getY(), this.getZ());
                    this.setDeltaMovement(vec3);
                    Vec3 vec31 = vec3.normalize().scale((double)0.05f);
                    this.setPosRaw(this.getX() - vec31.x, this.getY() - vec31.y, this.getZ() - vec31.z);
                }
            } else {
                Vec3i direction = result.getDirection().getNormal();
                switch (result.getDirection()) {
                    case UP: 
                    case SOUTH: 
                    case EAST: {
                        direction = direction.multiply(-1);
                        break;
                    }
                }
                direction = new Vec3i(direction.getX() == 0 ? 1 : direction.getX(), direction.getY() == 0 ? 1 : direction.getY(), direction.getZ() == 0 ? 1 : direction.getZ());
                this.setDeltaMovement(movement.multiply(new Vec3((double)direction.getX(), (double)direction.getY(), (double)direction.getZ())).scale((double)(0.91f + (float)this.getBounceLevel() * 0.01f)));
                this.playSound(SoundEvents.WOOD_STEP, 0.5f, 1.0f);
                if (!this.isReturning()) {
                    this.level().playSound(null, this.getX(), this.getY(), this.getZ(), soundType.getHitSound(), SoundSource.BLOCKS, soundType.getVolume(), soundType.getPitch());
                }
                if (returnLevel <= 0) {
                    this.setTouchGround(true);
                    this.setReturning(false);
                }
            }
        }
    }

    protected void doKnockback(LivingEntity p_346111_, DamageSource p_346412_) {
        float var10000;
        Level var6;
        if (this.getBoomerang() != null && (var6 = this.level()) instanceof ServerLevel) {
            ServerLevel serverlevel = (ServerLevel)var6;
            var10000 = EnchantmentHelper.modifyKnockback((ServerLevel)serverlevel, (ItemStack)this.getBoomerang(), (Entity)p_346111_, (DamageSource)p_346412_, (float)0.0f);
        } else {
            var10000 = 0.0f;
        }
        double d0 = var10000;
        if (d0 > 0.0) {
            double d1 = Math.max(0.0, 1.0 - p_346111_.getAttributeValue(Attributes.KNOCKBACK_RESISTANCE));
            Vec3 vec3 = this.getDeltaMovement().multiply(1.0, 0.0, 1.0).normalize().scale(d0 * 0.6 * d1);
            if (vec3.lengthSqr() > 0.0) {
                p_346111_.push(vec3.x, 0.1, vec3.z);
            }
        }
    }

    protected void hitBlockEnchantmentEffects(ServerLevel p_345462_, BlockHitResult p_345204_, ItemStack p_345083_) {
        LivingEntity livingentity;
        Vec3 vec3 = p_345204_.getBlockPos().clampLocationWithin(p_345204_.getLocation());
        Entity var6 = this.getOwner();
        LivingEntity var10002 = var6 instanceof LivingEntity ? (livingentity = (LivingEntity)var6) : null;
        EnchantmentHelper.onHitBlock((ServerLevel)p_345462_, (ItemStack)p_345083_, (LivingEntity)var10002, (Entity)this, (EquipmentSlot)null, (Vec3)vec3, (BlockState)p_345462_.getBlockState(p_345204_.getBlockPos()), p_348569_ -> {});
    }

    public int getFlyTick() {
        return this.flyTick;
    }

    private boolean shouldReturnToThrower() {
        Entity entity = this.getOwner();
        if (entity != null && entity.isAlive()) {
            return !entity.isSpectator();
        }
        return false;
    }

    private boolean shouldDropToThrower() {
        Entity entity = this.getOwner();
        if (entity != null && entity.isAlive()) {
            return !entity.isSpectator() && !(entity instanceof Player) && this.distanceToSqr(entity) < 3.0;
        }
        return false;
    }

    public void playerTouch(Player entityIn) {
        super.playerTouch(entityIn);
        if ((this.flyTick >= 10 || this.inGround) && entityIn == this.getOwner() && !this.level().isClientSide && (!entityIn.isCreative() && this.tryPickup(entityIn) || entityIn.isCreative())) {
            this.playSound(SoundEvents.ITEM_PICKUP);
            entityIn.take((Entity)this, 1);
            this.discard();
        }
    }

    protected boolean tryPickup(Player p_150121_) {
        return p_150121_.getInventory().add(this.getBoomerang());
    }

    public void drop(double x, double y, double z) {
        if (!this.level().isClientSide()) {
            if (!(this.getOwner() instanceof Player) || this.getOwner() instanceof Player && !((Player)this.getOwner()).isCreative()) {
                this.level().addFreshEntity((Entity)new ItemEntity(this.level(), x, y, z, this.getBoomerang().split(1)));
                this.discard();
            } else {
                this.discard();
            }
        }
    }

    public void move(MoverType p_36749_, Vec3 p_36750_) {
        super.move(p_36749_, p_36750_);
        if (p_36749_ != MoverType.SELF && this.shouldFall()) {
            this.startFalling();
        }
    }

    public void shoot(double p_36775_, double p_36776_, double p_36777_, float p_36778_, float p_36779_) {
        super.shoot(p_36775_, p_36776_, p_36777_, p_36778_, p_36779_);
        this.inGroundTime = 0;
    }

    public void lerpMotion(double p_36786_, double p_36787_, double p_36788_) {
        super.lerpMotion(p_36786_, p_36787_, p_36788_);
        this.inGroundTime = 0;
    }

    public void tick() {
        VoxelShape voxelshape;
        super.tick();
        int returningLevel = (Integer)this.entityData.get(RETURN_LEVEL);
        boolean flag = false;
        boolean flag2 = returningLevel > 0 || !this.isTouchGround();
        Vec3 vec3 = this.getDeltaMovement();
        if (this.xRotO == 0.0f && this.yRotO == 0.0f) {
            double d0 = vec3.horizontalDistance();
            this.setYRot((float)(Mth.atan2((double)vec3.x, (double)vec3.z) * 180.0 / 3.1415927410125732));
            this.setXRot((float)(Mth.atan2((double)vec3.y, (double)d0) * 180.0 / 3.1415927410125732));
            this.yRotO = this.getYRot();
            this.xRotO = this.getXRot();
        }
        BlockPos blockpos = this.blockPosition();
        BlockState blockstate = this.level().getBlockState(blockpos);
        if (!(blockstate.isAir() || flag || returningLevel > 0 || (voxelshape = blockstate.getCollisionShape((BlockGetter)this.level(), blockpos)).isEmpty())) {
            Vec3 vec31 = this.position();
            for (AABB aabb : voxelshape.toAabbs()) {
                if (!aabb.move(blockpos).contains(vec31)) continue;
                this.inGround = true;
                break;
            }
        }
        if (this.isInWaterOrRain() || blockstate.is(Blocks.POWDER_SNOW) || this.isInFluidType((fluidType, height) -> this.canFluidExtinguish((FluidType)fluidType))) {
            this.clearFire();
        }
        if (this.inGround && !flag) {
            if (this.lastState != blockstate && this.shouldFall()) {
                this.startFalling();
            } else if (!this.level().isClientSide) {
                this.tickDespawn();
            }
            ++this.inGroundTime;
        } else {
            float f;
            this.inGroundTime = 0;
            HitResult hitresult = ProjectileUtil.getHitResultOnMoveVector((Entity)this, x$0 -> this.canHitEntity((Entity)x$0));
            if (hitresult.getType() != HitResult.Type.MISS && !EventHooks.onProjectileImpact((Projectile)this, (HitResult)hitresult)) {
                this.hitTargetOrDeflectSelf(hitresult);
            }
            Entity entity = this.getOwner();
            if (!this.isReturning() && this.flyTick >= 30 && entity != null && !this.isTouchGround()) {
                if (returningLevel > 0) {
                    this.level().playSound(null, entity.blockPosition(), SoundEvents.TRIDENT_RETURN, SoundSource.PLAYERS, 1.0f, 1.0f);
                }
                this.setReturning(true);
            }
            if (returningLevel > 0 && entity != null && !this.shouldReturnToThrower() && this.isReturning()) {
                this.drop(this.getX(), this.getY(), this.getZ());
            } else if (entity != null && this.isReturning()) {
                this.noPhysics = true;
                Vec3 vec3d3 = new Vec3(entity.getX() - this.getX(), entity.getEyeY() - this.getY(), entity.getZ() - this.getZ());
                double d0 = 0.05 * (double)(returningLevel + 1);
                this.setDeltaMovement(this.getDeltaMovement().scale(0.95).add(vec3d3.normalize().scale(d0)));
            }
            vec3 = this.getDeltaMovement();
            double d5 = vec3.x;
            double d6 = vec3.y;
            double d1 = vec3.z;
            double d7 = this.getX() + d5;
            double d2 = this.getY() + d6;
            double d3 = this.getZ() + d1;
            double d4 = vec3.horizontalDistance();
            if (flag2) {
                this.setYRot((float)(Mth.atan2((double)(-d5), (double)(-d1)) * 180.0 / 3.1415927410125732));
            } else {
                this.setYRot((float)(Mth.atan2((double)d5, (double)d1) * 180.0 / 3.1415927410125732));
            }
            this.setXRot((float)(Mth.atan2((double)d6, (double)d4) * 180.0 / 3.1415927410125732));
            this.setXRot(BoomerangEntity.lerpRotation((float)this.xRotO, (float)this.getXRot()));
            this.setYRot(BoomerangEntity.lerpRotation((float)this.yRotO, (float)this.getYRot()));
            float f2 = f = returningLevel > 0 ? 1.0f : 0.99f;
            if (this.isInWater()) {
                for (int j = 0; j < 4; ++j) {
                    float f1 = 0.25f;
                    this.level().addParticle((ParticleOptions)ParticleTypes.BUBBLE, d7 - d5 * 0.25, d2 - d6 * 0.25, d3 - d1 * 0.25, d5, d6, d1);
                }
                f = this.getWaterInertia();
            }
            if (!flag2) {
                this.applyGravity();
            }
            this.setDeltaMovement(this.getDeltaMovement().scale((double)f));
            this.setPos(d7, d2, d3);
            this.checkInsideBlocks();
            if (!this.level().isClientSide()) {
                List list = this.level().getEntities(EntityTypeTest.forClass(ItemEntity.class), this.getBoundingBox().inflate((double)0.1f), Entity::isAlive);
                if (this.getPassengers().isEmpty() && list != null && !list.isEmpty()) {
                    ((ItemEntity)list.get(0)).startRiding((Entity)this);
                }
            }
            ++this.flyTick;
        }
        if (this.shouldDropToThrower()) {
            this.drop(this.getX(), this.getY(), this.getZ());
        }
    }

    protected float getWaterInertia() {
        return 0.6f;
    }

    @Nullable
    protected EntityHitResult findHitEntity(Vec3 p_36758_, Vec3 p_36759_) {
        return ProjectileUtil.getEntityHitResult((Level)this.level(), (Entity)this, (Vec3)p_36758_, (Vec3)p_36759_, (AABB)this.getBoundingBox().expandTowards(this.getDeltaMovement()).inflate(1.0), x$0 -> this.canHitEntity((Entity)x$0));
    }

    protected void tickDespawn() {
        ++this.inGroundTime;
        if (this.inGroundTime >= 1200) {
            this.discard();
        }
    }

    private boolean shouldFall() {
        return this.isInGround() && this.level().noCollision(new AABB(this.position(), this.position()).inflate(0.06));
    }

    private void startFalling() {
        this.setInGround(false);
        Vec3 vec3 = this.getDeltaMovement();
        this.setDeltaMovement(vec3.multiply((double)(this.random.nextFloat() * 0.2f), (double)(this.random.nextFloat() * 0.2f), (double)(this.random.nextFloat() * 0.2f)));
        this.inGroundTime = 0;
    }

    public boolean shouldRenderAtSqrDistance(double p_70112_1_) {
        double d0 = this.getBoundingBox().getSize() * 5.0;
        if (Double.isNaN(d0)) {
            d0 = 1.0;
        }
        return p_70112_1_ < (d0 *= 64.0) * d0;
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        builder.define(RETURN_LEVEL, (Object)0);
        builder.define(BOUNCE_LEVEL, (Object)0);
        builder.define(RETURNING, (Object)false);
        builder.define(TOUCH_GROUND, (Object)true);
        builder.define(BOOMERANG, (Object)ItemStack.EMPTY);
    }

    public void addAdditionalSaveData(CompoundTag nbt) {
        super.addAdditionalSaveData(nbt);
        nbt.put("boomerang", this.getBoomerang().save((HolderLookup.Provider)this.registryAccess(), (Tag)new CompoundTag()));
        nbt.putInt("totalHits", this.totalHits);
        nbt.putInt("InGroundTime", this.inGroundTime);
        nbt.putInt("FlyTick", this.flyTick);
        nbt.putInt("ReturnLevel", this.getReturnLevel());
        nbt.putInt("BounceLevel", this.getBounceLevel());
        nbt.putBoolean("returning", this.isReturning());
        if (this.lastState != null) {
            nbt.put("inBlockState", (Tag)NbtUtils.writeBlockState((BlockState)this.lastState));
        }
        nbt.putBoolean("inGround", this.isInGround());
        nbt.putBoolean("TouchGround", this.isTouchGround());
    }

    public void readAdditionalSaveData(CompoundTag nbt) {
        super.readAdditionalSaveData(nbt);
        this.setBoomerang(ItemStack.parse((HolderLookup.Provider)this.registryAccess(), (Tag)nbt.getCompound("boomerang")).orElse(this.getBoomerang()));
        this.totalHits = nbt.getInt("totalHits");
        this.inGroundTime = nbt.getInt("InGroundTime");
        if (nbt.contains("inBlockState", 10)) {
            this.lastState = NbtUtils.readBlockState((HolderGetter)this.level().holderLookup(Registries.BLOCK), (CompoundTag)nbt.getCompound("inBlockState"));
        }
        this.setInGround(nbt.getBoolean("inGround"));
        this.flyTick = nbt.getInt("FlyTick");
        this.setReturning(nbt.getBoolean("returning"));
        this.setReturnLevel(nbt.getInt("ReturnLevel"));
        this.setBounceLevel(nbt.getInt("BounceLevel"));
        this.setTouchGround(nbt.getBoolean("TouchGround"));
    }

    private int getReturnLevel() {
        return (Integer)this.entityData.get(RETURN_LEVEL);
    }

    public int getInGroundTime() {
        return this.inGroundTime;
    }

    public void setReturnLevel(int returning) {
        this.entityData.set(RETURN_LEVEL, (Object)returning);
    }

    public void setBounceLevel(int bounce) {
        this.entityData.set(BOUNCE_LEVEL, (Object)bounce);
    }

    private int getBounceLevel() {
        int returnLevel = this.getReturnLevel();
        int bounceLevel = (Integer)this.entityData.get(BOUNCE_LEVEL);
        if (returnLevel > 0) {
            return bounceLevel * 2;
        }
        return bounceLevel;
    }

    public boolean isReturning() {
        return (Boolean)this.entityData.get(RETURNING);
    }

    public ItemStack getBoomerang() {
        return (ItemStack)this.entityData.get(BOOMERANG);
    }

    public double getSpeed() {
        return Math.sqrt(this.getDeltaMovement().x * this.getDeltaMovement().x + this.getDeltaMovement().y * this.getDeltaMovement().y + this.getDeltaMovement().z * this.getDeltaMovement().z);
    }

    public double getVelocity() {
        return Math.sqrt(this.getDeltaMovement().x * this.getDeltaMovement().x + this.getDeltaMovement().z * this.getDeltaMovement().z);
    }

    public void setBaseDamage(double baseDamage) {
        this.baseDamage = baseDamage;
    }

    public void setReturning(boolean returning) {
        this.entityData.set(RETURNING, (Object)returning);
    }

    protected double getDefaultGravity() {
        return this.getReturnLevel() <= 0 && this.isTouchGround() ? (double)0.05f : 0.0;
    }

    public void setInGround(boolean flag) {
        this.inGround = flag;
    }

    public boolean isInGround() {
        return this.inGround;
    }

    public void setBoomerang(ItemStack stack) {
        this.entityData.set(BOOMERANG, (Object)stack);
    }

    public void setTouchGround(boolean flag) {
        this.entityData.set(TOUCH_GROUND, (Object)flag);
    }

    public boolean isTouchGround() {
        return (Boolean)this.entityData.get(TOUCH_GROUND);
    }
}

