/*
 * Decompiled with CFR 0.152.
 */
package baguchan.hunters_return.item;

import baguchan.hunters_return.entity.projectile.BoomerangEntity;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BowItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.level.Level;

public class BoomerangItem
extends Item {
    public BoomerangItem(Item.Properties properties) {
        super(properties);
    }

    public InteractionResultHolder<ItemStack> use(Level world, Player player, InteractionHand hand) {
        player.startUsingItem(hand);
        return new InteractionResultHolder(InteractionResult.SUCCESS, (Object)player.getItemInHand(hand));
    }

    public void releaseUsing(ItemStack stack, Level world, LivingEntity entity, int timeLeft) {
        int i = this.getUseDuration(stack, entity) - timeLeft;
        if (i >= 10 && !world.isClientSide) {
            stack.hurtAndBreak(1, entity, LivingEntity.getSlotForHand((InteractionHand)entity.getUsedItemHand()));
            int heldTime = this.getUseDuration(stack, entity) - timeLeft;
            float velocity = 1.5f * BowItem.getPowerForTime((int)heldTime);
            BoomerangEntity projectile = new BoomerangEntity(world, entity, stack.copy());
            projectile.shootFromRotation((Entity)entity, entity.getXRot(), entity.getYRot(), 0.0f, velocity, 1.0f);
            world.addFreshEntity((Entity)projectile);
            world.playSound(null, entity.getX(), entity.getY(), entity.getZ(), SoundEvents.EGG_THROW, SoundSource.PLAYERS, 1.0f, 1.0f);
            if (!(entity instanceof Player) || !((Player)entity).isCreative()) {
                stack.shrink(1);
            }
        }
    }

    public int getUseDuration(ItemStack p_41454_, LivingEntity p_344979_) {
        return 72000;
    }

    public UseAnim getUseAnimation(ItemStack p_43417_) {
        return UseAnim.BOW;
    }

    public int getEnchantmentValue(ItemStack stack) {
        return 2;
    }
}

