/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.installertools;

import de.siegmar.fastcsv.reader.NamedCsvReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.attribute.FileTime;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.function.Predicate;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import java.util.stream.Collectors;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import joptsimple.ArgumentAcceptingOptionSpec;
import joptsimple.OptionException;
import joptsimple.OptionParser;
import joptsimple.OptionSet;
import joptsimple.OptionSpec;
import net.neoforged.installertools.Task;
import net.neoforged.installertools.util.Utils;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.commons.ClassRemapper;
import org.objectweb.asm.commons.Remapper;

public class SrgMcpRenamer
extends Task {
    @Override
    public void process(String[] args) throws IOException {
        OptionParser parser = new OptionParser();
        ArgumentAcceptingOptionSpec mcpO = parser.accepts("mcp").withRequiredArg().ofType(File.class).required();
        ArgumentAcceptingOptionSpec inputO = parser.accepts("input").withRequiredArg().ofType(File.class).required();
        ArgumentAcceptingOptionSpec outputO = parser.accepts("output").withRequiredArg().ofType(File.class).required();
        parser.accepts("strip-signatures");
        try {
            OptionSet options = parser.parse(args);
            File mcp = ((File)options.valueOf((OptionSpec)mcpO)).getAbsoluteFile();
            File input = ((File)options.valueOf((OptionSpec)inputO)).getAbsoluteFile();
            File output = ((File)options.valueOf((OptionSpec)outputO)).getAbsoluteFile();
            boolean stripSignatures = options.has("strip-signatures");
            this.log("Input:  " + input);
            this.log("Output: " + output);
            this.log("MCP:    " + mcp);
            if (!mcp.exists()) {
                this.error("Missing required MCP data: " + mcp);
            }
            if (!input.exists()) {
                this.error("Missing required input jar: " + input);
            }
            if (output.exists()) {
                output.delete();
            }
            if (!output.getParentFile().exists()) {
                output.getParentFile().mkdirs();
            }
            output.createNewFile();
            this.log("Loading MCP Data");
            final HashMap map = new HashMap();
            try (ZipFile zip = new ZipFile(mcp);){
                List entries = zip.stream().filter(e -> e.getName().endsWith(".csv")).collect(Collectors.toList());
                for (ZipEntry entry : entries) {
                    NamedCsvReader reader = NamedCsvReader.builder().build((Reader)new InputStreamReader(zip.getInputStream(entry)));
                    reader.stream().forEach(row -> {
                        String searge;
                        try {
                            searge = row.getField("searge");
                        }
                        catch (NoSuchElementException e) {
                            searge = row.getField("param");
                        }
                        map.put(searge, row.getField("name"));
                    });
                }
            }
            Remapper remapper = new Remapper(){

                public String mapFieldName(String owner, String name, String descriptor) {
                    return map.getOrDefault(name, name);
                }

                public String mapInvokeDynamicMethodName(String name, String descriptor) {
                    return map.getOrDefault(name, name);
                }

                public String mapMethodName(String owner, String name, String descriptor) {
                    return map.getOrDefault(name, name);
                }
            };
            this.log("Processing ZIP file");
            ArrayList<ZipEntryProcessor> processors = new ArrayList<ZipEntryProcessor>();
            processors.add(new ZipEntryProcessor(ein -> ein.getName().endsWith(".class"), (ein, zin, zout) -> this.processClass(ein, zin, zout, remapper)));
            if (stripSignatures) {
                processors.add(new ZipEntryProcessor(this::holdsSignatures, (ein, zin, zout) -> this.log("Stripped signature entry data " + ein.getName())));
                processors.add(new ZipEntryProcessor(ein -> ein.getName().endsWith("META-INF/MANIFEST.MF"), this::processManifest));
            }
            ZipWritingConsumer defaultProcessor = (ein, zin, zout) -> {
                zout.putNextEntry(this.makeNewEntry(ein));
                Utils.copy(zin, zout);
            };
            processors.add(new ZipEntryProcessor(ein -> ein.getName().startsWith("META-INF/jarjar/") && ein.getName().endsWith(".jar"), (ein, zin, zout) -> this.processNestedJar(processors, defaultProcessor, ein, zin, zout)));
            ByteArrayOutputStream memory = input.equals(output) ? new ByteArrayOutputStream() : null;
            try (ZipOutputStream zout2 = new ZipOutputStream(memory == null ? new FileOutputStream(output) : memory);
                 ZipInputStream in = new ZipInputStream(new FileInputStream(input));){
                this.process(processors, defaultProcessor, in, zout2);
            }
            if (memory != null) {
                Files.write(output.toPath(), memory.toByteArray(), new OpenOption[0]);
            }
            this.log("Process complete");
        }
        catch (OptionException e2) {
            parser.printHelpOn((OutputStream)System.out);
            e2.printStackTrace();
        }
    }

    private void process(List<ZipEntryProcessor> processors, ZipWritingConsumer defaultProcessor, ZipInputStream in, ZipOutputStream zout) throws IOException {
        this.forEachZipEntry(in, (ein, zin) -> {
            for (ZipEntryProcessor processor : processors) {
                if (!processor.validate(ein)) continue;
                processor.getProcessor().process(ein, zin, zout);
                return;
            }
            defaultProcessor.process(ein, zin, zout);
        });
    }

    private void forEachZipEntry(ZipInputStream zin, ZipConsumer entryConsumer) throws IOException {
        ZipEntry ein;
        String prevName = null;
        while ((ein = zin.getNextEntry()) != null) {
            try {
                entryConsumer.processEntry(ein, zin);
            }
            catch (ZipException e) {
                throw new RuntimeException("Unable to process entry '" + ein.getName() + "' due to an error when processing previous entry '" + prevName + "'", e);
            }
            prevName = ein.getName();
        }
    }

    private void processClass(ZipEntry ein, ZipInputStream zin, ZipOutputStream zout, Remapper remapper) throws IOException {
        byte[] data = Utils.toByteArray(zin);
        ClassReader reader = new ClassReader(data);
        ClassWriter writer = new ClassWriter(0);
        reader.accept((ClassVisitor)new ClassRemapper((ClassVisitor)writer, remapper), 0);
        data = writer.toByteArray();
        zout.putNextEntry(this.makeNewEntry(ein));
        zout.write(data);
    }

    private void processManifest(ZipEntry ein, ZipInputStream zin, ZipOutputStream zout) throws IOException {
        Manifest min = new Manifest(zin);
        Manifest mout = new Manifest();
        mout.getMainAttributes().putAll((Map<?, ?>)min.getMainAttributes());
        min.getEntries().forEach((name, ain) -> {
            Attributes aout = new Attributes();
            ain.forEach((k, v) -> {
                if (!"SHA-256-Digest".equalsIgnoreCase(k.toString())) {
                    aout.put(k, v);
                }
            });
            if (!aout.values().isEmpty()) {
                mout.getEntries().put((String)name, aout);
            }
        });
        zout.putNextEntry(this.makeNewEntry(ein));
        mout.write(zout);
        this.log("Stripped Manifest of sha digests");
    }

    private void processNestedJar(List<ZipEntryProcessor> processors, ZipWritingConsumer defaultProcessor, ZipEntry ein, ZipInputStream in, ZipOutputStream zout) throws IOException {
        zout.putNextEntry(this.makeNewEntry(ein));
        ZipInputStream nestedIn = new ZipInputStream(in);
        ZipOutputStream nestedOut = new ZipOutputStream(zout);
        this.process(processors, defaultProcessor, nestedIn, nestedOut);
        nestedOut.finish();
    }

    private boolean holdsSignatures(ZipEntry ein) {
        return ein.getName().startsWith("META-INF/") && (ein.getName().endsWith(".SF") || ein.getName().endsWith(".RSA"));
    }

    private ZipEntry makeNewEntry(ZipEntry oldEntry) {
        ZipEntry newEntry = new ZipEntry(oldEntry.getName());
        if (oldEntry.getLastModifiedTime() != null) {
            newEntry.setLastModifiedTime(oldEntry.getLastModifiedTime());
        } else {
            newEntry.setLastModifiedTime(FileTime.fromMillis(946684800L));
        }
        if (oldEntry.getCreationTime() != null) {
            newEntry.setCreationTime(oldEntry.getCreationTime());
        }
        if (oldEntry.getLastAccessTime() != null) {
            newEntry.setLastAccessTime(oldEntry.getLastAccessTime());
        }
        if (oldEntry.getComment() != null) {
            newEntry.setComment(oldEntry.getComment());
        }
        return newEntry;
    }

    @FunctionalInterface
    private static interface ZipConsumer {
        public void processEntry(ZipEntry var1, ZipInputStream var2) throws IOException;
    }

    @FunctionalInterface
    private static interface ZipWritingConsumer {
        public void process(ZipEntry var1, ZipInputStream var2, ZipOutputStream var3) throws IOException;
    }

    private static class ZipEntryProcessor {
        private final Predicate<ZipEntry> validator;
        private final ZipWritingConsumer consumer;

        ZipEntryProcessor(Predicate<ZipEntry> validator, ZipWritingConsumer consumer) {
            this.validator = validator;
            this.consumer = consumer;
        }

        boolean validate(ZipEntry ein) {
            return this.validator.test(ein);
        }

        ZipWritingConsumer getProcessor() {
            return this.consumer;
        }
    }
}

