/*
 * Decompiled with CFR 0.152.
 */
package bagu_chan.bagus_lib.api.client;

import bagu_chan.bagus_lib.api.client.KeyframeBagusAnimations;
import java.util.Optional;
import net.minecraft.client.animation.AnimationDefinition;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.world.entity.AnimationState;
import org.joml.Vector3f;

public interface IRootModel {
    public ModelPart getBagusRoot();

    public Vector3f getCacheVec();

    default public Optional<ModelPart> getBetterAnyDescendantWithName(String name) {
        return name.equals("root") ? Optional.of(this.getBagusRoot()) : this.getBagusRoot().getAllParts().filter(p_233400_ -> p_233400_.hasChild(name)).findFirst().map(p_233397_ -> p_233397_.getChild(name));
    }

    default public void animateBagu(AnimationState animationState, AnimationDefinition animationDefinition, float ageInTick) {
        this.animateBagu(animationState, animationDefinition, ageInTick, 1.0f);
    }

    default public void animateWalkBagu(AnimationDefinition animationDefinition, float limbSwing, float limbSwingScale, float animationSpeedScale, float animationScale) {
        long i = (long)(limbSwing * 50.0f * animationSpeedScale);
        float f = Math.min(limbSwingScale * animationScale, 1.0f);
        KeyframeBagusAnimations.animate(this, animationDefinition, i, f, this.getCacheVec());
    }

    default public void animateBagu(AnimationState animationState, AnimationDefinition animationDefinition, float ageInTick, float animationSpeedScale) {
        animationState.updateTime(ageInTick, animationSpeedScale);
        animationState.ifStarted(p_233392_ -> KeyframeBagusAnimations.animate(this, animationDefinition, p_233392_.getAccumulatedTime(), 1.0f, this.getCacheVec()));
    }

    default public void applyStaticBagu(AnimationDefinition animationDefinition) {
        KeyframeBagusAnimations.animate(this, animationDefinition, 0L, 1.0f, this.getCacheVec());
    }
}

