/*
 * Decompiled with CFR 0.152.
 */
package bagu_chan.bagus_lib.client.camera.holder;

import bagu_chan.bagus_lib.util.GlobalVec3;
import net.minecraft.util.Mth;
import net.neoforged.neoforge.client.event.ViewportEvent;

public class CameraHolder {
    public int distance;
    public int duration;
    public int time;
    public float amount;
    private final GlobalVec3 pos;

    public CameraHolder(int distance, int duration, float amount, GlobalVec3 pos) {
        this.distance = distance;
        this.duration = duration;
        this.amount = amount;
        this.pos = pos;
    }

    public CameraHolder(int distance, int duration, GlobalVec3 pos) {
        this(distance, duration, 0.05f, pos);
    }

    public int getDistance() {
        return this.distance;
    }

    public GlobalVec3 getPos() {
        return this.pos;
    }

    public int getDuration() {
        return this.duration;
    }

    private void preTick(ViewportEvent.ComputeCameraAngles event) {
        float dist = (float)Mth.clamp((double)((double)this.distance / this.getPos().pos().distanceToSqr(event.getCamera().getPosition())), (double)0.0, (double)1.0);
        float leftTick = (float)this.getDuration() / (float)this.time;
        if (this.getPos().pos().distanceToSqr(event.getCamera().getPosition()) < (double)(this.distance * this.distance) && event.getCamera().getEntity().level().dimension() == this.getPos().dimension()) {
            double ticks = (double)event.getCamera().getEntity().tickCount + event.getPartialTick();
            float amount = leftTick * dist;
            event.setPitch(event.getPitch() + amount * Mth.cos((float)((float)(ticks * 3.0))) * (float)this.distance * 0.1f * this.amount);
            event.setYaw(event.getYaw() + amount * Mth.cos((float)((float)(ticks * 2.5))) * (float)this.distance * 0.1f * this.amount);
            event.setRoll(event.getRoll() + amount * Mth.cos((float)((float)(ticks * 2.0))) * (float)this.distance * 0.1f * this.amount);
        }
    }

    public void tick(ViewportEvent.ComputeCameraAngles event) {
        ++this.time;
        this.preTick(event);
    }
}

