/*
 * Decompiled with CFR 0.152.
 */
package bagu_chan.bagus_lib.util;

import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import it.unimi.dsi.fastutil.objects.ObjectList;
import java.util.ArrayList;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.Pools;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.random.SimpleWeightedRandomList;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.pools.SinglePoolElement;
import net.minecraft.world.level.levelgen.structure.pools.StructurePoolElement;
import net.minecraft.world.level.levelgen.structure.pools.StructureTemplatePool;
import net.minecraft.world.level.levelgen.structure.pools.alias.Random;
import net.minecraft.world.level.levelgen.structure.structures.JigsawStructure;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessorList;
import org.apache.commons.compress.utils.Lists;

public class JigsawHelper {
    private static final ResourceKey<StructureProcessorList> EMPTY_PROCESSOR_LIST_KEY = ResourceKey.create((ResourceKey)Registries.PROCESSOR_LIST, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)"empty"));

    public static void registerJigsawWithRandomPoolAliases(MinecraftServer server, ResourceLocation structureLocation, ResourceLocation poolAliasLocation, SimpleWeightedRandomList<String> targets) {
        RegistryAccess.Frozen manager = server.registryAccess();
        Registry structures = (Registry)manager.registry(Registries.STRUCTURE).orElseThrow();
        Structure structure = (Structure)structures.get(structureLocation);
        if (structure == null) {
            return;
        }
        if (structure instanceof JigsawStructure) {
            JigsawStructure jigsawStructure = (JigsawStructure)structure;
            ArrayList list = Lists.newArrayList();
            list.addAll(jigsawStructure.poolAliases);
            jigsawStructure.poolAliases = list;
            jigsawStructure.poolAliases.add(JigsawHelper.random(poolAliasLocation.toString(), targets));
        }
    }

    public static void registerJigsaw(MinecraftServer server, ResourceLocation poolLocation, ResourceLocation nbtLocation, int weight) {
        RegistryAccess.Frozen manager = server.registryAccess();
        Registry templatePoolRegistry = (Registry)manager.registry(Registries.TEMPLATE_POOL).orElseThrow();
        Registry processorListRegistry = (Registry)manager.registry(Registries.PROCESSOR_LIST).orElseThrow();
        StructureTemplatePool pool = (StructureTemplatePool)templatePoolRegistry.get(poolLocation);
        if (pool == null) {
            return;
        }
        ObjectArrayList elements = pool.templates;
        Holder.Reference processorListHolder = processorListRegistry.getHolderOrThrow(EMPTY_PROCESSOR_LIST_KEY);
        StructurePoolElement element = (StructurePoolElement)SinglePoolElement.legacy((String)nbtLocation.toString(), (Holder)processorListHolder).apply(StructureTemplatePool.Projection.RIGID);
        for (int i = 0; i < weight; ++i) {
            elements.add((Object)element);
        }
        ArrayList elementCounts = new ArrayList(pool.rawTemplates);
        elements.addAll((ObjectList)pool.templates);
        elementCounts.addAll(pool.rawTemplates);
        pool.templates = elements;
        pool.rawTemplates = elementCounts;
    }

    public static Random random(String alias, SimpleWeightedRandomList<String> targets) {
        SimpleWeightedRandomList.Builder builder = SimpleWeightedRandomList.builder();
        targets.unwrap().forEach(p_338103_ -> builder.add((Object)Pools.parseKey((String)((String)p_338103_.data())), p_338103_.getWeight().asInt()));
        return JigsawHelper.random((ResourceKey<StructureTemplatePool>)Pools.parseKey((String)alias), (SimpleWeightedRandomList<ResourceKey<StructureTemplatePool>>)builder.build());
    }

    public static Random random(ResourceKey<StructureTemplatePool> alias, SimpleWeightedRandomList<ResourceKey<StructureTemplatePool>> targets) {
        return new Random(alias, targets);
    }
}

