/*
 * Decompiled with CFR 0.152.
 */
package bagu_chan.bagus_lib.util.client;

import bagu_chan.bagus_lib.animation.BaguAnimationController;
import bagu_chan.bagus_lib.api.IBaguAnimate;
import bagu_chan.bagus_lib.message.SyncBagusAnimationsMessage;
import bagu_chan.bagus_lib.message.SyncBagusAnimationsStopAllMessage;
import bagu_chan.bagus_lib.message.SyncBagusAnimationsStopMessage;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.neoforge.network.PacketDistributor;
import org.jetbrains.annotations.Nullable;

public class AnimationUtil {
    @OnlyIn(value=Dist.CLIENT)
    public static void handleAnimationPacket(Entity entity, ResourceLocation resourceLocation) {
        if (entity instanceof IBaguAnimate) {
            IBaguAnimate baguAnimate = (IBaguAnimate)entity;
            if (entity != null) {
                baguAnimate.getBaguController().startAnimation(resourceLocation);
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void handleStopAnimationPacket(Entity entity, ResourceLocation resourceLocation) {
        if (entity instanceof IBaguAnimate) {
            IBaguAnimate baguAnimate = (IBaguAnimate)entity;
            if (entity != null) {
                baguAnimate.getBaguController().stopAnimation(resourceLocation);
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void handleStopAllAnimationPacket(Entity entity) {
        if (entity instanceof IBaguAnimate) {
            IBaguAnimate baguAnimate = (IBaguAnimate)entity;
            if (entity != null) {
                baguAnimate.getBaguController().stopAllAnimation();
            }
        }
    }

    @Nullable
    public static BaguAnimationController getAnimationController(Entity entity) {
        if (entity instanceof IBaguAnimate) {
            IBaguAnimate baguAnimate = (IBaguAnimate)entity;
            return baguAnimate.getBaguController();
        }
        return null;
    }

    public static void sendAnimation(Entity entity, ResourceLocation resourceLocation) {
        PacketDistributor.sendToPlayersTrackingEntityAndSelf((Entity)entity, (CustomPacketPayload)new SyncBagusAnimationsMessage(entity.getId(), resourceLocation), (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    public static void sendStopAnimation(Entity entity, ResourceLocation resourceLocation) {
        PacketDistributor.sendToPlayersTrackingEntityAndSelf((Entity)entity, (CustomPacketPayload)new SyncBagusAnimationsStopMessage(entity.getId(), resourceLocation), (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    public static void sendStopAllAnimation(Entity entity) {
        PacketDistributor.sendToPlayersTrackingEntityAndSelf((Entity)entity, (CustomPacketPayload)new SyncBagusAnimationsStopAllMessage(entity.getId()), (CustomPacketPayload[])new CustomPacketPayload[0]);
    }
}

