/*
 * Decompiled with CFR 0.152.
 */
package com.smoothchunk.mixin;

import com.smoothchunk.SmoothchunkMod;
import com.smoothchunk.config.CommonConfiguration;
import com.smoothchunk.world.IChunkTimeSave;
import com.smoothchunk.world.PosTimeEntry;
import it.unimi.dsi.fastutil.longs.Long2ObjectLinkedOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectCollection;
import it.unimi.dsi.fastutil.objects.ObjectIterator;
import java.util.ArrayDeque;
import net.minecraft.server.level.ChunkHolder;
import net.minecraft.server.level.ChunkMap;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.ImposterProtoChunk;
import net.minecraft.world.level.chunk.LevelChunk;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Redirect;

@Mixin(value={ChunkMap.class})
public abstract class ChunkMapMixin {
    @Shadow
    @Final
    private ServerLevel level;
    @Shadow
    private volatile Long2ObjectLinkedOpenHashMap<ChunkHolder> visibleChunkMap;
    @Unique
    private final Long2ObjectLinkedOpenHashMap<ChunkHolder> emptyMap = new Long2ObjectLinkedOpenHashMap();
    @Unique
    private final ArrayDeque<PosTimeEntry> toSave = new ArrayDeque();

    @Shadow
    protected abstract boolean saveChunkIfNeeded(ChunkHolder var1);

    @Redirect(method={"processUnloads"}, at=@At(value="INVOKE", target="Lit/unimi/dsi/fastutil/objects/ObjectCollection;iterator()Lit/unimi/dsi/fastutil/objects/ObjectIterator;", remap=false))
    public ObjectIterator<ChunkHolder> smoothChunksaveChunks(ObjectCollection instance) {
        PosTimeEntry posTimeEntry;
        long currentGametime = this.level.getGameTime();
        if (currentGametime % 64L == 0L) {
            for (ChunkHolder entry : this.visibleChunkMap.values()) {
                ChunkAccess chunkaccess;
                if (!entry.wasAccessibleSinceLastSave() || !entry.isReadyForSaving() || !((chunkaccess = entry.getLatestChunk()) instanceof ImposterProtoChunk) && !(chunkaccess instanceof LevelChunk) || !chunkaccess.isUnsaved()) continue;
                long saveTimePoint = ((IChunkTimeSave)chunkaccess).smoothchunk$getNextSaveTime();
                if (saveTimePoint == 0L) {
                    ((IChunkTimeSave)chunkaccess).smoothchunk$setSaveTimePoint(currentGametime + (long)((CommonConfiguration)SmoothchunkMod.config.getCommonConfig()).chunkSaveDelay * 20L + (long)(SmoothchunkMod.rand.nextInt(20) * 20));
                    this.toSave.addLast(new PosTimeEntry(((IChunkTimeSave)chunkaccess).smoothchunk$getNextSaveTime(), entry.getPos()));
                    continue;
                }
                if (currentGametime <= saveTimePoint) continue;
                ((IChunkTimeSave)chunkaccess).smoothchunk$setSaveTimePoint(0L);
            }
        }
        int savedChunks = 0;
        for (int i = 0; i < 10 && (posTimeEntry = this.toSave.peek()) != null && currentGametime > posTimeEntry.savetime; ++i) {
            ChunkHolder holder = (ChunkHolder)this.visibleChunkMap.get(posTimeEntry.pos.toLong());
            if (holder != null && this.saveChunkIfNeeded(holder)) {
                ++savedChunks;
            }
            this.toSave.pop();
        }
        if (savedChunks > 0 && ((CommonConfiguration)SmoothchunkMod.config.getCommonConfig()).debugLogging) {
            SmoothchunkMod.LOGGER.info("Smoothchunks saved chunks this tick: " + savedChunks);
        }
        return this.emptyMap.values().iterator();
    }
}

