/*
 * Decompiled with CFR 0.152.
 */
package mekanism.tools.common.material;

import mekanism.api.annotations.NothingNullByDefault;
import mekanism.common.config.IMekanismConfig;
import mekanism.common.config.value.CachedFloatValue;
import mekanism.common.config.value.CachedIntValue;
import mekanism.tools.common.material.IPaxelMaterial;
import mekanism.tools.common.material.VanillaPaxelMaterial;
import net.minecraft.world.item.Tiers;
import net.neoforged.neoforge.common.ModConfigSpec;

@NothingNullByDefault
public class VanillaPaxelMaterialCreator
implements IPaxelMaterial {
    private final VanillaPaxelMaterial fallback;
    public final CachedFloatValue paxelDamage;
    public final CachedFloatValue paxelAtkSpeed;
    private final CachedFloatValue paxelEfficiency;
    private final CachedIntValue paxelEnchantability;
    private final CachedIntValue paxelMaxUses;

    public VanillaPaxelMaterialCreator(IMekanismConfig config, ModConfigSpec.Builder builder, VanillaPaxelMaterial materialDefaults) {
        this.fallback = materialDefaults;
        String toolKey = this.getRegistryPrefix();
        String name = this.getConfigCommentName();
        builder.comment("Vanilla Material Paxel Settings for " + name).push(toolKey);
        this.paxelDamage = CachedFloatValue.wrap((IMekanismConfig)config, (ModConfigSpec.ConfigValue)builder.comment("Attack damage modifier of " + name + " paxels.").define(toolKey + "PaxelDamage", (Object)materialDefaults.getPaxelDamage(), value -> {
            if (value instanceof Double) {
                double val = (Double)value;
                float actualValue = val > 3.4028234663852886E38 ? Float.MAX_VALUE : (val < -3.4028234663852886E38 ? -3.4028235E38f : (float)val);
                float baseDamage = this.getVanillaTier().getAttackDamageBonus();
                return actualValue >= -baseDamage && actualValue <= Float.MAX_VALUE - baseDamage;
            }
            return false;
        }));
        this.paxelAtkSpeed = CachedFloatValue.wrap((IMekanismConfig)config, (ModConfigSpec.ConfigValue)builder.comment("Attack speed of " + name + " paxels.").define(toolKey + "PaxelAtkSpeed", (Object)materialDefaults.getPaxelAtkSpeed()));
        this.paxelEfficiency = CachedFloatValue.wrap((IMekanismConfig)config, (ModConfigSpec.ConfigValue)builder.comment("Efficiency of " + name + " paxels.").define(toolKey + "PaxelEfficiency", (Object)materialDefaults.getPaxelEfficiency()));
        this.paxelEnchantability = CachedIntValue.wrap((IMekanismConfig)config, (ModConfigSpec.ConfigValue)builder.comment("Natural enchantability factor of " + name + " paxels.").defineInRange(toolKey + "PaxelEnchantability", materialDefaults.getPaxelEnchantability(), 0, Integer.MAX_VALUE));
        this.paxelMaxUses = CachedIntValue.wrap((IMekanismConfig)config, (ModConfigSpec.ConfigValue)builder.comment("Maximum durability of " + name + " paxels.").defineInRange(toolKey + "PaxelMaxUses", materialDefaults.getPaxelMaxUses(), 1, Integer.MAX_VALUE));
        builder.pop();
    }

    public Tiers getVanillaTier() {
        return this.fallback.getVanillaTier();
    }

    public String getRegistryPrefix() {
        return this.fallback.getRegistryPrefix();
    }

    @Override
    public int getPaxelMaxUses() {
        return this.paxelMaxUses.getOrDefault();
    }

    @Override
    public float getPaxelEfficiency() {
        return this.paxelEfficiency.get();
    }

    @Override
    public float getPaxelDamage() {
        return this.paxelDamage.getOrDefault();
    }

    @Override
    public float getPaxelAtkSpeed() {
        return this.paxelAtkSpeed.getOrDefault();
    }

    @Override
    public int getPaxelEnchantability() {
        return this.paxelEnchantability.get();
    }

    @Override
    public String getConfigCommentName() {
        return this.fallback.getConfigCommentName();
    }
}

