/*
 * Decompiled with CFR 0.152.
 */
package mekanism.tools.common.material.impl;

import mekanism.common.tags.MekanismTags;
import mekanism.tools.common.ToolsTags;
import mekanism.tools.common.material.BaseMekanismMaterial;
import net.minecraft.core.Holder;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.block.Block;
import org.jetbrains.annotations.NotNull;

public class BronzeMaterialDefaults
implements BaseMekanismMaterial {
    @Override
    public int getShieldDurability() {
        return 403;
    }

    @Override
    public float getAxeDamage() {
        return 7.0f;
    }

    @Override
    public float getAxeAtkSpeed() {
        return -3.0f;
    }

    public int getUses() {
        return 375;
    }

    public float getSpeed() {
        return 7.0f;
    }

    public float getAttackDamageBonus() {
        return 2.0f;
    }

    public int getEnchantmentValue() {
        return 10;
    }

    @Override
    public float toughness() {
        return 1.0f;
    }

    @Override
    public int getDurabilityForType(@NotNull ArmorItem.Type armorType) {
        return switch (armorType) {
            default -> throw new MatchException(null, null);
            case ArmorItem.Type.BOOTS -> 234;
            case ArmorItem.Type.LEGGINGS -> 270;
            case ArmorItem.Type.CHESTPLATE, ArmorItem.Type.BODY -> 288;
            case ArmorItem.Type.HELMET -> 198;
        };
    }

    @Override
    public int getDefense(@NotNull ArmorItem.Type armorType) {
        return switch (armorType) {
            case ArmorItem.Type.BOOTS -> 2;
            case ArmorItem.Type.LEGGINGS -> 6;
            case ArmorItem.Type.CHESTPLATE -> 7;
            case ArmorItem.Type.HELMET -> 3;
            default -> 0;
        };
    }

    @Override
    @NotNull
    public String getConfigCommentName() {
        return "Bronze";
    }

    @Override
    @NotNull
    public String getRegistryPrefix() {
        return "bronze";
    }

    @NotNull
    public TagKey<Block> getIncorrectBlocksForDrops() {
        return ToolsTags.Blocks.INCORRECT_FOR_BRONZE_TOOL;
    }

    @Override
    @NotNull
    public Holder<SoundEvent> equipSound() {
        return SoundEvents.ARMOR_EQUIP_IRON;
    }

    @NotNull
    public Ingredient getRepairIngredient() {
        return Ingredient.of((TagKey)MekanismTags.Items.INGOTS_BRONZE);
    }

    @Override
    public float knockbackResistance() {
        return 0.0f;
    }
}

