/*
 * Decompiled with CFR 0.152.
 */
package mekanism.tools.common.material.impl;

import mekanism.common.tags.MekanismTags;
import mekanism.tools.common.ToolsTags;
import mekanism.tools.common.material.BaseMekanismMaterial;
import net.minecraft.core.Holder;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.block.Block;
import org.jetbrains.annotations.NotNull;

public class RefinedObsidianMaterialDefaults
implements BaseMekanismMaterial {
    @Override
    public int getShieldDurability() {
        return 1680;
    }

    @Override
    public float getAxeDamage() {
        return 7.0f;
    }

    @Override
    public float getAxeAtkSpeed() {
        return -2.9f;
    }

    public int getUses() {
        return 4096;
    }

    public float getSpeed() {
        return 12.0f;
    }

    public float getAttackDamageBonus() {
        return 8.0f;
    }

    public int getEnchantmentValue() {
        return 18;
    }

    @Override
    public boolean burnsInFire() {
        return false;
    }

    @Override
    public float toughness() {
        return 5.0f;
    }

    @Override
    public int getDurabilityForType(@NotNull ArmorItem.Type armorType) {
        return switch (armorType) {
            default -> throw new MatchException(null, null);
            case ArmorItem.Type.BOOTS -> 975;
            case ArmorItem.Type.LEGGINGS -> 1125;
            case ArmorItem.Type.CHESTPLATE, ArmorItem.Type.BODY -> 1200;
            case ArmorItem.Type.HELMET -> 825;
        };
    }

    @Override
    public int getDefense(@NotNull ArmorItem.Type armorType) {
        return switch (armorType) {
            case ArmorItem.Type.BOOTS -> 5;
            case ArmorItem.Type.LEGGINGS -> 8;
            case ArmorItem.Type.CHESTPLATE -> 12;
            case ArmorItem.Type.HELMET -> 6;
            default -> 0;
        };
    }

    @Override
    @NotNull
    public String getConfigCommentName() {
        return "Refined Obsidian";
    }

    @Override
    @NotNull
    public String getRegistryPrefix() {
        return "refined_obsidian";
    }

    @NotNull
    public TagKey<Block> getIncorrectBlocksForDrops() {
        return ToolsTags.Blocks.INCORRECT_FOR_REFINED_OBSIDIAN_TOOL;
    }

    @Override
    @NotNull
    public Holder<SoundEvent> equipSound() {
        return SoundEvents.ARMOR_EQUIP_IRON;
    }

    @NotNull
    public Ingredient getRepairIngredient() {
        return Ingredient.of((TagKey)MekanismTags.Items.INGOTS_REFINED_OBSIDIAN);
    }

    @Override
    public float knockbackResistance() {
        return 0.2f;
    }
}

