/*
 * Decompiled with CFR 0.152.
 */
package mekanism.tools.common.registries;

import java.util.function.BiFunction;
import mekanism.common.registration.impl.ItemDeferredRegister;
import mekanism.common.registration.impl.ItemRegistryObject;
import mekanism.tools.common.config.MekanismToolsConfig;
import mekanism.tools.common.item.ItemMekanismArmor;
import mekanism.tools.common.item.ItemMekanismAxe;
import mekanism.tools.common.item.ItemMekanismHoe;
import mekanism.tools.common.item.ItemMekanismPaxel;
import mekanism.tools.common.item.ItemMekanismPickaxe;
import mekanism.tools.common.item.ItemMekanismShield;
import mekanism.tools.common.item.ItemMekanismShovel;
import mekanism.tools.common.item.ItemMekanismSword;
import mekanism.tools.common.item.ItemRefinedGlowstoneArmor;
import mekanism.tools.common.material.BaseMekanismMaterial;
import mekanism.tools.common.material.MaterialCreator;
import mekanism.tools.common.material.VanillaPaxelMaterialCreator;
import mekanism.tools.common.registries.ToolsArmorMaterials;
import net.minecraft.core.Holder;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Tiers;

public class ToolsItems {
    public static final ItemDeferredRegister ITEMS = new ItemDeferredRegister("mekanismtools");
    public static final ItemRegistryObject<ItemMekanismPaxel> WOOD_PAXEL = ToolsItems.registerPaxel(MekanismToolsConfig.materials.wood);
    public static final ItemRegistryObject<ItemMekanismPaxel> STONE_PAXEL = ToolsItems.registerPaxel(MekanismToolsConfig.materials.stone);
    public static final ItemRegistryObject<ItemMekanismPaxel> IRON_PAXEL = ToolsItems.registerPaxel(MekanismToolsConfig.materials.iron);
    public static final ItemRegistryObject<ItemMekanismPaxel> DIAMOND_PAXEL = ToolsItems.registerPaxel(MekanismToolsConfig.materials.diamond);
    public static final ItemRegistryObject<ItemMekanismPaxel> GOLD_PAXEL = ToolsItems.registerPaxel(MekanismToolsConfig.materials.gold);
    public static final ItemRegistryObject<ItemMekanismPaxel> NETHERITE_PAXEL = ToolsItems.registerPaxel(MekanismToolsConfig.materials.netherite);
    public static final ItemRegistryObject<ItemMekanismPickaxe> BRONZE_PICKAXE = ToolsItems.registerPickaxe(MekanismToolsConfig.materials.bronze);
    public static final ItemRegistryObject<ItemMekanismAxe> BRONZE_AXE = ToolsItems.registerAxe(MekanismToolsConfig.materials.bronze);
    public static final ItemRegistryObject<ItemMekanismShovel> BRONZE_SHOVEL = ToolsItems.registerShovel(MekanismToolsConfig.materials.bronze);
    public static final ItemRegistryObject<ItemMekanismHoe> BRONZE_HOE = ToolsItems.registerHoe(MekanismToolsConfig.materials.bronze);
    public static final ItemRegistryObject<ItemMekanismSword> BRONZE_SWORD = ToolsItems.registerSword(MekanismToolsConfig.materials.bronze);
    public static final ItemRegistryObject<ItemMekanismPaxel> BRONZE_PAXEL = ToolsItems.registerPaxel(MekanismToolsConfig.materials.bronze);
    public static final ItemRegistryObject<ItemMekanismArmor> BRONZE_HELMET = ToolsItems.registerArmor(ToolsArmorMaterials.BRONZE, MekanismToolsConfig.materials.bronze, ArmorItem.Type.HELMET);
    public static final ItemRegistryObject<ItemMekanismArmor> BRONZE_CHESTPLATE = ToolsItems.registerArmor(ToolsArmorMaterials.BRONZE, MekanismToolsConfig.materials.bronze, ArmorItem.Type.CHESTPLATE);
    public static final ItemRegistryObject<ItemMekanismArmor> BRONZE_LEGGINGS = ToolsItems.registerArmor(ToolsArmorMaterials.BRONZE, MekanismToolsConfig.materials.bronze, ArmorItem.Type.LEGGINGS);
    public static final ItemRegistryObject<ItemMekanismArmor> BRONZE_BOOTS = ToolsItems.registerArmor(ToolsArmorMaterials.BRONZE, MekanismToolsConfig.materials.bronze, ArmorItem.Type.BOOTS);
    public static final ItemRegistryObject<ItemMekanismShield> BRONZE_SHIELD = ToolsItems.registerShield(MekanismToolsConfig.materials.bronze);
    public static final ItemRegistryObject<ItemMekanismPickaxe> LAPIS_LAZULI_PICKAXE = ToolsItems.registerPickaxe(MekanismToolsConfig.materials.lapisLazuli);
    public static final ItemRegistryObject<ItemMekanismAxe> LAPIS_LAZULI_AXE = ToolsItems.registerAxe(MekanismToolsConfig.materials.lapisLazuli);
    public static final ItemRegistryObject<ItemMekanismShovel> LAPIS_LAZULI_SHOVEL = ToolsItems.registerShovel(MekanismToolsConfig.materials.lapisLazuli);
    public static final ItemRegistryObject<ItemMekanismHoe> LAPIS_LAZULI_HOE = ToolsItems.registerHoe(MekanismToolsConfig.materials.lapisLazuli);
    public static final ItemRegistryObject<ItemMekanismSword> LAPIS_LAZULI_SWORD = ToolsItems.registerSword(MekanismToolsConfig.materials.lapisLazuli);
    public static final ItemRegistryObject<ItemMekanismPaxel> LAPIS_LAZULI_PAXEL = ToolsItems.registerPaxel(MekanismToolsConfig.materials.lapisLazuli);
    public static final ItemRegistryObject<ItemMekanismArmor> LAPIS_LAZULI_HELMET = ToolsItems.registerArmor(ToolsArmorMaterials.LAPIS_LAZULI, MekanismToolsConfig.materials.lapisLazuli, ArmorItem.Type.HELMET);
    public static final ItemRegistryObject<ItemMekanismArmor> LAPIS_LAZULI_CHESTPLATE = ToolsItems.registerArmor(ToolsArmorMaterials.LAPIS_LAZULI, MekanismToolsConfig.materials.lapisLazuli, ArmorItem.Type.CHESTPLATE);
    public static final ItemRegistryObject<ItemMekanismArmor> LAPIS_LAZULI_LEGGINGS = ToolsItems.registerArmor(ToolsArmorMaterials.LAPIS_LAZULI, MekanismToolsConfig.materials.lapisLazuli, ArmorItem.Type.LEGGINGS);
    public static final ItemRegistryObject<ItemMekanismArmor> LAPIS_LAZULI_BOOTS = ToolsItems.registerArmor(ToolsArmorMaterials.LAPIS_LAZULI, MekanismToolsConfig.materials.lapisLazuli, ArmorItem.Type.BOOTS);
    public static final ItemRegistryObject<ItemMekanismShield> LAPIS_LAZULI_SHIELD = ToolsItems.registerShield(MekanismToolsConfig.materials.lapisLazuli);
    public static final ItemRegistryObject<ItemMekanismPickaxe> OSMIUM_PICKAXE = ToolsItems.registerPickaxe(MekanismToolsConfig.materials.osmium);
    public static final ItemRegistryObject<ItemMekanismAxe> OSMIUM_AXE = ToolsItems.registerAxe(MekanismToolsConfig.materials.osmium);
    public static final ItemRegistryObject<ItemMekanismShovel> OSMIUM_SHOVEL = ToolsItems.registerShovel(MekanismToolsConfig.materials.osmium);
    public static final ItemRegistryObject<ItemMekanismHoe> OSMIUM_HOE = ToolsItems.registerHoe(MekanismToolsConfig.materials.osmium);
    public static final ItemRegistryObject<ItemMekanismSword> OSMIUM_SWORD = ToolsItems.registerSword(MekanismToolsConfig.materials.osmium);
    public static final ItemRegistryObject<ItemMekanismPaxel> OSMIUM_PAXEL = ToolsItems.registerPaxel(MekanismToolsConfig.materials.osmium);
    public static final ItemRegistryObject<ItemMekanismArmor> OSMIUM_HELMET = ToolsItems.registerArmor(ToolsArmorMaterials.OSMIUM, MekanismToolsConfig.materials.osmium, ArmorItem.Type.HELMET);
    public static final ItemRegistryObject<ItemMekanismArmor> OSMIUM_CHESTPLATE = ToolsItems.registerArmor(ToolsArmorMaterials.OSMIUM, MekanismToolsConfig.materials.osmium, ArmorItem.Type.CHESTPLATE);
    public static final ItemRegistryObject<ItemMekanismArmor> OSMIUM_LEGGINGS = ToolsItems.registerArmor(ToolsArmorMaterials.OSMIUM, MekanismToolsConfig.materials.osmium, ArmorItem.Type.LEGGINGS);
    public static final ItemRegistryObject<ItemMekanismArmor> OSMIUM_BOOTS = ToolsItems.registerArmor(ToolsArmorMaterials.OSMIUM, MekanismToolsConfig.materials.osmium, ArmorItem.Type.BOOTS);
    public static final ItemRegistryObject<ItemMekanismShield> OSMIUM_SHIELD = ToolsItems.registerShield(MekanismToolsConfig.materials.osmium);
    public static final ItemRegistryObject<ItemMekanismPickaxe> REFINED_GLOWSTONE_PICKAXE = ToolsItems.registerPickaxe(MekanismToolsConfig.materials.refinedGlowstone);
    public static final ItemRegistryObject<ItemMekanismAxe> REFINED_GLOWSTONE_AXE = ToolsItems.registerAxe(MekanismToolsConfig.materials.refinedGlowstone);
    public static final ItemRegistryObject<ItemMekanismShovel> REFINED_GLOWSTONE_SHOVEL = ToolsItems.registerShovel(MekanismToolsConfig.materials.refinedGlowstone);
    public static final ItemRegistryObject<ItemMekanismHoe> REFINED_GLOWSTONE_HOE = ToolsItems.registerHoe(MekanismToolsConfig.materials.refinedGlowstone);
    public static final ItemRegistryObject<ItemMekanismSword> REFINED_GLOWSTONE_SWORD = ToolsItems.registerSword(MekanismToolsConfig.materials.refinedGlowstone);
    public static final ItemRegistryObject<ItemMekanismPaxel> REFINED_GLOWSTONE_PAXEL = ToolsItems.registerPaxel(MekanismToolsConfig.materials.refinedGlowstone);
    public static final ItemRegistryObject<ItemMekanismArmor> REFINED_GLOWSTONE_HELMET = ToolsItems.registerArmor(ToolsArmorMaterials.REFINED_GLOWSTONE, MekanismToolsConfig.materials.refinedGlowstone, ArmorItem.Type.HELMET, ItemRefinedGlowstoneArmor::new);
    public static final ItemRegistryObject<ItemMekanismArmor> REFINED_GLOWSTONE_CHESTPLATE = ToolsItems.registerArmor(ToolsArmorMaterials.REFINED_GLOWSTONE, MekanismToolsConfig.materials.refinedGlowstone, ArmorItem.Type.CHESTPLATE, ItemRefinedGlowstoneArmor::new);
    public static final ItemRegistryObject<ItemMekanismArmor> REFINED_GLOWSTONE_LEGGINGS = ToolsItems.registerArmor(ToolsArmorMaterials.REFINED_GLOWSTONE, MekanismToolsConfig.materials.refinedGlowstone, ArmorItem.Type.LEGGINGS, ItemRefinedGlowstoneArmor::new);
    public static final ItemRegistryObject<ItemMekanismArmor> REFINED_GLOWSTONE_BOOTS = ToolsItems.registerArmor(ToolsArmorMaterials.REFINED_GLOWSTONE, MekanismToolsConfig.materials.refinedGlowstone, ArmorItem.Type.BOOTS, ItemRefinedGlowstoneArmor::new);
    public static final ItemRegistryObject<ItemMekanismShield> REFINED_GLOWSTONE_SHIELD = ToolsItems.registerShield(MekanismToolsConfig.materials.refinedGlowstone);
    public static final ItemRegistryObject<ItemMekanismPickaxe> REFINED_OBSIDIAN_PICKAXE = ToolsItems.registerPickaxe(MekanismToolsConfig.materials.refinedObsidian);
    public static final ItemRegistryObject<ItemMekanismAxe> REFINED_OBSIDIAN_AXE = ToolsItems.registerAxe(MekanismToolsConfig.materials.refinedObsidian);
    public static final ItemRegistryObject<ItemMekanismShovel> REFINED_OBSIDIAN_SHOVEL = ToolsItems.registerShovel(MekanismToolsConfig.materials.refinedObsidian);
    public static final ItemRegistryObject<ItemMekanismHoe> REFINED_OBSIDIAN_HOE = ToolsItems.registerHoe(MekanismToolsConfig.materials.refinedObsidian);
    public static final ItemRegistryObject<ItemMekanismSword> REFINED_OBSIDIAN_SWORD = ToolsItems.registerSword(MekanismToolsConfig.materials.refinedObsidian);
    public static final ItemRegistryObject<ItemMekanismPaxel> REFINED_OBSIDIAN_PAXEL = ToolsItems.registerPaxel(MekanismToolsConfig.materials.refinedObsidian);
    public static final ItemRegistryObject<ItemMekanismArmor> REFINED_OBSIDIAN_HELMET = ToolsItems.registerArmor(ToolsArmorMaterials.REFINED_OBSIDIAN, MekanismToolsConfig.materials.refinedObsidian, ArmorItem.Type.HELMET);
    public static final ItemRegistryObject<ItemMekanismArmor> REFINED_OBSIDIAN_CHESTPLATE = ToolsItems.registerArmor(ToolsArmorMaterials.REFINED_OBSIDIAN, MekanismToolsConfig.materials.refinedObsidian, ArmorItem.Type.CHESTPLATE);
    public static final ItemRegistryObject<ItemMekanismArmor> REFINED_OBSIDIAN_LEGGINGS = ToolsItems.registerArmor(ToolsArmorMaterials.REFINED_OBSIDIAN, MekanismToolsConfig.materials.refinedObsidian, ArmorItem.Type.LEGGINGS);
    public static final ItemRegistryObject<ItemMekanismArmor> REFINED_OBSIDIAN_BOOTS = ToolsItems.registerArmor(ToolsArmorMaterials.REFINED_OBSIDIAN, MekanismToolsConfig.materials.refinedObsidian, ArmorItem.Type.BOOTS);
    public static final ItemRegistryObject<ItemMekanismShield> REFINED_OBSIDIAN_SHIELD = ToolsItems.registerShield(MekanismToolsConfig.materials.refinedObsidian);
    public static final ItemRegistryObject<ItemMekanismPickaxe> STEEL_PICKAXE = ToolsItems.registerPickaxe(MekanismToolsConfig.materials.steel);
    public static final ItemRegistryObject<ItemMekanismAxe> STEEL_AXE = ToolsItems.registerAxe(MekanismToolsConfig.materials.steel);
    public static final ItemRegistryObject<ItemMekanismShovel> STEEL_SHOVEL = ToolsItems.registerShovel(MekanismToolsConfig.materials.steel);
    public static final ItemRegistryObject<ItemMekanismHoe> STEEL_HOE = ToolsItems.registerHoe(MekanismToolsConfig.materials.steel);
    public static final ItemRegistryObject<ItemMekanismSword> STEEL_SWORD = ToolsItems.registerSword(MekanismToolsConfig.materials.steel);
    public static final ItemRegistryObject<ItemMekanismPaxel> STEEL_PAXEL = ToolsItems.registerPaxel(MekanismToolsConfig.materials.steel);
    public static final ItemRegistryObject<ItemMekanismArmor> STEEL_HELMET = ToolsItems.registerArmor(ToolsArmorMaterials.STEEL, MekanismToolsConfig.materials.steel, ArmorItem.Type.HELMET);
    public static final ItemRegistryObject<ItemMekanismArmor> STEEL_CHESTPLATE = ToolsItems.registerArmor(ToolsArmorMaterials.STEEL, MekanismToolsConfig.materials.steel, ArmorItem.Type.CHESTPLATE);
    public static final ItemRegistryObject<ItemMekanismArmor> STEEL_LEGGINGS = ToolsItems.registerArmor(ToolsArmorMaterials.STEEL, MekanismToolsConfig.materials.steel, ArmorItem.Type.LEGGINGS);
    public static final ItemRegistryObject<ItemMekanismArmor> STEEL_BOOTS = ToolsItems.registerArmor(ToolsArmorMaterials.STEEL, MekanismToolsConfig.materials.steel, ArmorItem.Type.BOOTS);
    public static final ItemRegistryObject<ItemMekanismShield> STEEL_SHIELD = ToolsItems.registerShield(MekanismToolsConfig.materials.steel);

    private ToolsItems() {
    }

    private static ItemRegistryObject<ItemMekanismShield> registerShield(MaterialCreator material) {
        return ToolsItems.register(ItemMekanismShield::new, "_shield", material);
    }

    private static ItemRegistryObject<ItemMekanismPickaxe> registerPickaxe(MaterialCreator material) {
        return ToolsItems.register(ItemMekanismPickaxe::new, "_pickaxe", material);
    }

    private static ItemRegistryObject<ItemMekanismAxe> registerAxe(MaterialCreator material) {
        return ToolsItems.register(ItemMekanismAxe::new, "_axe", material);
    }

    private static ItemRegistryObject<ItemMekanismShovel> registerShovel(MaterialCreator material) {
        return ToolsItems.register(ItemMekanismShovel::new, "_shovel", material);
    }

    private static ItemRegistryObject<ItemMekanismHoe> registerHoe(MaterialCreator material) {
        return ToolsItems.register(ItemMekanismHoe::new, "_hoe", material);
    }

    private static ItemRegistryObject<ItemMekanismSword> registerSword(MaterialCreator material) {
        return ToolsItems.register(ItemMekanismSword::new, "_sword", material);
    }

    private static ItemRegistryObject<ItemMekanismPaxel> registerPaxel(MaterialCreator material) {
        return ToolsItems.register(ItemMekanismPaxel::new, "_paxel", material);
    }

    private static ItemRegistryObject<ItemMekanismPaxel> registerPaxel(VanillaPaxelMaterialCreator material) {
        if (material.getVanillaTier() == Tiers.NETHERITE) {
            return ITEMS.registerUnburnable(material.getRegistryPrefix() + "_paxel", properties -> new ItemMekanismPaxel(material, (Item.Properties)properties));
        }
        return ITEMS.registerItem(material.getRegistryPrefix() + "_paxel", properties -> new ItemMekanismPaxel(material, (Item.Properties)properties));
    }

    private static ItemRegistryObject<ItemMekanismArmor> registerArmor(Holder<ArmorMaterial> armorMaterial, MaterialCreator material, ArmorItem.Type armorType) {
        return ToolsItems.registerArmor(armorMaterial, material, armorType, ItemMekanismArmor::new);
    }

    private static ItemRegistryObject<ItemMekanismArmor> registerArmor(Holder<ArmorMaterial> armorMaterial, MaterialCreator material, ArmorItem.Type armorType, ArmorCreator armorCreator) {
        return ITEMS.register(material.getRegistryPrefix() + "_" + armorType.getName(), () -> armorCreator.create(armorMaterial, armorType, ToolsItems.getBaseProperties(material).durability(material.getDurabilityForType(armorType))));
    }

    private static <ITEM extends Item> ItemRegistryObject<ITEM> register(BiFunction<MaterialCreator, Item.Properties, ITEM> itemCreator, String suffix, MaterialCreator material) {
        return ITEMS.register(material.getRegistryPrefix() + suffix, () -> (Item)itemCreator.apply(material, ToolsItems.getBaseProperties(material)));
    }

    private static Item.Properties getBaseProperties(BaseMekanismMaterial material) {
        Item.Properties properties = new Item.Properties();
        if (!material.burnsInFire()) {
            properties = properties.fireResistant();
        }
        return properties;
    }

    @FunctionalInterface
    private static interface ArmorCreator {
        public ItemMekanismArmor create(Holder<ArmorMaterial> var1, ArmorItem.Type var2, Item.Properties var3);
    }
}

