/*
 * Decompiled with CFR 0.152.
 */
package artifacts.ability;

import artifacts.ability.ArtifactAbility;
import artifacts.config.value.Value;
import artifacts.config.value.ValueTypes;
import artifacts.registry.ModAbilities;
import artifacts.registry.ModAttributes;
import artifacts.registry.ModSoundEvents;
import artifacts.util.AbilityHelper;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.netty.buffer.ByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.util.Mth;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.Vec3;

public record DoubleJumpAbility(Value<Boolean> enabled, Value<Double> sprintHorizontalVelocity, Value<Double> sprintVerticalVelocity) implements ArtifactAbility
{
    public static final MapCodec<DoubleJumpAbility> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)ValueTypes.enabledField().forGetter(DoubleJumpAbility::enabled), (App)ValueTypes.NON_NEGATIVE_DOUBLE.codec().optionalFieldOf("sprint_jump_horizontal_velocity", Value.of(0.0)).forGetter(DoubleJumpAbility::sprintHorizontalVelocity), (App)ValueTypes.NON_NEGATIVE_DOUBLE.codec().optionalFieldOf("sprint_jump_vertical_velocity", Value.of(0.0)).forGetter(DoubleJumpAbility::sprintVerticalVelocity)).apply((Applicative)instance, DoubleJumpAbility::new));
    public static final StreamCodec<ByteBuf, DoubleJumpAbility> STREAM_CODEC = StreamCodec.composite(ValueTypes.BOOLEAN.streamCodec(), DoubleJumpAbility::enabled, ValueTypes.NON_NEGATIVE_DOUBLE.streamCodec(), DoubleJumpAbility::sprintHorizontalVelocity, ValueTypes.NON_NEGATIVE_DOUBLE.streamCodec(), DoubleJumpAbility::sprintVerticalVelocity, DoubleJumpAbility::new);

    public static void jump(Player player) {
        player.fallDistance = 0.0f;
        double upwardsMotion = 0.5;
        if (player.hasEffect(MobEffects.JUMP)) {
            upwardsMotion += 0.1 * (double)(player.getEffect(MobEffects.JUMP).getAmplifier() + 1);
        }
        if (player.isSprinting()) {
            upwardsMotion *= 1.0 + AbilityHelper.maxDouble((ArtifactAbility.Type)ModAbilities.DOUBLE_JUMP.value(), (LivingEntity)player, ability -> (Double)ability.sprintVerticalVelocity().get(), false);
        }
        Vec3 motion = player.getDeltaMovement();
        double motionMultiplier = 0.0;
        if (player.isSprinting()) {
            motionMultiplier = AbilityHelper.maxDouble((ArtifactAbility.Type)ModAbilities.DOUBLE_JUMP.value(), (LivingEntity)player, ability -> (Double)ability.sprintHorizontalVelocity().get(), false);
        }
        float direction = (float)((double)player.getYRot() * Math.PI / 180.0);
        player.setDeltaMovement(player.getDeltaMovement().add((double)(-Mth.sin((float)direction)) * motionMultiplier, upwardsMotion - motion.y, (double)Mth.cos((float)direction) * motionMultiplier));
        player.hasImpulse = true;
        player.awardStat(Stats.JUMP);
        if (player.isSprinting()) {
            player.causeFoodExhaustion(0.2f);
        } else {
            player.causeFoodExhaustion(0.05f);
        }
        if (!player.level().isClientSide()) {
            double chance = player.getAttributeValue(ModAttributes.FLATULENCE);
            if ((double)player.getRandom().nextFloat() < chance) {
                player.level().playSound(null, (Entity)player, (SoundEvent)ModSoundEvents.FART.value(), SoundSource.PLAYERS, 1.0f, 0.9f + player.getRandom().nextFloat() * 0.2f);
            } else {
                player.level().playSound(null, (Entity)player, SoundEvents.WOOL_FALL, SoundSource.PLAYERS, 1.0f, 0.9f + player.getRandom().nextFloat() * 0.2f);
            }
        }
    }

    @Override
    public ArtifactAbility.Type<?> getType() {
        return (ArtifactAbility.Type)ModAbilities.DOUBLE_JUMP.value();
    }

    @Override
    public boolean isNonCosmetic() {
        return (Boolean)this.enabled().get();
    }
}

