/*
 * Decompiled with CFR 0.152.
 */
package artifacts.ability;

import artifacts.ability.ArtifactAbility;
import artifacts.config.value.Value;
import artifacts.config.value.ValueTypes;
import artifacts.registry.ModAbilities;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.Enchantments;

public record IncreaseEnchantmentLevelAbility(ResourceKey<Enchantment> enchantment, Value<Integer> amount) implements ArtifactAbility
{
    public static final List<ResourceKey<Enchantment>> ALLOWED_ENCHANTMENTS = List.of(Enchantments.FORTUNE, Enchantments.LOOTING, Enchantments.LURE, Enchantments.LUCK_OF_THE_SEA);
    public static final MapCodec<IncreaseEnchantmentLevelAbility> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)ResourceKey.codec((ResourceKey)Registries.ENCHANTMENT).validate(enchantment -> ALLOWED_ENCHANTMENTS.contains(enchantment) ? DataResult.success((Object)enchantment) : DataResult.error(() -> "Unsupported enchantment: %s".formatted(enchantment.location()))).fieldOf("enchantment").forGetter(IncreaseEnchantmentLevelAbility::enchantment), (App)ValueTypes.ENCHANTMENT_LEVEL.codec().optionalFieldOf("level", Value.of(1)).forGetter(IncreaseEnchantmentLevelAbility::amount)).apply((Applicative)instance, IncreaseEnchantmentLevelAbility::new));
    public static final StreamCodec<RegistryFriendlyByteBuf, IncreaseEnchantmentLevelAbility> STREAM_CODEC = StreamCodec.composite((StreamCodec)ResourceKey.streamCodec((ResourceKey)Registries.ENCHANTMENT), IncreaseEnchantmentLevelAbility::enchantment, ValueTypes.ENCHANTMENT_LEVEL.streamCodec(), IncreaseEnchantmentLevelAbility::amount, IncreaseEnchantmentLevelAbility::new);

    public int getAmount() {
        return (Integer)this.amount.get();
    }

    @Override
    public ArtifactAbility.Type<?> getType() {
        return (ArtifactAbility.Type)ModAbilities.INCREASE_ENCHANTMENT_LEVEL.value();
    }

    @Override
    public boolean isNonCosmetic() {
        return (Integer)this.amount().get() > 0;
    }

    @Override
    public void addAbilityTooltip(List<MutableComponent> tooltip) {
        String enchantmentName = this.enchantment().location().getPath();
        if (this.getAmount() == 1) {
            tooltip.add(this.tooltipLine("%s.single_level".formatted(enchantmentName), new Object[0]));
        } else {
            tooltip.add(this.tooltipLine("%s.multiple_levels".formatted(enchantmentName), this.getAmount()));
        }
    }
}

