/*
 * Decompiled with CFR 0.152.
 */
package artifacts.ability;

import artifacts.ability.ArtifactAbility;
import artifacts.component.SwimData;
import artifacts.config.value.Value;
import artifacts.config.value.ValueTypes;
import artifacts.platform.PlatformServices;
import artifacts.registry.ModAbilities;
import artifacts.registry.ModKeyMappings;
import artifacts.registry.ModSoundEvents;
import artifacts.util.AbilityHelper;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.netty.buffer.ByteBuf;
import java.util.List;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;

public record SwimInAirAbility(Value<Integer> flightDuration, Value<Integer> rechargeDuration) implements ArtifactAbility
{
    public static final MapCodec<SwimInAirAbility> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)ValueTypes.DURATION.codec().fieldOf("flight_duration").forGetter(SwimInAirAbility::flightDuration), (App)ValueTypes.DURATION.codec().fieldOf("recharge_duration").forGetter(SwimInAirAbility::rechargeDuration)).apply((Applicative)instance, SwimInAirAbility::new));
    public static final StreamCodec<ByteBuf, SwimInAirAbility> STREAM_CODEC = StreamCodec.composite(ValueTypes.DURATION.streamCodec(), SwimInAirAbility::flightDuration, ValueTypes.DURATION.streamCodec(), SwimInAirAbility::rechargeDuration, SwimInAirAbility::new);

    public static void onHeliumFlamingoTick(Player player) {
        boolean canFly;
        SwimData swimData = PlatformServices.platformHelper.getSwimData((LivingEntity)player);
        if (swimData == null) {
            return;
        }
        int maxFlightTime = SwimInAirAbility.getFlightDuration((LivingEntity)player);
        boolean shouldSink = AbilityHelper.hasAbilityActive((ArtifactAbility.Type)ModAbilities.SINKING.value(), (LivingEntity)player);
        boolean bl = canFly = maxFlightTime > 0;
        if (swimData.isSwimming()) {
            if (swimData.getSwimTime() > maxFlightTime || player.isInWater() && !player.isSwimming() && !shouldSink || (!player.isInWater() || shouldSink) && player.onGround()) {
                swimData.setSwimming((LivingEntity)player, false);
                if (!player.onGround() && !player.isInWater()) {
                    player.playSound((SoundEvent)ModSoundEvents.POP.value(), 0.5f, 0.75f);
                }
            }
            if (canFly && !PlatformServices.platformHelper.isEyeInWater(player) && !player.getAbilities().invulnerable) {
                swimData.setSwimTime(swimData.getSwimTime() + 1);
            }
        } else if (swimData.getSwimTime() < 0) {
            int rechargeTime = SwimInAirAbility.getRechargeDuration((LivingEntity)player);
            swimData.setSwimTime(swimData.getSwimTime() < -rechargeTime ? -rechargeTime : swimData.getSwimTime() + 1);
        }
    }

    public static int getFlightDuration(LivingEntity entity) {
        return AbilityHelper.maxInt((ArtifactAbility.Type)ModAbilities.SWIM_IN_AIR.value(), entity, ability -> (Integer)ability.flightDuration().get() * 20, false);
    }

    public static int getRechargeDuration(LivingEntity entity) {
        return Math.max(20, AbilityHelper.maxInt((ArtifactAbility.Type)ModAbilities.SWIM_IN_AIR.value(), entity, ability -> (Integer)ability.rechargeDuration().get() * 20, false));
    }

    @Override
    public ArtifactAbility.Type<?> getType() {
        return (ArtifactAbility.Type)ModAbilities.SWIM_IN_AIR.value();
    }

    @Override
    public boolean isNonCosmetic() {
        return (Integer)this.flightDuration().get() > 0;
    }

    @Override
    public void addAbilityTooltip(List<MutableComponent> tooltip) {
        tooltip.add(this.tooltipLine("swimming", new Object[0]));
    }

    @Override
    public void addToggleKeyTooltip(List<MutableComponent> tooltip) {
        tooltip.add(this.tooltipLine("keymapping", ModKeyMappings.getHeliumFlamingoKey().getTranslatedKeyMessage()));
    }
}

