/*
 * Decompiled with CFR 0.152.
 */
package artifacts.ability.mobeffect;

import artifacts.ability.ArtifactAbility;
import artifacts.ability.mobeffect.MobEffectAbility;
import artifacts.config.value.Value;
import artifacts.config.value.ValueTypes;
import artifacts.registry.ModAbilities;
import artifacts.util.AbilityHelper;
import artifacts.util.DamageSourceHelper;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.architectury.event.EventResult;
import java.util.List;
import java.util.Set;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceKey;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;

public record AttacksInflictMobEffectAbility(Holder<MobEffect> mobEffect, Value<Integer> level, Value<Integer> duration, Value<Integer> cooldown, Value<Double> chance) implements MobEffectAbility
{
    private static final Set<Holder<MobEffect>> CUSTOM_TOOLTIP_MOB_EFFECTS = Set.of(MobEffects.WITHER);
    public static final MapCodec<AttacksInflictMobEffectAbility> CODEC = RecordCodecBuilder.mapCodec(instance -> MobEffectAbility.codecStartWithDuration(instance).and((App)ValueTypes.cooldownField().forGetter(AttacksInflictMobEffectAbility::cooldown)).and((App)ValueTypes.FRACTION.codec().optionalFieldOf("chance", Value.of(1.0)).forGetter(AttacksInflictMobEffectAbility::chance)).apply((Applicative)instance, AttacksInflictMobEffectAbility::new));
    public static final StreamCodec<RegistryFriendlyByteBuf, AttacksInflictMobEffectAbility> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.holderRegistry((ResourceKey)Registries.MOB_EFFECT), AttacksInflictMobEffectAbility::mobEffect, ValueTypes.MOB_EFFECT_LEVEL.streamCodec(), AttacksInflictMobEffectAbility::level, ValueTypes.DURATION.streamCodec(), AttacksInflictMobEffectAbility::duration, ValueTypes.DURATION.streamCodec(), AttacksInflictMobEffectAbility::cooldown, ValueTypes.FRACTION.streamCodec(), AttacksInflictMobEffectAbility::chance, AttacksInflictMobEffectAbility::new);

    public static EventResult onLivingHurt(LivingEntity entity, DamageSource damageSource, float amount) {
        LivingEntity attacker = DamageSourceHelper.getAttacker(damageSource);
        if (attacker != null && DamageSourceHelper.isMeleeAttack(damageSource) && !entity.level().isClientSide()) {
            AbilityHelper.forEach((ArtifactAbility.Type)ModAbilities.ATTACKS_INFLICT_MOB_EFFECT.value(), attacker, (ability, stack) -> {
                if (entity.getRandom().nextDouble() < (Double)ability.chance().get()) {
                    entity.addEffect(ability.createEffect(attacker), (Entity)attacker);
                    if (attacker instanceof Player) {
                        Player player = (Player)attacker;
                        player.getCooldowns().addCooldown(stack.getItem(), (Integer)ability.cooldown().get() * 20);
                    }
                }
            }, true);
        }
        return EventResult.pass();
    }

    @Override
    public boolean isVisible() {
        return true;
    }

    @Override
    public ArtifactAbility.Type<?> getType() {
        return (ArtifactAbility.Type)ModAbilities.ATTACKS_INFLICT_MOB_EFFECT.value();
    }

    @Override
    public boolean isNonCosmetic() {
        return (Integer)this.duration().get() > 0 && (Integer)this.level().get() > 0 && (Double)this.chance().get() > 0.0;
    }

    @Override
    public void addAbilityTooltip(List<MutableComponent> tooltip) {
        for (Holder<MobEffect> mobEffect : CUSTOM_TOOLTIP_MOB_EFFECTS) {
            if (!mobEffect.isBound() || mobEffect.value() != this.mobEffect().value()) continue;
            String name = BuiltInRegistries.MOB_EFFECT.getKey((Object)((MobEffect)mobEffect.value())).getPath();
            if (Mth.equal((double)((Double)this.chance().get()), (double)1.0)) {
                tooltip.add(this.tooltipLine(name + ".constant", new Object[0]));
            } else {
                tooltip.add(this.tooltipLine(name + ".chance", new Object[0]));
            }
            return;
        }
    }
}

