/*
 * Decompiled with CFR 0.152.
 */
package artifacts.ability.retaliation;

import artifacts.ability.ArtifactAbility;
import artifacts.ability.retaliation.RetaliationAbility;
import artifacts.config.value.Value;
import artifacts.config.value.ValueTypes;
import artifacts.registry.ModAbilities;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.netty.buffer.ByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;

public class ThornsAbility
extends RetaliationAbility {
    public static final MapCodec<ThornsAbility> CODEC = RecordCodecBuilder.mapCodec(instance -> ThornsAbility.codecStart(instance).and((App)ValueTypes.NON_NEGATIVE_INT.codec().fieldOf("min_damage").forGetter(ThornsAbility::minDamage)).and((App)ValueTypes.NON_NEGATIVE_INT.codec().fieldOf("max_damage").forGetter(ThornsAbility::maxDamage)).apply((Applicative)instance, ThornsAbility::new));
    public static final StreamCodec<ByteBuf, ThornsAbility> STREAM_CODEC = StreamCodec.composite(ValueTypes.FRACTION.streamCodec(), RetaliationAbility::strikeChance, ValueTypes.DURATION.streamCodec(), RetaliationAbility::cooldown, ValueTypes.NON_NEGATIVE_INT.streamCodec(), ThornsAbility::minDamage, ValueTypes.NON_NEGATIVE_INT.streamCodec(), ThornsAbility::maxDamage, ThornsAbility::new);
    private final Value<Integer> minDamage;
    private final Value<Integer> maxDamage;

    public ThornsAbility(Value<Double> strikeChance, Value<Integer> cooldown, Value<Integer> minDamage, Value<Integer> maxDamage) {
        super(strikeChance, cooldown);
        this.minDamage = minDamage;
        this.maxDamage = maxDamage;
    }

    public Value<Integer> minDamage() {
        return this.minDamage;
    }

    public Value<Integer> maxDamage() {
        return this.maxDamage;
    }

    @Override
    public ArtifactAbility.Type<?> getType() {
        return (ArtifactAbility.Type)ModAbilities.THORNS.value();
    }

    @Override
    public boolean isNonCosmetic() {
        return super.isNonCosmetic() && (Integer)this.maxDamage().get() > 0;
    }

    @Override
    protected void applyEffect(LivingEntity target, LivingEntity attacker) {
        if (attacker.attackable()) {
            int damage;
            int minDamage = (Integer)this.minDamage().get();
            int maxDamage = (Integer)this.maxDamage().get();
            if (maxDamage < minDamage) {
                minDamage = maxDamage;
            }
            if ((damage = minDamage + target.getRandom().nextInt(maxDamage - minDamage + 1)) > 0) {
                attacker.hurt(target.damageSources().thorns((Entity)target), (float)damage);
            }
        }
    }
}

