/*
 * Decompiled with CFR 0.152.
 */
package artifacts.client.item.model;

import com.google.common.collect.ImmutableList;
import java.util.function.Function;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.LivingEntity;

public class ScarfModel
extends HumanoidModel<LivingEntity> {
    private final ModelPart cloak;

    public ScarfModel(ModelPart part, Function<ResourceLocation, RenderType> renderType) {
        super(part, renderType);
        this.cloak = this.body.getChild("cloak");
    }

    protected Iterable<ModelPart> headParts() {
        return ImmutableList.of((Object)this.head);
    }

    protected Iterable<ModelPart> bodyParts() {
        return ImmutableList.of((Object)this.body);
    }

    public void prepareMobModel(LivingEntity entity, float limbSwing, float limbSwingAmount, float partialTicks) {
        if (entity instanceof AbstractClientPlayer) {
            AbstractClientPlayer player = (AbstractClientPlayer)entity;
            double x = Mth.lerp((double)partialTicks, (double)player.xCloakO, (double)player.xCloak) - Mth.lerp((double)partialTicks, (double)player.xo, (double)player.getX());
            double y = Mth.lerp((double)partialTicks, (double)player.yCloakO, (double)player.yCloak) - Mth.lerp((double)partialTicks, (double)player.yo, (double)player.getY());
            double z = Mth.lerp((double)partialTicks, (double)player.zCloakO, (double)player.zCloak) - Mth.lerp((double)partialTicks, (double)player.zo, (double)player.getZ());
            float f = player.yBodyRotO + (player.yBodyRot - player.yBodyRotO);
            double d3 = Mth.sin((float)(f * ((float)Math.PI / 180)));
            double d4 = -Mth.cos((float)(f * ((float)Math.PI / 180)));
            float f1 = (float)y * 10.0f;
            f1 = Mth.clamp((float)f1, (float)-6.0f, (float)32.0f);
            float f2 = (float)(x * d3 + z * d4) * 100.0f;
            if ((f2 = Mth.clamp((float)f2, (float)0.0f, (float)150.0f)) < 0.0f) {
                f2 = 0.0f;
            }
            float f4 = Mth.lerp((float)partialTicks, (float)player.oBob, (float)player.bob);
            this.cloak.xRot = this.body.xRot + (6.0f + f2 / 2.0f + (f1 += Mth.sin((float)(Mth.lerp((float)partialTicks, (float)player.walkDistO, (float)player.walkDist) * 6.0f)) * 32.0f * f4)) / 180.0f * (float)Math.PI;
        }
    }

    public static MeshDefinition createScarf() {
        MeshDefinition mesh = ScarfModel.createMesh((CubeDeformation)new CubeDeformation(0.5f), (float)0.0f);
        mesh.getRoot().addOrReplaceChild("body", CubeListBuilder.create().texOffs(0, 16).addBox(-6.01f, -2.0f, -4.0f, 12.0f, 6.0f, 8.0f), PartPose.ZERO);
        mesh.getRoot().getChild("body").addOrReplaceChild("cloak", CubeListBuilder.create().texOffs(32, 0).addBox(-5.0f, 0.0f, 0.0f, 5.0f, 12.0f, 2.0f), PartPose.offset((float)0.0f, (float)0.0f, (float)1.99f));
        return mesh;
    }
}

