/*
 * Decompiled with CFR 0.152.
 */
package artifacts.neoforge;

import artifacts.Artifacts;
import artifacts.config.screen.ArtifactsConfigScreen;
import artifacts.neoforge.ArtifactsData;
import artifacts.neoforge.ArtifactsNeoForgeClient;
import artifacts.neoforge.event.ArtifactEventsNeoForge;
import artifacts.neoforge.event.SwimEventsNeoForge;
import artifacts.neoforge.integration.curios.CuriosIntegration;
import artifacts.neoforge.registry.ModAttachmentTypes;
import artifacts.neoforge.registry.ModLootModifiers;
import artifacts.registry.ModAttributes;
import artifacts.registry.ModItems;
import artifacts.registry.RegistryHolder;
import java.util.List;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.fml.ModList;
import net.neoforged.fml.ModLoadingContext;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.loading.FMLEnvironment;
import net.neoforged.neoforge.client.gui.IConfigScreenFactory;
import net.neoforged.neoforge.registries.DeferredRegister;

@Mod(value="artifacts")
public class ArtifactsNeoForge {
    public ArtifactsNeoForge(IEventBus modBus) {
        Artifacts.init();
        if (FMLEnvironment.dist == Dist.CLIENT) {
            new ArtifactsNeoForgeClient(modBus);
        }
        ModLootModifiers.LOOT_MODIFIERS.register(modBus);
        ModAttachmentTypes.ATTACHMENT_TYPES.register(modBus);
        this.register(modBus, Registries.ATTRIBUTE, ModAttributes.ATTRIBUTES);
        this.register(modBus, Registries.ITEM, ModItems.ITEMS);
        modBus.addListener(ArtifactsData::gatherData);
        this.registerConfig();
        ArtifactEventsNeoForge.register();
        SwimEventsNeoForge.register();
        if (ModList.get().isLoaded("curios")) {
            CuriosIntegration.setup(modBus);
        }
    }

    private void registerConfig() {
        ModLoadingContext.get().registerExtensionPoint(IConfigScreenFactory.class, () -> (client, parent) -> new ArtifactsConfigScreen(parent).build());
    }

    private <R> void register(IEventBus modBus, ResourceKey<Registry<R>> registry, List<RegistryHolder<R, ?>> holders) {
        DeferredRegister register = DeferredRegister.create(registry, (String)"artifacts");
        for (RegistryHolder<R, ?> holder : holders) {
            holder.bind((Holder<R>)register.register(holder.unwrapKey().orElseThrow().location().getPath(), holder.getFactory()));
        }
        register.register(modBus);
    }
}

