/*
 * Decompiled with CFR 0.152.
 */
package artifacts.network;

import artifacts.network.ChorusTotemUsedPacket;
import artifacts.network.DoubleJumpPacket;
import artifacts.network.PlaySoundAtPlayerPacket;
import artifacts.network.SwimPacket;
import artifacts.network.ToggleArtifactPacket;
import artifacts.network.UpdateArtifactTogglesPacket;
import artifacts.network.UpdateItemConfigPacket;
import dev.architectury.networking.NetworkManager;
import dev.architectury.platform.Platform;
import dev.architectury.utils.Env;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;

public class NetworkHandler {
    public static void register() {
        NetworkHandler.registerS2C(ChorusTotemUsedPacket.TYPE, ChorusTotemUsedPacket.CODEC, ChorusTotemUsedPacket::apply);
        NetworkHandler.registerS2C(PlaySoundAtPlayerPacket.TYPE, PlaySoundAtPlayerPacket.CODEC, PlaySoundAtPlayerPacket::apply);
        NetworkHandler.registerS2C(UpdateArtifactTogglesPacket.TYPE, UpdateArtifactTogglesPacket.CODEC, UpdateArtifactTogglesPacket::apply);
        NetworkHandler.registerS2C(UpdateItemConfigPacket.TYPE, UpdateItemConfigPacket.CODEC, UpdateItemConfigPacket::apply);
        NetworkHandler.registerC2S(DoubleJumpPacket.TYPE, DoubleJumpPacket.CODEC, DoubleJumpPacket::apply);
        NetworkHandler.registerC2S(SwimPacket.TYPE, SwimPacket.CODEC, SwimPacket::apply);
        NetworkHandler.registerC2S(ToggleArtifactPacket.TYPE, ToggleArtifactPacket.CODEC, ToggleArtifactPacket::apply);
    }

    private static <T extends CustomPacketPayload> void registerC2S(CustomPacketPayload.Type<T> type, StreamCodec<? super RegistryFriendlyByteBuf, T> codec, NetworkManager.NetworkReceiver<T> receiver) {
        NetworkManager.registerReceiver((NetworkManager.Side)NetworkManager.c2s(), type, codec, receiver);
    }

    private static <T extends CustomPacketPayload> void registerS2C(CustomPacketPayload.Type<T> type, StreamCodec<? super RegistryFriendlyByteBuf, T> codec, NetworkManager.NetworkReceiver<T> receiver) {
        if (Platform.getEnvironment() == Env.CLIENT) {
            NetworkManager.registerReceiver((NetworkManager.Side)NetworkManager.s2c(), type, codec, receiver);
        } else {
            NetworkManager.registerS2CPayloadType(type, codec);
        }
    }
}

