/*
 * Decompiled with CFR 0.152.
 */
package artifacts.network;

import artifacts.Artifacts;
import artifacts.ability.ArtifactAbility;
import artifacts.component.AbilityToggles;
import artifacts.platform.PlatformServices;
import artifacts.registry.ModAbilities;
import dev.architectury.networking.NetworkManager;
import java.util.List;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;

public record UpdateArtifactTogglesPacket(List<ArtifactAbility.Type<?>> toggles) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<UpdateArtifactTogglesPacket> TYPE = new CustomPacketPayload.Type(Artifacts.id("update_artifact_toggles"));
    public static final StreamCodec<FriendlyByteBuf, UpdateArtifactTogglesPacket> CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.list().apply(ResourceLocation.STREAM_CODEC.map(arg_0 -> ModAbilities.REGISTRY.get(arg_0), arg_0 -> ModAbilities.REGISTRY.getId(arg_0))), UpdateArtifactTogglesPacket::toggles, UpdateArtifactTogglesPacket::new);

    void apply(NetworkManager.PacketContext context) {
        AbilityToggles abilityToggles;
        Player player = context.getPlayer();
        if (player != null && (abilityToggles = PlatformServices.platformHelper.getAbilityToggles((LivingEntity)player)) != null) {
            abilityToggles.applyToggles(this.toggles, (LivingEntity)context.getPlayer());
        }
    }

    public CustomPacketPayload.Type<UpdateArtifactTogglesPacket> type() {
        return TYPE;
    }
}

