/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.kleeslabs.converter;

import java.util.Optional;
import net.blay09.mods.kleeslabs.converter.SlabConverter;
import net.minecraft.core.BlockPos;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.SlabType;

public class SmarterSlabConverter
implements SlabConverter {
    private Block slabBlock;

    public SmarterSlabConverter(Block slabBlock) {
        this.slabBlock = slabBlock;
    }

    @Override
    public BlockState getSingleSlab(BlockState state, Level level, BlockPos pos, Player player, SlabType slabType) {
        BlockState newState = this.slabBlock.defaultBlockState();
        for (Property property : state.getProperties()) {
            if (property.getName().equals("half")) {
                newState = this.getHalfBlockState(newState, property, slabType);
                continue;
            }
            newState = this.copyProperty(state, newState, property);
        }
        return newState;
    }

    @Override
    public boolean isDoubleSlab(BlockState state) {
        for (Property property : state.getProperties()) {
            StringRepresentable value;
            if (!property.getName().equals("half") || !(value = (StringRepresentable)state.getValue(property)).getSerializedName().equals("full")) continue;
            return true;
        }
        return false;
    }

    private <T extends Comparable<T>> BlockState copyProperty(BlockState sourceState, BlockState targetState, Property<T> property) {
        return (BlockState)targetState.setValue(property, sourceState.getValue(property));
    }

    private <T extends Comparable<T>> BlockState getHalfBlockState(BlockState state, Property<T> property, SlabType slabType) {
        Optional parsedValue = Optional.empty();
        if (slabType == SlabType.BOTTOM) {
            parsedValue = property.getValue("bottom");
        } else if (slabType == SlabType.TOP) {
            parsedValue = property.getValue("top");
        }
        return parsedValue.map(t -> (BlockState)state.setValue(property, t)).orElse(state);
    }
}

