/*
 * Decompiled with CFR 0.152.
 */
package mekanism.generators.client.gui;

import java.util.ArrayList;
import java.util.List;
import mekanism.api.energy.IEnergyContainer;
import mekanism.api.text.EnumColor;
import mekanism.client.gui.GuiMekanismTile;
import mekanism.client.gui.IGuiWrapper;
import mekanism.client.gui.element.GuiElement;
import mekanism.client.gui.element.GuiInnerScreen;
import mekanism.client.gui.element.bar.GuiVerticalPowerBar;
import mekanism.client.gui.element.tab.GuiEnergyTab;
import mekanism.common.MekanismLang;
import mekanism.common.inventory.container.tile.MekanismTileContainer;
import mekanism.common.util.MekanismUtils;
import mekanism.common.util.text.EnergyDisplay;
import mekanism.generators.client.gui.element.GuiStateTexture;
import mekanism.generators.common.GeneratorsLang;
import mekanism.generators.common.MekanismGenerators;
import mekanism.generators.common.tile.TileEntityWindGenerator;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Inventory;
import org.jetbrains.annotations.NotNull;

public class GuiWindGenerator
extends GuiMekanismTile<TileEntityWindGenerator, MekanismTileContainer<TileEntityWindGenerator>> {
    public GuiWindGenerator(MekanismTileContainer<TileEntityWindGenerator> container, Inventory inv, Component title) {
        super(container, inv, title);
        this.dynamicSlots = true;
    }

    protected void addGuiElements() {
        super.addGuiElements();
        this.addRenderableWidget((GuiElement)new GuiInnerScreen((IGuiWrapper)this, 48, 21, 80, 44, () -> {
            ArrayList<Object> list = new ArrayList<Object>();
            list.add(EnergyDisplay.of((IEnergyContainer)((TileEntityWindGenerator)this.tile).getEnergyContainer()).getTextComponent());
            long amount = ((TileEntityWindGenerator)this.tile).getCurrentGeneration();
            list.add(GeneratorsLang.POWER.translate(new Object[]{MekanismUtils.getEnergyDisplayShort((long)amount)}));
            list.add(GeneratorsLang.OUTPUT_RATE_SHORT.translate(new Object[]{EnergyDisplay.of((long)((TileEntityWindGenerator)this.tile).getMaxOutput())}));
            if (!((TileEntityWindGenerator)this.tile).getActive()) {
                GeneratorsLang reason = ((TileEntityWindGenerator)this.tile).isBlacklistDimension() ? GeneratorsLang.NO_WIND : GeneratorsLang.SKY_BLOCKED;
                list.add(reason.translateColored(EnumColor.DARK_RED));
            }
            return list;
        }));
        this.addRenderableWidget((GuiElement)new GuiEnergyTab((IGuiWrapper)this, () -> List.of(GeneratorsLang.PRODUCING_AMOUNT.translate(new Object[]{((TileEntityWindGenerator)this.tile).getActive() ? EnergyDisplay.of((long)((TileEntityWindGenerator)this.tile).getCurrentGeneration()) : EnergyDisplay.ZERO}), MekanismLang.MAX_OUTPUT.translate(new Object[]{EnergyDisplay.of((long)((TileEntityWindGenerator)this.tile).getMaxOutput())}))));
        this.addRenderableWidget((GuiElement)new GuiVerticalPowerBar((IGuiWrapper)this, (IEnergyContainer)((TileEntityWindGenerator)this.tile).getEnergyContainer(), 164, 15));
        this.addRenderableWidget((GuiElement)new GuiStateTexture((IGuiWrapper)this, 18, 35, () -> ((TileEntityWindGenerator)((TileEntityWindGenerator)this.tile)).getActive(), MekanismGenerators.rl(MekanismUtils.ResourceType.GUI.getPrefix() + "wind_on.png"), MekanismGenerators.rl(MekanismUtils.ResourceType.GUI.getPrefix() + "wind_off.png")));
    }

    protected void drawForegroundText(@NotNull GuiGraphics guiGraphics, int mouseX, int mouseY) {
        this.renderTitleText(guiGraphics);
        this.drawString(guiGraphics, this.playerInventoryTitle, this.inventoryLabelX, this.inventoryLabelY, this.titleTextColor());
        super.drawForegroundText(guiGraphics, mouseX, mouseY);
    }
}

