/*
 * Decompiled with CFR 0.152.
 */
package mekanism.generators.client.recipe_viewer.jei;

import java.util.Collections;
import java.util.List;
import mekanism.api.text.EnumColor;
import mekanism.client.gui.IGuiWrapper;
import mekanism.client.gui.element.GuiElement;
import mekanism.client.gui.element.GuiInnerScreen;
import mekanism.client.gui.element.gauge.GaugeType;
import mekanism.client.gui.element.gauge.GuiFluidGauge;
import mekanism.client.gui.element.gauge.GuiGasGauge;
import mekanism.client.gui.element.gauge.GuiGauge;
import mekanism.client.recipe_viewer.jei.BaseRecipeCategory;
import mekanism.client.recipe_viewer.jei.MekanismJEI;
import mekanism.client.recipe_viewer.type.IRecipeViewerRecipeType;
import mekanism.common.MekanismLang;
import mekanism.common.util.MekanismUtils;
import mekanism.common.util.UnitDisplayUtils;
import mekanism.common.util.text.BooleanStateDisplay;
import mekanism.common.util.text.TextUtils;
import mekanism.generators.client.recipe_viewer.recipe.FissionRecipeViewerRecipe;
import mekanism.generators.common.GeneratorsLang;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FissionReactorRecipeCategory
extends BaseRecipeCategory<FissionRecipeViewerRecipe> {
    private final GuiGauge<?> coolantTank;
    private final GuiGauge<?> fuelTank;
    private final GuiGauge<?> heatedCoolantTank;
    private final GuiGauge<?> wasteTank;

    public FissionReactorRecipeCategory(IGuiHelper helper, IRecipeViewerRecipeType<FissionRecipeViewerRecipe> recipeType) {
        super(helper, recipeType);
        this.addElement((GuiElement)new GuiInnerScreen((IGuiWrapper)this, 45, 17, 105, 56, () -> List.of(MekanismLang.STATUS.translate(new Object[]{EnumColor.BRIGHT_GREEN, BooleanStateDisplay.ActiveDisabled.of((boolean)true)}), GeneratorsLang.GAS_BURN_RATE.translate(new Object[]{1.0}), GeneratorsLang.FISSION_HEATING_RATE.translate(new Object[]{0}), MekanismLang.TEMPERATURE.translate(new Object[]{EnumColor.BRIGHT_GREEN, MekanismUtils.getTemperatureDisplay((double)300.0, (UnitDisplayUtils.TemperatureUnit)UnitDisplayUtils.TemperatureUnit.KELVIN, (boolean)true)}), GeneratorsLang.FISSION_DAMAGE.translate(new Object[]{EnumColor.BRIGHT_GREEN, TextUtils.getPercent((double)0.0)}))).spacing(2));
        this.coolantTank = (GuiGauge)this.addElement((GuiElement)GuiFluidGauge.getDummy((GaugeType)GaugeType.STANDARD, (IGuiWrapper)this, (int)6, (int)13).setLabel((Component)GeneratorsLang.FISSION_COOLANT_TANK.translateColored(EnumColor.AQUA)));
        this.fuelTank = (GuiGauge)this.addElement((GuiElement)GuiGasGauge.getDummy((GaugeType)GaugeType.STANDARD, (IGuiWrapper)this, (int)25, (int)13).setLabel((Component)GeneratorsLang.FISSION_FUEL_TANK.translateColored(EnumColor.DARK_GREEN)));
        this.heatedCoolantTank = (GuiGauge)this.addElement((GuiElement)GuiGasGauge.getDummy((GaugeType)GaugeType.STANDARD, (IGuiWrapper)this, (int)152, (int)13).setLabel((Component)GeneratorsLang.FISSION_HEATED_COOLANT_TANK.translateColored(EnumColor.GRAY)));
        this.wasteTank = (GuiGauge)this.addElement((GuiElement)GuiGasGauge.getDummy((GaugeType)GaugeType.STANDARD, (IGuiWrapper)this, (int)171, (int)13).setLabel((Component)GeneratorsLang.FISSION_WASTE_TANK.translateColored(EnumColor.BROWN)));
    }

    public void setRecipe(@NotNull IRecipeLayoutBuilder builder, FissionRecipeViewerRecipe recipe, @NotNull IFocusGroup focusGroup) {
        if (recipe.inputCoolant() == null) {
            this.initFluid(builder, RecipeIngredientRole.INPUT, this.coolantTank, recipe.waterInput().getRepresentations());
        } else {
            this.initChemical(builder, MekanismJEI.TYPE_GAS, RecipeIngredientRole.INPUT, (GuiElement)this.coolantTank, recipe.inputCoolant().getRepresentations());
        }
        this.initChemical(builder, MekanismJEI.TYPE_GAS, RecipeIngredientRole.INPUT, (GuiElement)this.fuelTank, recipe.fuel().getRepresentations());
        this.initChemical(builder, MekanismJEI.TYPE_GAS, RecipeIngredientRole.OUTPUT, (GuiElement)this.heatedCoolantTank, Collections.singletonList(recipe.outputCoolant()));
        this.initChemical(builder, MekanismJEI.TYPE_GAS, RecipeIngredientRole.OUTPUT, (GuiElement)this.wasteTank, Collections.singletonList(recipe.waste()));
    }

    @Nullable
    public ResourceLocation getRegistryName(@NotNull FissionRecipeViewerRecipe recipe) {
        return recipe.id();
    }
}

