/*
 * Decompiled with CFR 0.152.
 */
package mekanism.generators.client.recipe_viewer.recipe;

import java.util.ArrayList;
import java.util.List;
import mekanism.api.MekanismAPI;
import mekanism.api.chemical.gas.Gas;
import mekanism.api.chemical.gas.GasStack;
import mekanism.api.chemical.gas.attribute.GasAttributes;
import mekanism.api.math.MathUtils;
import mekanism.api.providers.IChemicalProvider;
import mekanism.api.recipes.ingredients.FluidStackIngredient;
import mekanism.api.recipes.ingredients.GasStackIngredient;
import mekanism.api.recipes.ingredients.creator.IngredientCreatorAccess;
import mekanism.client.recipe_viewer.RecipeViewerUtils;
import mekanism.client.recipe_viewer.emi.INamedRVRecipe;
import mekanism.common.registries.MekanismGases;
import mekanism.common.util.HeatUtils;
import mekanism.generators.common.MekanismGenerators;
import mekanism.generators.common.config.MekanismGeneratorsConfig;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.FluidTags;
import org.jetbrains.annotations.Nullable;

public record FissionRecipeViewerRecipe(ResourceLocation id, @Nullable GasStackIngredient inputCoolant, GasStackIngredient fuel, GasStack outputCoolant, GasStack waste) implements INamedRVRecipe
{
    public FluidStackIngredient waterInput() {
        return IngredientCreatorAccess.fluid().from(FluidTags.WATER, MathUtils.clampToInt((long)this.outputCoolant().getAmount()));
    }

    public static List<FissionRecipeViewerRecipe> getFissionRecipes() {
        ArrayList<FissionRecipeViewerRecipe> recipes = new ArrayList<FissionRecipeViewerRecipe>();
        long energyPerFuel = MekanismGeneratorsConfig.generators.energyPerFissionFuel.get();
        long coolantAmount = Math.round((double)energyPerFuel * HeatUtils.getSteamEnergyEfficiency() / HeatUtils.getWaterThermalEnthalpy());
        recipes.add(new FissionRecipeViewerRecipe(RecipeViewerUtils.synthetic((ResourceLocation)MekanismGenerators.rl("water"), (String)"fission"), null, (GasStackIngredient)IngredientCreatorAccess.gasStack().from((IChemicalProvider)MekanismGases.FISSILE_FUEL, 1L), MekanismGases.STEAM.getStack(coolantAmount), MekanismGases.NUCLEAR_WASTE.getStack(1L)));
        for (Gas gas : MekanismAPI.GAS_REGISTRY) {
            GasAttributes.CooledCoolant cooledCoolant = (GasAttributes.CooledCoolant)gas.get(GasAttributes.CooledCoolant.class);
            if (cooledCoolant == null) continue;
            Gas heatedCoolant = cooledCoolant.getHeatedGas();
            long amount = Math.round((double)energyPerFuel / cooledCoolant.getThermalEnthalpy());
            recipes.add(new FissionRecipeViewerRecipe(RecipeViewerUtils.synthetic((ResourceLocation)gas.getRegistryName(), (String)"fission", (String)"mekanismgenerators"), (GasStackIngredient)IngredientCreatorAccess.gasStack().from((IChemicalProvider)gas, amount), (GasStackIngredient)IngredientCreatorAccess.gasStack().from((IChemicalProvider)MekanismGases.FISSILE_FUEL, 1L), heatedCoolant.getStack(amount), MekanismGases.NUCLEAR_WASTE.getStack(1L)));
        }
        return recipes;
    }
}

