/*
 * Decompiled with CFR 0.152.
 */
package mekanism.generators.client.render;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import mekanism.api.annotations.NothingNullByDefault;
import mekanism.client.render.MekanismRenderer;
import mekanism.client.render.tileentity.IWireFrameRenderer;
import mekanism.client.render.tileentity.ModelTileEntityRenderer;
import mekanism.generators.client.model.ModelWindGenerator;
import mekanism.generators.common.tile.TileEntityWindGenerator;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.phys.AABB;

@NothingNullByDefault
public class RenderWindGenerator
extends ModelTileEntityRenderer<TileEntityWindGenerator, ModelWindGenerator>
implements IWireFrameRenderer {
    public RenderWindGenerator(BlockEntityRendererProvider.Context context) {
        super(context, ModelWindGenerator::new);
    }

    protected void render(TileEntityWindGenerator tile, float partialTick, PoseStack matrix, MultiBufferSource renderer, int light, int overlayLight, ProfilerFiller profiler) {
        double angle = this.setupRenderer(tile, partialTick, matrix);
        ((ModelWindGenerator)this.model).render(matrix, renderer, angle, light, overlayLight, false);
        matrix.popPose();
    }

    protected String getProfilerSection() {
        return "windGenerator";
    }

    public boolean shouldRenderOffScreen(TileEntityWindGenerator tile) {
        return true;
    }

    public AABB getRenderBoundingBox(TileEntityWindGenerator tile) {
        BlockPos pos = tile.getBlockPos();
        return AABB.encapsulatingFullBlocks((BlockPos)pos.offset(-2, 0, -2), (BlockPos)pos.offset(2, 6, 2));
    }

    public void renderWireFrame(BlockEntity tile, float partialTick, PoseStack matrix, VertexConsumer buffer) {
        if (tile instanceof TileEntityWindGenerator) {
            TileEntityWindGenerator windGenerator = (TileEntityWindGenerator)tile;
            double angle = this.setupRenderer(windGenerator, partialTick, matrix);
            ((ModelWindGenerator)this.model).renderWireFrame(matrix, buffer, angle);
            matrix.popPose();
        }
    }

    private double setupRenderer(TileEntityWindGenerator tile, float partialTick, PoseStack matrix) {
        matrix.pushPose();
        matrix.translate(0.5, 1.5, 0.5);
        MekanismRenderer.rotate((PoseStack)matrix, (Direction)tile.getDirection(), (float)0.0f, (float)180.0f, (float)90.0f, (float)270.0f);
        matrix.mulPose(Axis.ZP.rotationDegrees(180.0f));
        double angle = tile.getAngle();
        if (tile.getActive() && partialTick > 0.0f) {
            angle = (angle + (double)(tile.getHeightSpeedRatio() * partialTick)) % 360.0;
        }
        return angle;
    }
}

